var currentDoc = null, startOffset = 0;

function IsAlnum(a)
{
	return/[a-zA-Z0-9']+/.test(a);
}

function IsChinese(a)
{
    if(/[^\u4e00-\u9fa5]/.test(a))
        return false;
    return true;
}

window.addEventListener("load", InitPlugin, false);

function InitPlugin()
{
	var appcontent = document.getElementById("appcontent");
	
	if(appcontent)
		appcontent.addEventListener("load", InitPluginPageload, true);
}

function InitPluginPageload(event)
{
	try
	{
		var doc = event.originalTarget;
		
		// ֹ
		var obj = doc.getElementById("ciba_grabword_plugin");
		if(obj)
			return;

		var plugin_elediv = doc.createElement("div");
		plugin_elediv.innerHTML = "<embed id='ciba_grabword_plugin' type='application/ciba-grabword-plugin' hidden='true' width='0' height='0'/>";
		doc.body.appendChild(plugin_elediv);
		obj = doc.getElementById("ciba_grabword_plugin");
		obj = XPCNativeWrapper.unwrap(obj);
		doc.addEventListener("mousemove", OnMouseMove, true);
	}
	catch(e) {}
}

function OnMouseMove(event)
{
    var eventDoc = null;
    var doc = event.target.ownerDocument;
    if (String(doc).indexOf("[object HTMLDocument]") != -1)
    {
        eventDoc = doc;
    }
    if (eventDoc != null)
    {
        if (currentDoc != eventDoc)
        {
            currentDoc = eventDoc;
        }
        eventTarget = event.target;
        if (eventTarget.tagName != "TEXTAREA" || eventTarget.tagName != "INPUT"  || eventTarget.tagName != "SELECT")
        {
        	var plugin = doc.getElementById("ciba_grabword_plugin");
        	plugin = XPCNativeWrapper.unwrap(plugin);
        	var word = GetGrabWord(event.rangeParent, event.rangeOffset, event.target);
        	if (word != "")
        	{
        			plugin.SetGrabWord(word + ":" + startOffset);
        	}
        	else
        	{
        			plugin.SetGrabWord("");
        	}
        }
    }
}

function GetGrabWord(parent, offset, target)
{
	try
	{
		if (parent.parentNode != target)
			return "";
		if (parent.nodeType != 3)
			return "";
	}
	catch (e)
	{
		return "";
	}
	if (parent.parentNode) 
	{
		var foundNode = false;
		for (var c = parent.parentNode.firstChild; c !== null; c = c.nextSibling) 
		{
			if (c == parent)
			{
				foundNode = true;
				break;
			}
		}
		if (!foundNode)
			return "";
	}
	//
	var textRange = parent.ownerDocument.createRange();
	textRange.selectNode(parent);
	var wordRange = textRange.cloneRange();
	
	var start = offset, end = offset;
	startOffset = start;
	var frontNum = 0, backNum = 0; // ǰͺַ
	var c1 = 0, c2 = 0;
	var word = "";

	if(!textRange.startContainer.textContent)
		return "";
	
	var textNode = textRange.startContainer.childNodes[textRange.startOffset];
	for(; start > 0;)
	{// ǰַ
		wordRange.setStart(textNode, --start);
		word = wordRange.toString();
		if(!IsAlnum(word.charAt(0)))
		{
			if (IsChinese(word.charAt(0)))
				c1++;
			if (word.charAt(0) == " ")
				c2++;
				
			if((c1==0 && c2==0) || (c2==3) || (c1==5))
			{
				wordRange.setStart(textNode, ++start);
				break;
			}
		}
		frontNum++;
	}

	startOffset -= start;

	c1 = c2 = 0;
	for(; end < textNode.textContent.length;)
	{// ַ
		wordRange.setEnd(textNode, ++end);
		word = wordRange.toString();
		if(!IsAlnum(word.charAt(word.length - 1)))
		{
			if (IsChinese(word.charAt(word.length - 1)))
				c1++;
			if (word.charAt(word.length - 1) == " ")
				c2++;
			
			if((c1==0 && c2==0) || (c2==3) || (c1==5))
			{
				wordRange.setEnd(textNode, end - 1);
				break;
			}
		}
		backNum++;
	}
	
	word = "";
	if(frontNum + backNum > 0)
	{
		word = wordRange.toString();
		if (startOffset > word.length - 1)
			startOffset = word.length - 1;
	}
	
	return word;
}