const app = require('app');
const path = require('path');
var mkdirs = require('node-mkdirs');

const UPDATES_DIR = path.join(app.getPath('appData'), app.getName(), 'updates');
const APP_DIR = app.getAppPath();
const APP_DATA_DIR = path.join(app.getPath('appData'), app.getName());
const CACHE_DIR = path.join(APP_DATA_DIR, 'cache');
const DB_DIR = path.join(APP_DATA_DIR, `db`);
const DB_PATH = path.join(DB_DIR, `${app.getName()}.db`);

function isDebug() {
    return process.env.NODE_ENV == 'development'
}

// 确保目录存在
[DB_DIR, CACHE_DIR].map((d)=> mkdirs(d));

module.exports = {
    UPDATES_DIR,
    APP_DIR,
    CACHE_DIR,
    DB_PATH,
    isDebug
};