/*
==============================================================================
Filename: Default.aspx.cs

Description: Script for the Default.aspx web page

For installation and usage instructions see ReadMe.htm file

This file is part of the Print2Flash OLE Automation SDK samples

Copyright (C) Print2Flash Software. All rights reserved

This source code is intended only as a supplement to Print2Flash OLE 
Automation SDK and/or documentation. See Print2Flash documentation
and online help at http://print2flash.com for more information

THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE. 
*/

using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page 
{

    protected string swfUrl = ""; 
    protected string GetSwfUrlEncoded() 
    {
        return HttpUtility.HtmlEncode(swfUrl);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (cblDocOptions.Items.Count <= 0) 
        {
            int mask;
            mask = (int)Print2Flash3.INTERFACE_OPTION.INTLOGO;
            cblDocOptions.Items.Add(new ListItem("Print2Flash Logo", mask.ToString()));
            mask = (int)(Print2Flash3.INTERFACE_OPTION.INTPREVPAGE | Print2Flash3.INTERFACE_OPTION.INTGOTOPAGE | Print2Flash3.INTERFACE_OPTION.INTNEXTPAGE);
            cblDocOptions.Items.Add(new ListItem("Navigation controls", mask.ToString()));
            mask = (int)(Print2Flash3.INTERFACE_OPTION.INTFITWIDTH | Print2Flash3.INTERFACE_OPTION.INTFITPAGE | Print2Flash3.INTERFACE_OPTION.INTZOOMSLIDER | Print2Flash3.INTERFACE_OPTION.INTZOOMBOX);
            cblDocOptions.Items.Add(new ListItem("Zooming controls", mask.ToString()));
            mask = (int)(Print2Flash3.INTERFACE_OPTION.INTSEARCHBOX | Print2Flash3.INTERFACE_OPTION.INTSEARCHBUT);
            cblDocOptions.Items.Add(new ListItem("Search controls", mask.ToString()));
            mask = (int)(Print2Flash3.INTERFACE_OPTION.INTPRINT);
            cblDocOptions.Items.Add(new ListItem("Print button", mask.ToString()));
            mask = (int)(Print2Flash3.INTERFACE_OPTION.INTDRAG | Print2Flash3.INTERFACE_OPTION.INTSELTEXT | 
                Print2Flash3.INTERFACE_OPTION.INTROTATE | Print2Flash3.INTERFACE_OPTION.INTNEWWIND | 
                Print2Flash3.INTERFACE_OPTION.INTHELP | Print2Flash3.INTERFACE_OPTION.INTBACKBUTTON | 
                Print2Flash3.INTERFACE_OPTION.INTFORWARDBUTTON | Print2Flash3.INTERFACE_OPTION.INTFULLSCREEN);
            cblDocOptions.Items.Add(new ListItem("Other controls", mask.ToString()));

            for (int i = 0; i < cblDocOptions.Items.Count; i++)
                cblDocOptions.Items[i].Selected = true;
        }
    }

    protected void btnConvert_Click(object sender, EventArgs e)
    {
        if (!FileUpload1.HasFile)
        {
            Label1.Text = "Please select a file to convert";
            return;
        }
        Label1.Text = "";
        // upload
        String fs_filename = Server.MapPath("UploadedFiles/") + FileUpload1.FileName;
        String fs_convertedfilename = Server.MapPath("ConvertedFiles/") + FileUpload1.FileName + ".swf";
        try
        {
            FileUpload1.PostedFile.SaveAs(fs_filename);
        }
        catch (Exception ex)
        {
            Label1.Text += "File could not be uploaded. " + ex.Message;
            return;
        }
        // convert
        try
        {
            int interfaceOptions = 0;
            for (int i = 0; i < cblDocOptions.Items.Count; i++)
                if (cblDocOptions.Items[i].Selected)
                    interfaceOptions |= Int32.Parse(cblDocOptions.Items[i].Value);

            Print2Flash3.Server2 p2fServer = new Print2Flash3.Server2();
            p2fServer.DefaultProfile.InterfaceOptions = interfaceOptions;
            p2fServer.DefaultProfile.ProtectionOptions = (int)Print2Flash3.PROTECTION_OPTION.PROTENAPI;
            p2fServer.ConvertFile(fs_filename, fs_convertedfilename, null, null, null);
            Label1.Text += "File converted.";
            swfUrl = "ConvertedFiles/" + FileUpload1.FileName + ".swf";
        }
        catch (Exception ex)
        {
            Label1.Text += "File could not be converted. " + ex.Message;
            return;
        }
    }
}
