unit convertForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TfrmConvert = class(TForm)
    GroupBox1: TGroupBox;
    btnConvert: TButton;
    btnExit: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    btnBrowse: TButton;
    OpenDialog1: TOpenDialog;
    cbUseServer2: TCheckBox;
    cbLogo: TCheckBox;
    cbZoom: TCheckBox;
    cbPrint: TCheckBox;
    cbNavigation: TCheckBox;
    cbSearch: TCheckBox;
    cbOther: TCheckBox;
    lbTime: TLabel;
    procedure btnBrowseClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnConvertClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConvert: TfrmConvert;

implementation

uses Print2Flash3_TLB, Math, swfForm;

{$R *.dfm}

procedure TfrmConvert.btnBrowseClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
     Edit1.Text := OpenDialog1.FileName;
end;

procedure TfrmConvert.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmConvert.btnConvertClick(Sender: TObject);
var
  iSvr:IServer;
  InterfaceOptions : integer;
  frm:TfrmSwf;
  sourceFileName:string;
  dwTicks : DWORD;
begin
  sourceFileName := Edit1.Text;
  if not FileExists(sourceFileName) then begin
     FocusControl(Edit1);
     raise Exception.Create('please specify a file name');
  end;

  if cbUseServer2.Checked then
     iSvr := CoServer2.Create
  else
     iSvr := CoServer.Create;

  InterfaceOptions := 0;

  if cbLogo.Checked then
     InterfaceOptions := InterfaceOptions or INTLOGO;
  if cbNavigation.Checked then
     InterfaceOptions := InterfaceOptions or INTPREVPAGE or INTGOTOPAGE or INTNEXTPAGE;
  if cbZoom.Checked then
     InterfaceOptions := InterfaceOptions or INTFITWIDTH or INTFITPAGE or INTZOOMSLIDER or INTZOOMBOX;
  if cbSearch.Checked then
     InterfaceOptions := InterfaceOptions or INTSEARCHBOX or INTSEARCHBUT;
  if cbPrint.Checked then
     InterfaceOptions := InterfaceOptions or INTPRINT;
  if cbOther.Checked then
     InterfaceOptions := InterfaceOptions or INTDRAG or INTSELTEXT or INTROTATE or INTNEWWIND or INTHELP or INTBACKBUTTON or INTFORWARDBUTTON or INTFULLSCREEN;

  iSvr.DefaultProfile.InterfaceOptions := InterfaceOptions;
  iSvr.DefaultProfile.ProtectionOptions := 0;
  iSvr.DefaultProfile.FlashVersion := 8;
  iSvr.DefaultProfile.UseJpeg := true;
  iSvr.DefaultProfile.JpegQuality := 70;
  dwTicks := GetTickCount;
  iSvr.ConvertFile(sourceFileName,sourceFileName+'.swf',NULL,NULL,NULL);
  lbTime.Caption := IntToStr(GetTickCount - dwTicks) + ' ms';
  
  frm:=TfrmSwf.Create(Application);
  frm.Show;
  frm.Navigate(sourceFileName+'.swf');
end;

end.
