unit swfForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, SHDocVw;

type
  TfrmSwf = class(TForm)
    WebBrowser1: TWebBrowser;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Navigate(const fileName:string); 
  end;

var
  frmSwf: TfrmSwf;

implementation

{$R *.dfm}

function HtmlEncode(const ASrc:string):string;
var
  i: Integer;
const
  SafeChars = ['A'..'Z','a'..'z','0'..'9'];  {do not localize}
begin
  Result := '';    {Do not Localize}
  for i := 1 to Length(ASrc) do
  begin
    if not (ASrc[i] in SafeChars) then
      Result := Result + '&#'+FormatFloat('00',Ord(ASrc[i]))+';'
    else
      Result := Result + ASrc[i];
  end;
end;

Function GetTempFileName(const prefix:string; const ext:string):string;
var
  path : ShortString;
begin
  if GetTempPath(Sizeof(path)-2,@path[1]) = 0 then
     path := ExtractFilePath(ParamStr(0))
  else
     path[0] := Chr(StrLen(@path[1]));
  repeat
    Result:=IncludeTrailingPathDelimiter(path) + Prefix + IntToHEX(random($FFFFFFFF),8)+Ext;
  until not FileExists(Result);
end;

{ TfrmSwf }

procedure TfrmSwf.Navigate(const fileName: string);
var
  fs:TFileStream;
  sScript:String;
  sHtmlFileName:string;
begin
  Caption := fileName;
  fs := TFileStream.Create(IncludeTrailingPathDelimiter(ExtractFilePath(ParamStr(0)))+'script.html',fmOpenRead);
  try
    SetLength(sScript,fs.Size);
    fs.Read(PChar(sScript)^,fs.Size);
  finally
    fs.Free;
  end;
  sScript := StringReplace(sScript,'%%SWF_URL%%',HtmlEncode(fileName),[]);

  sHtmlFileName := fileName+'.html';
  fs := TFileStream.Create(sHtmlFileName,fmOpenWrite or fmCreate);
  try
    fs.Write(PChar(sScript)^,Length(sScript));
  finally
    fs.Free;
  end;

  WebBrowser1.Navigate('file://'+sHtmlFileName);
end;

end.
