using System;
using System.Web;
using System.IO;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;


/// <summary>
/// Summary description for WebService
/// </summary>
[WebService(Namespace = "http://print2flash.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class WebService : System.Web.Services.WebService {

    public WebService()
    {

        //Uncomment the following line if using designed components 
        //InitializeComponent(); 
    }

    private void InternalConvert(string InputFileName, string OutputFileName)
    {
        Print2Flash3.Server2 p2fServer = new Print2Flash3.Server2();
        p2fServer.ConvertFile(InputFileName, OutputFileName, null, null, null);
    }

    private string GetRandomDirName()
    { 
        string DirName;
        string BaseDir = Server.MapPath("WebServiceTemp/");
        do
        {
            DirName = System.IO.Path.GetRandomFileName();
        } while (System.IO.Directory.Exists(BaseDir + "\\"+DirName));
        System.IO.Directory.CreateDirectory(BaseDir + "\\" + DirName);
        return DirName;
    }

    private string SaveFile(byte[] inputFile, string FileName)
    { 
        string fn = Server.MapPath("WebServiceTemp/") + GetRandomDirName()+"\\"+FileName;
        System.IO.FileStream fs = new System.IO.FileStream(fn, System.IO.FileMode.Append);
        try {
            fs.Write(inputFile, 0, inputFile.Length);
        }
        finally {
            fs.Close();
        }
        return fn;
    }

    private byte[] GetStream(string fileName)
    {
        System.IO.FileStream fs = new System.IO.FileStream(fileName, System.IO.FileMode.Open);
        byte[] result = new byte[fs.Length];
        fs.Read(result, 0, result.Length);
        fs.Close();
        return result;
    }

    private string GetConvertedFileUrl(string OutputFileName)
    {
        string url = Context.Request.Url.AbsoluteUri;
        int idx = url.LastIndexOf("/WebService.asmx");
        if (idx >= 0)
            return url.Substring(0, idx) + "/WebServiceTemp/" + OutputFileName.Replace("\\","/");
        else
            throw new Exception("Invalid URL");
    }

    [WebMethod]
    public byte[] ConvertStreamToStream(byte[] inputFile, string FileName) 
    {
	FileName=Path.GetFileName(FileName);
        string OutputFileName = GetRandomDirName() + "\\" + FileName + ".swf";
        string fullOutputFileName = Server.MapPath("WebServiceTemp/") + OutputFileName;
        string fullIntputFileName = SaveFile(inputFile, FileName);
        InternalConvert(fullIntputFileName, fullOutputFileName);
        return GetStream(fullOutputFileName);
    }

    [WebMethod]
    public string ConvertStreamToUrl(byte[] inputFile, string FileName)
    {
        string OutputFileName = GetRandomDirName() + "\\" + FileName + ".swf";
        string fullOutputFileName = Server.MapPath("WebServiceTemp/") + OutputFileName;
        string fullIntputFileName = SaveFile(inputFile, FileName);
        InternalConvert(fullIntputFileName, fullOutputFileName);
        return GetConvertedFileUrl(OutputFileName);
    }
    
}

