using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class webservice : System.Web.UI.Page
{
    private localhost.WebService ws;

    protected string swfUrl = "";
    protected string GetSwfUrlEncoded()
    {
        return HttpUtility.HtmlEncode(swfUrl);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        ws = new localhost.WebService();
        ws.Url = Request.Url.AbsoluteUri.Replace("webservice.aspx", "WebService.asmx");
    }

    protected void btnConvert_Click(object sender, EventArgs e)
    {
        if (!FileUpload1.HasFile)
        {
            Label1.Text = "Please select a file to convert";
            return;
        }
        Label1.Text = "";
        // upload
        String fs_filename = Server.MapPath("UploadedFiles/") + FileUpload1.FileName;
        try
        {
            FileUpload1.PostedFile.SaveAs(fs_filename);
        }
        catch (Exception ex)
        {
            Label1.Text += "File could not be uploaded. " + ex.Message;
            return;
        }
        // read
        byte[] sourceFileArr;
        using (System.IO.FileStream fs = new System.IO.FileStream(fs_filename, System.IO.FileMode.Open))
            try
            {
                sourceFileArr = new byte[fs.Length];
                fs.Read(sourceFileArr, 0, sourceFileArr.Length);
            }
            catch (Exception ex)
            {
                fs.Close();
                Label1.Text += "Error reading file. " + ex.Message;
                return;
            }
        // convert
        try
        {
            if (RadioButtonList1.SelectedValue == "ConvertStreamToUrl")
            {
                swfUrl = ws.ConvertStreamToUrl(sourceFileArr, FileUpload1.FileName);
            }
            else if (RadioButtonList1.SelectedValue == "ConvertStreamToStream")
            {
                // convert
                byte[] outputFileArr = ws.ConvertStreamToStream(sourceFileArr, FileUpload1.FileName);
                // save file
                string outputFileName = System.IO.Path.GetRandomFileName() + ".swf";
                string fs_outputFileName = Server.MapPath("ConvertedFiles/") + outputFileName;
                System.IO.FileStream output_fs = new System.IO.FileStream(fs_outputFileName, System.IO.FileMode.Append);
                output_fs.Write(outputFileArr, 0, outputFileArr.Length);
                output_fs.Close();

                swfUrl = "ConvertedFiles/" + outputFileName;
            }
        }
        catch (Exception ex)
        {
            Label1.Text += "Error converting file. " + ex.Message;
            return;
        }
    }
}
