// Convert.cpp : implementation file
//

#include "stdafx.h"
#include "convert2swf.h"
#include "Convert.h"


// CConvertDlg dialog

IMPLEMENT_DYNAMIC(CConvertDlg, CDialog)

CConvertDlg::CConvertDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConvertDlg::IDD, pParent)
	, m_filename(_T(""))
	, m_bP2FLogo(TRUE)
	, m_bNavigation(TRUE)
	, m_bZooming(TRUE)
	, m_bSearch(TRUE)
	, m_bPrint(TRUE)
	, m_bOther(TRUE)
	, m_bUseServer2(FALSE)
	, m_sPageRange(_T(""))
{

}

CConvertDlg::~CConvertDlg()
{
}

void CConvertDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDFILE, m_filename);
	DDX_Control(pDX, IDC_EDFILE, m_edfile);
	DDX_Check(pDX, IDC_P2FLOGO, m_bP2FLogo);
	DDX_Check(pDX, IDC_Navigation, m_bNavigation);
	DDX_Check(pDX, IDC_Zooming, m_bZooming);
	DDX_Check(pDX, IDC_Search, m_bSearch);
	DDX_Check(pDX, IDC_Print, m_bPrint);
	DDX_Check(pDX, IDC_Other, m_bOther);
	DDX_Check(pDX, IDC_CBUseSERVER2, m_bUseServer2);
	DDX_Text(pDX, IDC_PAGERANGE, m_sPageRange);
	if (pDX->m_bSaveAndValidate)
	{
		if (INVALID_FILE_ATTRIBUTES == GetFileAttributes(m_filename))
		{
			MessageBox(_T("Please select a file to convert"));
			pDX->Fail();
		}
	}
}


BEGIN_MESSAGE_MAP(CConvertDlg, CDialog)
	ON_BN_CLICKED(IDC_BTNBROWSE, &CConvertDlg::OnBnClickedBtnbrowse)
END_MESSAGE_MAP()


// CConvertDlg message handlers

void CConvertDlg::OnBnClickedBtnbrowse()
{
	CFileDialog dlgFile(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, NULL, NULL, 0);
	CString fileName;
	CString strFilter;
	strFilter += _T("Any File");
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.*");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter = 1;
	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = _T("Select a file to convert");
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	if (dlgFile.DoModal() == IDOK)
		m_edfile.SetWindowTextW(fileName);
}
