// convert2swfDoc.cpp : implementation of the Cconvert2swfDoc class
//

#include "stdafx.h"
#include "convert2swf.h"
#include "convert.h"
#include "p2fserver_h.h"
#include "convert2swfDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// Cconvert2swfDoc

IMPLEMENT_DYNCREATE(Cconvert2swfDoc, CDocument)

BEGIN_MESSAGE_MAP(Cconvert2swfDoc, CDocument)
END_MESSAGE_MAP()


// Cconvert2swfDoc construction/destruction

Cconvert2swfDoc::Cconvert2swfDoc()
{
	// TODO: add one-time construction code here

}

Cconvert2swfDoc::~Cconvert2swfDoc()
{
}

#define CHECK_HR(hr,text) if (FAILED(hr)) { AfxMessageBox(_T(text),MB_ICONERROR | MB_OK); return FALSE; }
	
BOOL Cconvert2swfDoc::OnNewDocument()
{
	CConvertDlg dlg;
	if (dlg.DoModal() == IDCANCEL)
		return FALSE;

	long InterfaceOptions = 0;
	if (dlg.m_bP2FLogo)
		InterfaceOptions |= INTLOGO;
	if (dlg.m_bNavigation)
		InterfaceOptions |= INTPREVPAGE | INTGOTOPAGE | INTNEXTPAGE;
	if (dlg.m_bZooming)
		InterfaceOptions |=  INTFITWIDTH | INTFITPAGE | INTZOOMSLIDER | INTZOOMBOX;
	if (dlg.m_bSearch)
		InterfaceOptions |=  INTSEARCHBOX | INTSEARCHBUT;
	if (dlg.m_bPrint)
		InterfaceOptions |= INTPRINT;
	if (dlg.m_bOther)
		InterfaceOptions |= INTDRAG | INTSELTEXT | INTROTATE | INTNEWWIND | INTHELP | INTBACKBUTTON | INTFORWARDBUTTON | INTFULLSCREEN;

	HRESULT hr;
  	CComPtr<IServer> p2fServer;
	if (dlg.m_bUseServer2)
		hr = p2fServer.CoCreateInstance(CLSID_Server2,NULL,CLSCTX_LOCAL_SERVER);
	else
		hr = p2fServer.CoCreateInstance(CLSID_Server,NULL,CLSCTX_INPROC_SERVER);
	CHECK_HR(hr,"CoCreateInstance failed");
	CComPtr<IProfile> defProfile;
	hr = p2fServer->get_DefaultProfile(&defProfile);
	CHECK_HR(hr,"get_DefaultProfile failed");
	hr = defProfile->put_InterfaceOptions(InterfaceOptions);
	CHECK_HR(hr,"put_InterfaceOptions failed");
	hr = defProfile->put_JpegQuality(70);
	CHECK_HR(hr,"put_JpegQuality failed");
	hr = defProfile->put_FlashVersion(CComVariant(8));
	CHECK_HR(hr,"put_FlashVersion failed");
	hr = defProfile->put_ProtectionOptions(0);
	CHECK_HR(hr,"put_ProtectionOptions failed");
	hr = defProfile->put_UseJpeg(TRUE);
	CHECK_HR(hr,"put_put_UseJpeg failed");
	
	CComPtr<IBatchProcessingOptions> defBPO;
	hr = p2fServer->get_DefaultBatchProcessingOptions(&defBPO);
	CHECK_HR(hr,"get_DefaultBatchProcessingOptions failed");
	hr = defBPO->put_PageRange(CComBSTR(dlg.m_sPageRange));
	CHECK_HR(hr,"put_PageRange failed");

	CString sOut = dlg.m_filename+_T(".swf");
	CComVariant varNull;
	hr = p2fServer->ConvertFile(CComBSTR(dlg.m_filename),CComBSTR(sOut),varNull,varNull,varNull);
//	CHECK_HR(hr,"ConvertFile failed");
	if (FAILED(hr)){
		CComPtr<IErrorInfo> ei;
		if (SUCCEEDED(GetErrorInfo(0,&ei)))
		{
			CComBSTR str;
			if (SUCCEEDED(ei->GetDescription(&str)))
				AfxMessageBox(str,MB_ICONERROR | MB_OK);
		}
		return FALSE;
	}

	m_swfFileName = sOut;
	return TRUE;
}

// Cconvert2swfDoc diagnostics
#ifdef _DEBUG
void Cconvert2swfDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void Cconvert2swfDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

