/*
 * Decompiled with CFR 0.152.
 */
package fsp;

import com.myjavatools.web.ClientHttpRequest;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class fsp {
    private static int buffer_size = 204800;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: java " + fsp.class.getName() + " <input file> <url> [<folder> [<buffer size]]");
            System.exit(1);
        }
        String fileName = args[0];
        String url = args[1];
        String folder = "";
        if (args.length > 2) {
            folder = args[2];
        }
        if (args.length > 3) {
            buffer_size = Integer.parseInt(args[3]);
        }
        long t0 = System.currentTimeMillis();
        long part = 0L;
        File f = new File(fileName);
        long fileSize = f.length();
        long parts = (long)Math.ceil((double)fileSize / (double)buffer_size);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        byte[] buffer = new byte[buffer_size];
        try {
            int n = in.read(buffer, 0, buffer_size);
            while (n >= 0) {
                fsp.processBuffer(url, folder, fileName, ++part, parts, buffer, 0, n);
                n = in.read(buffer, 0, buffer_size);
            }
        }
        finally {
            in.close();
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Execution time was " + (t1 - t0) + " ms.");
        System.out.println("Upload speed " + fileSize * 8L / (t1 - t0) + " Kb/s");
    }

    private static void processBuffer(String url, String folder, String fileName, long part, long parts, byte[] buffer, int start, int end) {
        try {
            String line;
            ClientHttpRequest req = new ClientHttpRequest(url);
            req.setParameter("folder", folder);
            req.setParameter("file", fileName, new ByteArrayInputStream(buffer, start, end));
            req.setParameter("part", Long.toString(part));
            long t0 = System.currentTimeMillis();
            InputStream serverInput = req.post();
            long t1 = System.currentTimeMillis();
            BufferedReader response = new BufferedReader(new InputStreamReader(serverInput));
            System.out.print(fileName);
            System.out.print(" ");
            System.out.print(part);
            System.out.print("/");
            System.out.print(parts);
            System.out.print(" " + (t1 - t0) + " ms");
            System.out.print(" " + (long)((end - start) * 8) / (t1 - t0) + " Kb/s");
            while (null != (line = response.readLine())) {
                System.out.print(" " + line);
            }
            System.out.println();
        }
        catch (Throwable e) {
            System.out.println(e.toString());
        }
    }
}

