/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.filter.condition.ConditionFactory;
import freemind.controller.filter.condition.NodeCondition;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;

abstract class CompareConditionAdapter
extends NodeCondition {
    static final String IGNORE_CASE = "ignore_case";
    static final String VALUE = "value";
    private String conditionValue;
    private boolean ignoreCase;

    CompareConditionAdapter(String value, boolean ignoreCase) {
        this.conditionValue = value;
        this.ignoreCase = ignoreCase;
    }

    protected int compareTo(String nodeValue) throws NumberFormatException {
        try {
            int i2 = Integer.parseInt(this.conditionValue);
            int i1 = Integer.parseInt(nodeValue);
            return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
        }
        catch (NumberFormatException fne) {
            double d2;
            try {
                d2 = Double.parseDouble(this.conditionValue);
            }
            catch (NumberFormatException fne2) {
                return this.ignoreCase ? nodeValue.compareToIgnoreCase(this.conditionValue) : nodeValue.compareTo(this.conditionValue);
            }
            double d1 = Double.parseDouble(nodeValue);
            return Double.compare(d1, d2);
        }
    }

    public void saveAttributes(XMLElement child) {
        super.saveAttributes(child);
        child.setAttribute(VALUE, this.conditionValue);
        child.setAttribute(IGNORE_CASE, Tools.BooleanToXml(this.ignoreCase));
    }

    public String createDescription(String attribute, int comparationResult, boolean succeed) {
        String simpleCondition;
        switch (comparationResult) {
            case -1: {
                simpleCondition = succeed ? "<" : ">=";
                break;
            }
            case 0: {
                simpleCondition = Resources.getInstance().getResourceString(succeed ? "filter_is_equal_to" : "filter_is_not_equal_to");
                break;
            }
            case 1: {
                simpleCondition = succeed ? ">" : "<=";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return ConditionFactory.createDescription(attribute, simpleCondition, this.conditionValue, this.ignoreCase);
    }
}

