/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.JCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class IconContainedCondition
implements Condition {
    static final String ICON = "icon";
    static final String NAME = "icon_contained_condition";
    private String iconName;

    public IconContainedCondition(String iconName) {
        this.iconName = iconName;
    }

    public boolean checkNode(Controller c, MindMapNode node) {
        return IconContainedCondition.iconFirstIndex(node, this.iconName) != -1 || IconContainedCondition.isStateIconContained(node, this.iconName);
    }

    public static int iconFirstIndex(MindMapNode node, String iconName) {
        List icons = node.getIcons();
        ListIterator i = icons.listIterator();
        while (i.hasNext()) {
            MindIcon nextIcon = (MindIcon)i.next();
            if (!iconName.equals(nextIcon.getName())) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public static int iconLastIndex(MindMapNode node, String iconName) {
        List icons = node.getIcons();
        ListIterator i = icons.listIterator(icons.size());
        while (i.hasPrevious()) {
            MindIcon nextIcon = (MindIcon)i.previous();
            if (!iconName.equals(nextIcon.getName())) continue;
            return i.nextIndex();
        }
        return -1;
    }

    private static boolean isStateIconContained(MindMapNode node, String iconName) {
        Set stateIcons = node.getStateIcons().keySet();
        Iterator stateIcon = stateIcons.iterator();
        while (stateIcon.hasNext()) {
            String nextIcon = (String)stateIcon.next();
            if (!iconName.equals(nextIcon)) continue;
            return true;
        }
        return false;
    }

    public JComponent getListCellRendererComponent() {
        JCondition component = new JCondition();
        String text = Resources.getInstance().getResourceString("filter_icon") + ' ' + Resources.getInstance().getResourceString("filter_contains") + ' ';
        component.add(new JLabel(text));
        component.add(MindIcon.factory(this.getIconName()).getRendererComponent());
        return component;
    }

    private String getIconName() {
        return this.iconName;
    }

    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        child.setAttribute(ICON, this.iconName);
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        return new IconContainedCondition(element.getStringAttribute(ICON));
    }
}

