/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.CompareConditionAdapter;
import freemind.controller.filter.condition.Condition;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;

class NodeCompareCondition
extends CompareConditionAdapter {
    static final String COMPARATION_RESULT = "comparation_result";
    static final String VALUE = "value";
    static final String NAME = "node_compare_condition";
    static final String SUCCEED = "succeed";
    private int comparationResult;
    private boolean succeed;

    NodeCompareCondition(String value, boolean ignoreCase, int comparationResult, boolean succeed) {
        super(value, ignoreCase);
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    public boolean checkNode(Controller c, MindMapNode node) {
        try {
            return this.succeed == (this.compareTo(node.getText()) == this.comparationResult);
        }
        catch (NumberFormatException fne) {
            return false;
        }
    }

    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        super.saveAttributes(child);
        child.setIntAttribute(COMPARATION_RESULT, this.comparationResult);
        child.setAttribute(SUCCEED, Tools.BooleanToXml(this.succeed));
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        return new NodeCompareCondition(element.getStringAttribute(VALUE), Tools.xmlToBoolean(element.getStringAttribute("ignore_case")), element.getIntAttribute(COMPARATION_RESULT), Tools.xmlToBoolean(element.getStringAttribute(SUCCEED)));
    }

    protected String createDesctiption() {
        String nodeCondition = Resources.getInstance().getResourceString("filter_node");
        return super.createDescription(nodeCondition, this.comparationResult, this.succeed);
    }
}

