/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class StylePattern {
    private String name;
    private boolean recursive;
    private String text;
    private Color nodeColor;
    private Color nodeBackgroundColor;
    private String nodeStyle;
    private String nodeFontFamily = null;
    private Integer nodeFontSize = null;
    private Boolean nodeFontBold = null;
    private Boolean nodeFontItalic = null;
    private MindIcon nodeIcon;
    private Color edgeColor;
    private String edgeStyle;
    private Integer edgeWidth;
    private StylePattern mChildrenStylePattern;

    public StylePattern() {
    }

    public StylePattern(XMLElement elm, List justConstructedPatterns) {
        this.loadPattern(elm, justConstructedPatterns);
    }

    public StylePattern(MindMapNode node) {
        this.nodeColor = node.getColor();
        this.nodeBackgroundColor = node.getBackgroundColor();
        this.nodeStyle = node.getStyle();
        this.nodeFontBold = new Boolean(node.isBold());
        this.nodeFontItalic = new Boolean(node.isItalic());
        this.nodeFontSize = node.getFontSize() == null ? null : Integer.valueOf(node.getFontSize());
        this.nodeFontFamily = node.getFontFamilyName();
        this.nodeIcon = null;
        this.edgeColor = node.getEdge().getColor();
        this.edgeStyle = node.getEdge().getStyle();
        this.edgeWidth = new Integer(node.getEdge().getWidth());
    }

    public String toString() {
        return "node: " + this.nodeColor + ", " + this.nodeBackgroundColor + ", " + this.nodeStyle + ", " + this.nodeFontFamily + ", " + this.nodeFontSize + ", " + this.nodeIcon + ", " + this.text + ", " + "\nedge: " + this.edgeColor + ", " + this.edgeStyle + ", " + this.edgeWidth;
    }

    public boolean getAppliesToEdge() {
        return this.edgeColor != null || this.edgeStyle != null || this.edgeWidth != null;
    }

    public boolean getAppliesToNode() {
        return this.nodeBackgroundColor != null || this.nodeColor != null || this.nodeStyle != null;
    }

    public boolean getAppliesToNodeFont() {
        return this.nodeFontBold != null || this.nodeFontFamily != null || this.nodeFontItalic != null || this.nodeFontSize != null;
    }

    public boolean getAppliesToNodeIcon() {
        return this.nodeIcon != null;
    }

    public boolean getAppliesToChildren() {
        return this.mChildrenStylePattern != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean v) {
        this.recursive = v;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String v) {
        this.text = v;
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public void setNodeColor(Color v) {
        this.nodeColor = v;
    }

    public Color getNodeBackgroundColor() {
        return this.nodeBackgroundColor;
    }

    public void setNodeBackgroundColor(Color nodeBackgroundColor) {
        this.nodeBackgroundColor = nodeBackgroundColor;
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(String nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public String getNodeFontFamily() {
        return this.nodeFontFamily;
    }

    public void setNodeFontFamily(String nodeFontFamily) {
        this.nodeFontFamily = nodeFontFamily;
    }

    public Integer getNodeFontSize() {
        return this.nodeFontSize;
    }

    public void setNodeFontSize(Integer nodeFontSize) {
        this.nodeFontSize = nodeFontSize;
    }

    public MindIcon getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(MindIcon nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public String getEdgeStyle() {
        return this.edgeStyle;
    }

    public void setEdgeStyle(String edgeStyle) {
        this.edgeStyle = edgeStyle;
    }

    public Integer getEdgeWidth() {
        return this.edgeWidth;
    }

    public void setEdgeWidth(Integer edgeWidth) {
        this.edgeWidth = edgeWidth;
    }

    public StylePattern getChildrenStylePattern() {
        return this.mChildrenStylePattern;
    }

    public void setChildrenStylePattern(StylePattern pChildrenStylePattern) {
        this.mChildrenStylePattern = pChildrenStylePattern;
    }

    public static List loadPatterns(File file) throws Exception {
        return StylePattern.loadPatterns(new BufferedReader(new FileReader(file)));
    }

    public static List loadPatterns(Reader reader) throws Exception {
        LinkedList<StylePattern> list = new LinkedList<StylePattern>();
        XMLElement parser = new XMLElement();
        parser.parseFromReader(reader);
        Enumeration e = parser.enumerateChildren();
        while (e.hasMoreElements()) {
            list.add(new StylePattern((XMLElement)e.nextElement(), list));
        }
        return list;
    }

    protected void loadPattern(XMLElement pattern, List justConstructedPatterns) {
        if (pattern.getStringAttribute("name") != null) {
            this.setName(pattern.getStringAttribute("name"));
        }
        if (Tools.safeEquals(pattern.getStringAttribute("recursive"), "true")) {
            this.setRecursive(true);
        }
        Iterator i = pattern.getChildren().iterator();
        while (i.hasNext()) {
            XMLElement child = (XMLElement)i.next();
            if (child.getName().equals("node")) {
                if (child.getStringAttribute("color") != null && child.getStringAttribute("color").length() == 7) {
                    this.setNodeColor(Tools.xmlToColor(child.getStringAttribute("color")));
                }
                if (child.getStringAttribute("background_color") != null && child.getStringAttribute("background_color").length() == 7) {
                    this.setNodeBackgroundColor(Tools.xmlToColor(child.getStringAttribute("background_color")));
                }
                if (child.getStringAttribute("style") != null) {
                    this.setNodeStyle(child.getStringAttribute("style"));
                }
                if (child.getStringAttribute("icon") != null) {
                    this.setNodeIcon(child.getStringAttribute("icon").equals("none") ? null : MindIcon.factory(child.getStringAttribute("icon")));
                }
                this.setText(child.getStringAttribute("text"));
                Iterator j = child.getChildren().iterator();
                while (j.hasNext()) {
                    XMLElement nodeChild = (XMLElement)j.next();
                    if (!nodeChild.getName().equals("font")) continue;
                    if (nodeChild.getStringAttribute("name") != null) {
                        this.setNodeFontFamily(nodeChild.getStringAttribute("name"));
                    }
                    if (Tools.safeEquals(nodeChild.getStringAttribute("bold"), "true")) {
                        this.setNodeFontBold(Boolean.TRUE);
                    }
                    if (Tools.safeEquals(nodeChild.getStringAttribute("italic"), "true")) {
                        this.setNodeFontItalic(Boolean.TRUE);
                    }
                    if (nodeChild.getStringAttribute("size") == null) continue;
                    this.setNodeFontSize(Integer.valueOf(nodeChild.getStringAttribute("size")));
                }
            }
            if (child.getName().equals("edge")) {
                if (child.getStringAttribute("style") != null) {
                    this.setEdgeStyle(child.getStringAttribute("style"));
                }
                if (child.getStringAttribute("color") != null) {
                    this.setEdgeColor(Tools.xmlToColor(child.getStringAttribute("color")));
                }
                if (child.getStringAttribute("width") != null) {
                    if (child.getStringAttribute("width").equals("thin")) {
                        this.setEdgeWidth(new Integer(0));
                    } else {
                        this.setEdgeWidth(new Integer(Integer.parseInt(child.getStringAttribute("width"))));
                    }
                }
            }
            if (!child.getName().equals("child") || child.getStringAttribute("pattern") == null) continue;
            String searchName = child.getStringAttribute("pattern");
            boolean anythingFound = false;
            ListIterator e = justConstructedPatterns.listIterator();
            while (e.hasNext()) {
                StylePattern patternFound = (StylePattern)e.next();
                if (!patternFound.getName().equals(searchName)) continue;
                this.setChildrenStylePattern(patternFound);
                anythingFound = true;
                break;
            }
            if (this.getName().equals(searchName)) {
                this.setChildrenStylePattern(this);
                anythingFound = true;
            }
            if (anythingFound) continue;
            System.err.println("Cannot find the children " + searchName + " to the pattern " + this.getName());
        }
    }

    public Boolean getNodeFontBold() {
        return this.nodeFontBold;
    }

    public void setNodeFontBold(Boolean nodeFontBold) {
        this.nodeFontBold = nodeFontBold;
    }

    public Boolean getNodeFontItalic() {
        return this.nodeFontItalic;
    }

    public void setNodeFontItalic(Boolean nodeFontItalic) {
        this.nodeFontItalic = nodeFontItalic;
    }
}

