/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.VerticalRootNodeViewLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;

public class BezierEdgeView
extends EdgeView {
    CubicCurve2D.Float graph = new CubicCurve2D.Float();
    private static final int XCTRL = 12;
    private static final int CHILD_XCTRL = 20;

    private void update() {
        int sign = this.getTarget().isLeft() ? -1 : 1;
        int sourceSign = 1;
        if (this.getSource().isRoot() && !VerticalRootNodeViewLayout.USE_COMMON_OUT_POINT_FOR_ROOT_NODE) {
            sourceSign = 0;
        }
        int xctrl = this.getMap().getZoomed(sourceSign * sign * 12);
        int childXctrl = this.getMap().getZoomed(-1 * sign * 20);
        this.graph.setCurve(this.start.x, this.start.y, this.start.x + xctrl, this.start.y, this.end.x + childXctrl, this.end.y, this.end.x, this.end.y);
    }

    protected void paint(Graphics2D g) {
        this.update();
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        g.draw(this.graph);
        if (this.isTargetEclipsed()) {
            g.setColor(g.getBackground());
            g.setStroke(BezierEdgeView.getEclipsedStroke());
            g.draw(this.graph);
            g.setStroke(stroke);
            g.setColor(color);
        }
    }

    public Color getColor() {
        return this.getModel().getColor();
    }
}

