/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.hierarchy;

import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;

class HierarchyLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    HierarchyLabelProvider() {
    }

    public Image getImage(Object element) {
        if (element instanceof DataAndImageTreeNode) {
            DataAndImageTreeNode treeNode = (DataAndImageTreeNode)element;
            return treeNode.image;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof DataAndImageTreeNode) {
            DataAndImageTreeNode treeNode = (DataAndImageTreeNode)element;
            Object data = treeNode.data;
            if (data instanceof HierarchyNodeModel) {
                HierarchyNodeModel model = (HierarchyNodeModel)data;
                String spaces = "     ";
                if (model.moduleName != null && model.moduleName.trim().length() > 0) {
                    return String.valueOf(model.name) + spaces + "(" + model.moduleName + ")";
                }
                return model.name;
            }
            return data.toString();
        }
        return super.getText(element);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof DataAndImageTreeNode) {
            DataAndImageTreeNode treeNode = (DataAndImageTreeNode)element;
            Object data = treeNode.data;
            if (data instanceof HierarchyNodeModel) {
                HierarchyNodeModel model = (HierarchyNodeModel)data;
                String spaces = "     ";
                StyledString styledString = new StyledString(String.valueOf(model.name) + spaces);
                if (model.moduleName != null && model.moduleName.trim().length() > 0) {
                    StyledString.Styler styler = StyledString.createColorRegistryStyler((String)"DECORATIONS_COLOR", null);
                    styledString.append("(" + model.moduleName + ")", styler);
                }
                return styledString;
            }
            return new StyledString(data.toString());
        }
        return new StyledString(element == null ? "" : element.toString());
    }
}

