/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.customizations.common;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.runners.UniversalRunner;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public abstract class ProcessWindow
extends Dialog {
    private static final String SEND_TO_PROMPT_LABEL = "Send to &prompt: ";
    private static final String SEND_LABEL = "&Send";
    private static final String EXECUTING_COMMAND_LABEL = "E&xecuting: ";
    private static final String COMMAND_TO_EXECUTE_LABEL = "Command to e&xecute: ";
    private static final String CLOSE_LABEL = "C&lose";
    private static final String CANCEL_LABEL = "&Cancel";
    private static final String RUN_LABEL = "&Run";
    protected Text output;
    protected IContainer container;
    protected IPythonPathNature pythonPathNature;
    protected File appcfg;
    protected File appEngineLocation;
    protected String initialCommand;
    private Object lock = new Object();
    private static final int STATE_NOT_RUNNING = 0;
    private static final int STATE_RUNNING = 1;
    private volatile int state = 0;
    private ThreadStreamReader err;
    private ThreadStreamReader std;
    private OutputStream outputStream;
    private ProcessHandler processHandler;
    private Process process;
    private Button cancelButton;
    private Button okButton;
    private Combo commandToExecute;
    private Text sendToText;
    private final int NUMBER_OF_COLUMNS = 6;
    private Label commandToExecuteLabel;

    public ProcessWindow(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Manage Google App Engine");
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(top, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createLabel(composite, "Arguments to pass to: " + this.appcfg.getAbsolutePath());
        this.createLabel(composite, "The command line can be changed as needed.");
        Link link = new Link(composite, 0);
        link.setText("See <a>http://code.google.com/appengine/docs/python/tools/uploadinganapp.html</a>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://code.google.com/appengine/docs/python/tools/uploadinganapp.html");
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        link.setLayoutData((Object)gridData);
        this.commandToExecuteLabel = this.createLabel(composite, COMMAND_TO_EXECUTE_LABEL, 1);
        this.commandToExecute = new Combo(composite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.commandToExecute.setLayoutData((Object)gridData);
        String[] availableCommands = this.getAvailableCommands();
        this.commandToExecute.setItems(availableCommands);
        this.commandToExecute.setText(availableCommands[0]);
        this.okButton = this.createButton(composite, RUN_LABEL, 1, 8);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProcessWindow.this.buttonPressed(0);
            }
        });
        this.okButton.setData((Object)0);
        this.output = new Text(composite, 2634);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.output.setLayoutData((Object)gridData);
        this.createLabel(composite, SEND_TO_PROMPT_LABEL, 1);
        this.sendToText = this.createText(composite, 4);
        this.sendToText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    ProcessWindow.this.addCurrentCommand();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button button = this.createButton(composite, SEND_LABEL, 1, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessWindow.this.addCurrentCommand();
            }
        });
        return top;
    }

    protected abstract String[] getAvailableCommands();

    private Label createLabel(Composite composite, String message) {
        return this.createLabel(composite, message, 6);
    }

    private Label createLabel(Composite composite, String message, int horizontalSpan) {
        Label label = new Label(composite, 0);
        label.setText(message);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void constrainShellSize() {
        this.getShell().setSize(640, 480);
        super.constrainShellSize();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.cancelButton = this.createButton(parent, 1, CLOSE_LABEL, false);
    }

    public void create() {
        super.create();
        this.okButton.setFocus();
        if (this.initialCommand != null) {
            this.commandToExecute.setText(this.initialCommand);
            this.okPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okPressed() {
        boolean doRun = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                this.state = 1;
                doRun = true;
            }
        }
        if (doRun) {
            this.run();
            this.commandToExecuteLabel.setText(EXECUTING_COMMAND_LABEL);
            this.commandToExecute.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.okButton.setText(CANCEL_LABEL);
        } else {
            this.cancelRun();
        }
    }

    private void cancelRun() {
        ProcessHandler handler = this.processHandler;
        if (handler != null) {
            handler.forceQuit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEndRun() {
        Object object = this.lock;
        synchronized (object) {
            this.state = 0;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProcessWindow.this.commandToExecuteLabel.setText(ProcessWindow.COMMAND_TO_EXECUTE_LABEL);
                ProcessWindow.this.commandToExecute.setEnabled(true);
                ProcessWindow.this.cancelButton.setEnabled(true);
                ProcessWindow.this.okButton.setText(ProcessWindow.RUN_LABEL);
            }
        });
    }

    public boolean close() {
        if (this.state == 0) {
            return super.close();
        }
        this.cancelRun();
        return false;
    }

    protected void cancelPressed() {
        if (this.state == 0) {
            super.cancelPressed();
        } else {
            this.cancelRun();
        }
    }

    public void setParameters(IContainer container, IPythonPathNature pythonPathNature, File appcfg, File appEngineLocation) {
        this.container = container;
        this.pythonPathNature = pythonPathNature;
        this.appcfg = appcfg;
        this.appEngineLocation = appEngineLocation;
    }

    private void run() {
        if (this.processHandler != null) {
            return;
        }
        try {
            String cmdLineArguments = this.commandToExecute.getText().trim();
            String[] arguments = new String[]{};
            if (cmdLineArguments.length() > 0) {
                arguments = PythonRunnerConfig.parseStringIntoList((String)cmdLineArguments);
            }
            UniversalRunner.AbstractRunner universalRunner = UniversalRunner.getRunner((IPythonNature)this.pythonPathNature.getNature());
            Tuple run = universalRunner.createProcess(this.appcfg.getAbsolutePath(), arguments, this.appEngineLocation, (IProgressMonitor)new NullProgressMonitor());
            this.process = (Process)run.o1;
            if (this.process != null) {
                this.std = new ThreadStreamReader(this.process.getInputStream());
                this.err = new ThreadStreamReader(this.process.getErrorStream());
                this.std.start();
                this.err.start();
                this.outputStream = this.process.getOutputStream();
                this.processHandler = new ProcessHandler();
                this.processHandler.start();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private Button createButton(Composite composite, String label, int colSpan, int style) {
        Button button = new Button(composite, style);
        button.setText(label);
        this.setButtonLayout(button, colSpan);
        return button;
    }

    private void setButtonLayout(Button button, int colSpan) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = colSpan;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
    }

    private Text createText(Composite composite, int colSpan) {
        Text text = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = colSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void addCurrentCommand() {
        ProcessHandler p = this.processHandler;
        if (p != null) {
            String text = this.sendToText.getText();
            this.sendToText.setText("");
            p.addCommandText(String.valueOf(text) + "\n");
        }
    }

    public void setInitialCommandToRun(String initialCommand) {
        this.initialCommand = initialCommand;
    }

    class ProcessHandler
    extends Thread {
        private List<String> commandTexts = new ArrayList<String>();
        private Object commandTextsLock = new Object();
        private boolean forceQuit = false;
        private FastStringBuffer buffer = new FastStringBuffer();

        ProcessHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    while (ProcessWindow.this.process != null && !this.forceQuit) {
                        boolean hasExited = true;
                        try {
                            ProcessWindow.this.process.exitValue();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            hasExited = false;
                        }
                        try {
                            Thread.sleep(75L);
                        }
                        catch (InterruptedException interruptedException) {}
                        try {
                            String errContents = ProcessWindow.this.err.getAndClearContents();
                            String stdContents = ProcessWindow.this.std.getAndClearContents();
                            this.append(errContents);
                            this.append(stdContents);
                            if (hasExited) {
                                ProcessWindow.this.process = null;
                                continue;
                            }
                            Object object = this.commandTextsLock;
                            synchronized (object) {
                                if (this.commandTexts.size() > 0) {
                                    String txt = this.commandTexts.remove(0);
                                    try {
                                        this.append("\n");
                                        ProcessWindow.this.outputStream.write(txt.getBytes());
                                        ProcessWindow.this.outputStream.flush();
                                    }
                                    catch (IOException e) {
                                        Log.log((Throwable)e);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.append(e.getMessage());
                            Log.log((Throwable)e);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (ProcessWindow.this.process != null) {
                        this.append("Forcing the process to quit.\n");
                        try {
                            ProcessWindow.this.process.destroy();
                        }
                        catch (Exception exception) {}
                        ProcessWindow.this.process = null;
                    }
                    ProcessWindow.this.err = null;
                    ProcessWindow.this.std = null;
                    ProcessWindow.this.outputStream = null;
                    ProcessWindow.this.processHandler = null;
                    this.append("FINISHED\n\n");
                    throw throwable;
                }
                if (ProcessWindow.this.process != null) {
                    this.append("Forcing the process to quit.\n");
                    try {
                        ProcessWindow.this.process.destroy();
                    }
                    catch (Exception exception) {}
                    ProcessWindow.this.process = null;
                }
                ProcessWindow.this.err = null;
                ProcessWindow.this.std = null;
                ProcessWindow.this.outputStream = null;
                ProcessWindow.this.processHandler = null;
                this.append("FINISHED\n\n");
                return;
            }
            finally {
                ProcessWindow.this.onEndRun();
            }
        }

        private void append(final String contents) {
            if (contents == null || contents.length() == 0) {
                return;
            }
            this.buffer.append(contents);
            if (this.buffer.length() > 2000) {
                try {
                    this.buffer.delete(0, 2000 - this.buffer.length());
                }
                catch (Exception exception) {}
            }
            final List split = StringUtils.splitInLines((String)this.buffer.toString());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (split.size() > 0) {
                        String last = (String)split.get(split.size() - 1);
                        if (last.toLowerCase().indexOf("password for") != -1) {
                            ProcessWindow.this.sendToText.setEchoChar('*');
                        } else {
                            ProcessWindow.this.sendToText.setEchoChar('\u0000');
                        }
                    }
                    ((ProcessHandler)ProcessHandler.this).ProcessWindow.this.output.append(contents);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCommandText(String text) {
            Object object = this.commandTextsLock;
            synchronized (object) {
                this.commandTexts.add(text);
            }
        }
    }
}

