/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.utils.ComboFieldEditor;

public class PyDevBuilderPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final boolean DEFAULT_USE_PYDEV_BUILDERS = true;
    public static final String USE_PYDEV_BUILDERS = "USE_PYDEV_BUILDERS";
    public static final boolean DEFAULT_USE_PYDEV_ONLY_ON_DOC_SAVE = false;
    public static final String USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE = "USE_PYDEV_ONLY_ON_DOC_SAVE";
    public static final int DEFAULT_PYDEV_ELAPSE_BEFORE_ANALYSIS = 3000;
    public static final String PYDEV_ELAPSE_BEFORE_ANALYSIS = "PYDEV_ELAPSE_BEFORE_ANALYSIS";
    public static final String ANALYZE_ONLY_ACTIVE_EDITOR = "ANALYZE_ONLY_ACTIVE_EDITOR_2";
    public static final boolean DEFAULT_ANALYZE_ONLY_ACTIVE_EDITOR = true;
    public static final String REMOVE_ERRORS_WHEN_EDITOR_IS_CLOSED = "REMOVE_ERRORS_WHEN_EDITOR_IS_CLOSED_2";
    public static final boolean DEFAULT_REMOVE_ERRORS_WHEN_EDITOR_IS_CLOSED = true;
    private Button onlyAnalyzeOpenCheckBox;
    private Button removeErrorsCheckBox;
    public static final String PYC_DELETE_HANDLING = "PYC_DELETE_HANDLING";
    public static final int PYC_ALWAYS_DELETE = 0;
    public static final int PYC_DELETE_WHEN_PY_IS_DELETED = 1;
    public static final int PYC_NEVER_DELETE = 2;
    public static final int DEFAULT_PYC_DELETE_HANDLING = 0;
    private static final String[][] ENTRIES_AND_VALUES = new String[][]{{"Delete any orphaned .pyc file.", Integer.toString(0)}, {"Only delete .pyc when .py delete is detected.", Integer.toString(1)}, {"Never delete .pyc files.", Integer.toString(2)}};

    public PyDevBuilderPrefPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("PyDev builders");
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        String s = "WARNING: \n\nPyDev builders are required for many features \nprovided by Pydev such as:\n\n- Code completion\n- PyLint\n- TODO tasks\n\nSo, if you choose to disable it, note that the features \nmentioned above may not work as expected or may even not \nwork at all (use at your own risk).\n";
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", s, p));
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYDEV_BUILDERS, "Use builders?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE, "Disable parser notifications?", p));
        this.addField((FieldEditor)new IntegerFieldEditor(PYDEV_ELAPSE_BEFORE_ANALYSIS, "Time to elapse before reparsing changed file (millis)", p));
        s = "If only open editors are analyzed, markers will only be added\nto the opened PyDev editors.\n";
        this.addField((FieldEditor)new LabelFieldEditor("ActiveBufferLabelFieldEditor", s, p));
        BooleanFieldEditorWithPublicGetControl onlyAnalyzeOpen = new BooleanFieldEditorWithPublicGetControl(ANALYZE_ONLY_ACTIVE_EDITOR, "Only analyze open editors?", p);
        this.addField((FieldEditor)onlyAnalyzeOpen);
        BooleanFieldEditorWithPublicGetControl removeErrors = new BooleanFieldEditorWithPublicGetControl(REMOVE_ERRORS_WHEN_EDITOR_IS_CLOSED, "Remove errors when editor is closed?", p);
        this.addField((FieldEditor)removeErrors);
        this.removeErrorsCheckBox = removeErrors.getChangeControl(p);
        this.onlyAnalyzeOpenCheckBox = onlyAnalyzeOpen.getChangeControl(p);
        this.onlyAnalyzeOpenCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PyDevBuilderPrefPage.this.updateCheckEnabledState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField(new ComboFieldEditor(PYC_DELETE_HANDLING, "How to handle .pyc/$py.class deletion?", ENTRIES_AND_VALUES, p));
    }

    public void dispose() {
        super.dispose();
    }

    protected void initialize() {
        super.initialize();
        this.updateCheckEnabledState();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateCheckEnabledState();
    }

    public void init(IWorkbench workbench) {
    }

    private void updateCheckEnabledState() {
        if (this.removeErrorsCheckBox != null && !this.removeErrorsCheckBox.isDisposed() && this.onlyAnalyzeOpenCheckBox != null && !this.onlyAnalyzeOpenCheckBox.isDisposed()) {
            this.removeErrorsCheckBox.setEnabled(this.onlyAnalyzeOpenCheckBox.getSelection());
        }
    }

    public static boolean usePydevBuilders() {
        return PydevPrefs.getPreferences().getBoolean(USE_PYDEV_BUILDERS);
    }

    public static boolean useAnalysisOnlyOnDocSave() {
        return PyParserManager.getPyParserManager((IPreferenceStore)PydevPrefs.getPreferences()).useAnalysisOnlyOnDocSave();
    }

    public static boolean getAnalyzeOnlyActiveEditor() {
        return PydevPrefs.getPreferences().getBoolean(ANALYZE_ONLY_ACTIVE_EDITOR);
    }

    public static boolean getRemoveErrorsWhenEditorIsClosed() {
        return PydevPrefs.getPreferences().getBoolean(REMOVE_ERRORS_WHEN_EDITOR_IS_CLOSED);
    }

    public static void setAnalyzeOnlyActiveEditor(boolean b) {
        PydevPrefs.getPreferences().setValue(ANALYZE_ONLY_ACTIVE_EDITOR, b);
    }

    public static int getElapseMillisBeforeAnalysis() {
        return PyParserManager.getPyParserManager((IPreferenceStore)PydevPrefs.getPreferences()).getElapseMillisBeforeAnalysis();
    }

    public static int getPycDeleteHandling() {
        return PydevPrefs.getPreferences().getInt(PYC_DELETE_HANDLING);
    }

    private final class BooleanFieldEditorWithPublicGetControl
    extends BooleanFieldEditor {
        private BooleanFieldEditorWithPublicGetControl(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        public Button getChangeControl(Composite parent) {
            Button checkBox = super.getChangeControl(parent);
            return checkBox;
        }
    }
}

