/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.editor.PyEditConfigurationWithoutEditor;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyContentViewer
extends Viewer {
    private SourceViewer fSourceViewer;
    private Object fInput;

    PyContentViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 0x2000300);
        IPreferenceStore store = PydevPrefs.getChainedPrefStore();
        final ColorAndStyleCache c = new ColorAndStyleCache(store);
        this.fSourceViewer.configure((SourceViewerConfiguration)new PyEditConfigurationWithoutEditor(c, store));
        this.fSourceViewer.setEditable(false);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                c.dispose();
            }
        });
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void setInput(Object input) {
        if (input instanceof IStreamContentAccessor) {
            Document document = new Document(PyContentViewer.getString(input));
            PyPartitionScanner.addPartitionScanner((IDocument)document);
        }
        this.fInput = input;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection s, boolean reveal) {
    }

    public void refresh() {
    }

    private static String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)input;
            try {
                return PyContentViewer.readString(sca);
            }
            catch (CoreException ex) {
                Log.log((Throwable)ex);
            }
        }
        return "";
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
                }
                catch (Exception exception) {}
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return PyContentViewer.readString(is, encoding);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, encoding));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }
}

