/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.python.pydev.changed_lines.ChangedLinesComputer;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.NotConfiguredInterpreterException;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PythonPairMatcher;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.ActionInfo;
import org.python.pydev.editor.ICodeScannerKeywords;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.OfflineActionsManager;
import org.python.pydev.editor.PyDocumentProvider;
import org.python.pydev.editor.PyEditBasedCodeScannerKeywords;
import org.python.pydev.editor.PyEditConfiguration;
import org.python.pydev.editor.PyEditTitle;
import org.python.pydev.editor.PydevShowBrowserMessage;
import org.python.pydev.editor.actions.FirstCharAction;
import org.python.pydev.editor.actions.OfflineAction;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.editor.actions.PyBackspace;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.editor.actions.PyMoveLineDownAction;
import org.python.pydev.editor.actions.PyMoveLineUpAction;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.PyOrganizeImports;
import org.python.pydev.editor.actions.PyPeerLinker;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editor.codefolding.CodeFoldingSetter;
import org.python.pydev.editor.codefolding.PyEditProjection;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.correctionassist.PythonCorrectionProcessor;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.saveactions.PydevSaveActionsPrefPage;
import org.python.pydev.editor.scripting.PyEditScripting;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.outline.ParsedModel;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.fastparser.ScopesParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.CheckDefaultPreferencesDialog;
import org.python.pydev.plugin.preferences.PyCodeFormatterPage;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.ChangedParserInfoForObservers;
import org.python.pydev.shared_core.parsing.ErrorParserInfoForObservers;
import org.python.pydev.shared_core.parsing.IParserObserver3;
import org.python.pydev.shared_core.parsing.IScopesParser;
import org.python.pydev.shared_core.string.ICharacterPairMatcher2;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.UIConstants;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.proposals.IPyCompletionProposal;
import org.python.pydev.shared_ui.proposals.PyCompletionProposal;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.ColorAndStyleCache;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PyEdit
extends PyEditProjection
implements IPyEdit,
IGrammarVersionProvider,
IPySyntaxHighlightingAndCodeCompletionEditor,
IParserObserver3 {
    public static final String PY_EDIT_CONTEXT = "#PyEditContext";
    public static final String PY_EDIT_RULER_CONTEXT = "#PyEditRulerContext";
    public static final String EDITOR_ID = "org.python.pydev.editor.PythonEditor";
    public static final String ACTION_OPEN = "OpenEditor";
    private static final Set<PyEdit> currentlyOpenedEditors;
    private static final Object currentlyOpenedEditorsLock;
    private ColorAndStyleCache colorCache;
    private IPropertyChangeListener prefListener;
    private PyAutoIndentStrategy indentStrategy;
    private PyEditConfiguration editConfiguration;
    private volatile SimpleNode ast;
    private volatile long astModificationTimeStamp = -1L;
    private volatile ErrorDescription errorDescription;
    private static List<IPyEditListener> editListeners;
    private PyEditScripting pyEditScripting;
    public final ICallbackWithListeners<Composite> onCreatePartControl = new CallbackWithListeners();
    public final ICallbackWithListeners<ISourceViewer> onAfterCreatePartControl = new CallbackWithListeners();
    public final ICallbackWithListeners<PyEdit> onCreateActions = new CallbackWithListeners();
    public final ICallbackWithListeners<Class<?>> onGetAdapter = new CallbackWithListeners();
    public final ICallbackWithListeners<LineNumberRulerColumn> onInitializeLineNumberRulerColumn = new CallbackWithListeners();
    public final ICallbackWithListeners<?> onDispose = new CallbackWithListeners();
    public final ICallbackWithListeners<PropertyChangeEvent> onHandlePreferenceStoreChanged = new CallbackWithListeners();
    public final ICallbackWithListeners<PySourceViewer> onCreateSourceViewer = new CallbackWithListeners();
    private boolean disposed = false;
    public static final ICallbackWithListeners<PyEdit> onPyEditCreated;
    private static final String INVALID_MODULE_MARKER_TYPE = "org.python.pydev.invalidpythonfilemarker";
    protected OfflineActionTarget fOfflineActionTarget;
    private PyOutlinePage outlinePage;
    private Tuple3<Integer, IModulesManager, String> handle;
    private final Object lockHandle = new Object();
    OfflineActionsManager offlineActionsManager = new OfflineActionsManager();
    private LocalResourceManager resourceManager;

    static {
        org.python.pydev.parser.jython.ParseException.verboseExceptions = true;
        currentlyOpenedEditors = new HashSet<PyEdit>();
        currentlyOpenedEditorsLock = new Object();
        onPyEditCreated = new CallbackWithListeners();
    }

    @Override
    public PyEditConfiguration getEditConfiguration() {
        return this.editConfiguration;
    }

    @Override
    public ColorAndStyleCache getColorCache() {
        return this.colorCache;
    }

    @Override
    public PySelection createPySelection() {
        return new PySelection((ITextEditor)this);
    }

    public TextSelectionUtils createTextSelectionUtils() {
        return new PySelection((ITextEditor)this);
    }

    public ISourceViewer getISourceViewer() {
        return this.getSourceViewer();
    }

    public IVerticalRuler getIVerticalRuler() {
        return this.getVerticalRuler();
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        super.initializeLineNumberRulerColumn(rulerColumn);
        this.onInitializeLineNumberRulerColumn.call((Object)rulerColumn);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        this.onHandlePreferenceStoreChanged.call((Object)event);
    }

    @Override
    public void createPartControl(Composite parent) {
        Composite newParent = (Composite)this.onCreatePartControl.call((Object)parent);
        if (newParent != null) {
            parent = newParent;
        }
        super.createPartControl(parent);
        this.onAfterCreatePartControl.call((Object)this.getSourceViewer());
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyEdit() {
        Object object = currentlyOpenedEditorsLock;
        synchronized (object) {
            currentlyOpenedEditors.add(this);
        }
        try {
            onPyEditCreated.call((Object)this);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            if (editListeners == null) {
                editListeners = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_pyedit_listener");
            }
            this.notifier.notifyEditorCreated();
            this.colorCache = new ColorAndStyleCache(PydevPrefs.getChainedPrefStore());
            this.editConfiguration = new PyEditConfiguration(this.colorCache, this, PydevPrefs.getChainedPrefStore());
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.editConfiguration);
            this.indentStrategy = this.editConfiguration.getPyAutoIndentStrategy();
            this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
            CodeFoldingSetter codeFoldingSetter = new CodeFoldingSetter(this);
            this.addModelListener(codeFoldingSetter);
            this.addPropertyListener(codeFoldingSetter);
            CheckDefaultPreferencesDialog.askAboutSettings();
            PydevShowBrowserMessage.show();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    protected List<IPyEditListener> getAdditionalEditorListeners() {
        return editListeners;
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        PySourceViewer viewer = (PySourceViewer)super.createSourceViewer(parent, ruler, styles);
        viewer.appendVerifyKeyListener(PyPeerLinker.createVerifyKeyListener((TextViewer)viewer));
        viewer.appendVerifyKeyListener(PyBackspace.createVerifyKeyListener((TextViewer)viewer, this));
        VerifyKeyListener createVerifyKeyListener = FirstCharAction.createVerifyKeyListener((SourceViewer)viewer, this.getSite(), false);
        if (createVerifyKeyListener != null) {
            viewer.appendVerifyKeyListener(createVerifyKeyListener);
        }
        this.onCreateSourceViewer.call((Object)viewer);
        return viewer;
    }

    @Override
    public void resetForceTabs() {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (doc == null) {
            return;
        }
        if (!PydevPrefs.getPreferences().getBoolean("GUESS_TAB_SUBSTITUTION")) {
            this.getIndentPrefs().setForceTabs(false);
            return;
        }
        int lines = doc.getNumberOfLines();
        boolean forceTabs = false;
        int i = 0;
        while (i < lines) {
            block8: {
                try {
                    IRegion r = doc.getLineInformation(i);
                    String text = doc.get(r.getOffset(), r.getLength());
                    if (text == null) break block8;
                    if (text.startsWith("\t")) {
                        forceTabs = true;
                        break;
                    }
                    if (text.startsWith("  ")) {
                        forceTabs = false;
                    }
                    break block8;
                }
                catch (BadLocationException e) {
                    Log.log((int)4, (String)"Unexpected error forcing tabs", (Throwable)e);
                }
                break;
            }
            ++i;
        }
        this.getIndentPrefs().setForceTabs(forceTabs);
        this.editConfiguration.resetIndentPrefixes();
        if (forceTabs) {
            this.updateForceTabsMessage();
        }
    }

    public void updateForceTabsMessage() {
        boolean forceTabs = this.getIndentPrefs().getForceTabs();
        ImageCache imageCache = PydevPlugin.getImageCache();
        ImageDescriptor desc = forceTabs ? imageCache.getDescriptor("icons/tabs_active.png") : imageCache.getDescriptor("icons/tabs_inactive.png");
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, forceTabs ? "Forcing tabs" : "Not forcing tabs.", desc.createImage());
        }
    }

    @Override
    public IIndentPrefs getIndentPrefs() {
        return this.indentStrategy.getIndentPrefs();
    }

    public PyAutoIndentStrategy getAutoEditStrategy() {
        return this.indentStrategy;
    }

    @Override
    public void resetIndentPrefixes() {
        super.updateIndentPrefixes();
    }

    protected void installTabsToSpacesConverter() {
        this.updateIndentPrefixes();
    }

    protected void uninstallTabsToSpacesConverter() {
        this.updateIndentPrefixes();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
            IDocument document = this.getDocument(input);
            PyPartitionScanner.checkPartitionScanner((IDocument)document);
            final IPythonNature nature = PythonNature.addNature(input);
            final int mainThreadShellId = AbstractShell.getShellId();
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            AbstractShell.getServerShell(nature, mainThreadShellId);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    catch (Exception exception) {}
                }
            };
            thread2.setName("Shell starter");
            thread2.start();
            this.prefListener = PyEdit.createPrefChangeListener(this);
            this.resetForceTabs();
            PydevPrefs.getChainedPrefStore().addPropertyChangeListener(this.prefListener);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        PyEdit.this.pyEditScripting = new PyEditScripting();
                        PyEdit.this.addPyeditListener(PyEdit.this.pyEditScripting);
                    }
                    finally {
                        PyEdit.this.markInitFinished();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setName("PyEdit initializer");
            thread.start();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    public static IPropertyChangeListener createPrefChangeListener(final IPySyntaxHighlightingAndCodeCompletionEditor editor) {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                try {
                    String property = event.getProperty();
                    if (property.equals("TAB_WIDTH")) {
                        ISourceViewer sourceViewer = editor.getEditorSourceViewer();
                        if (sourceViewer == null) {
                            return;
                        }
                        editor.getIndentPrefs().regenerateIndentString();
                        sourceViewer.getTextWidget().setTabs(DefaultIndentPrefs.getStaticTabWidth());
                        editor.resetIndentPrefixes();
                    } else if (property.equals("SUBSTITUTE_TABS")) {
                        editor.getIndentPrefs().regenerateIndentString();
                        editor.resetIndentPrefixes();
                    } else if (property.equals("GUESS_TAB_SUBSTITUTION")) {
                        editor.resetForceTabs();
                        editor.resetIndentPrefixes();
                    } else if (ColorAndStyleCache.isColorOrStyleProperty(property)) {
                        editor.getColorCache().reloadProperty(property);
                        editor.getEditConfiguration().updateSyntaxColorAndStyle();
                        editor.getEditorSourceViewer().invalidateTextPresentation();
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        };
    }

    private void checkAddInvalidModuleNameMarker(IDocument doc, IFile file) {
        try {
            String name = file.getName();
            int i = name.lastIndexOf(46);
            if (i > 0) {
                String modName = name.substring(0, i);
                if (!PythonPathHelper.isValidModuleLastPart(modName)) {
                    this.addInvalidModuleMarker(doc, file, "Invalid name for Python module: " + modName + " (it'll not be analyzed)");
                    return;
                }
                if (!PythonPathHelper.isValidSourceFile(name)) {
                    this.addInvalidModuleMarker(doc, file, "Module: " + modName + " does not have a valid Python extension (it'll not be analyzed).");
                    return;
                }
            }
            this.removeInvalidModuleMarkers(file);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void removeInvalidModuleMarkers(IFile file) {
        try {
            if (file.exists()) {
                file.deleteMarkers(INVALID_MODULE_MARKER_TYPE, true, 0);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void addInvalidModuleMarker(IDocument doc, IFile fileAdapter, String msg) {
        PyMarkerUtils.MarkerInfo markerInfo = new PyMarkerUtils.MarkerInfo(doc, msg, INVALID_MODULE_MARKER_TYPE, 1, false, true, 0, 0, 0, 0, null);
        ArrayList<PyMarkerUtils.MarkerInfo> lst = new ArrayList<PyMarkerUtils.MarkerInfo>();
        lst.add(markerInfo);
        PyMarkerUtils.replaceMarkers(lst, (IResource)fileAdapter, (String)INVALID_MODULE_MARKER_TYPE, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetInput(IEditorInput input) throws CoreException {
        Object oldFile;
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && (oldFile = (IFile)oldInput.getAdapter(IFile.class)) != null) {
            this.removeInvalidModuleMarkers((IFile)oldFile);
        }
        oldFile = this.lockHandle;
        synchronized (oldFile) {
            this.releaseCurrentHandle();
        }
        super.doSetInput(input);
        try {
            IDocument document = this.getDocument(input);
            if (input != null) {
                IFile newFile = (IFile)input.getAdapter(IFile.class);
                if (newFile != null) {
                    this.checkAddInvalidModuleNameMarker(document, newFile);
                }
                this.fixEncoding(input, document);
                PyParserManager.getPyParserManager((IPreferenceStore)PydevPrefs.getPreferences()).attachParserTo((IBaseEditor)this);
                if (document != null) {
                    PyPartitionScanner.checkPartitionScanner((IDocument)document);
                }
            }
            this.notifier.notifyInputChanged(oldInput, input);
            this.notifier.notifyOnSetDocument(document);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            PyEditTitle.invalidateTitle(this, input);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.isCythonFile()) {
                this.setTitleImage(PydevPlugin.getImageCache().get("icons/cython_file.png"));
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    void setEditorTitle(String title) {
        this.setPartName(title);
        this.firePropertyChange(257);
    }

    void setEditorImage(Image image) {
        this.setTitleImage(image);
    }

    private IDocument getDocument(IEditorInput input) {
        return this.getDocumentProvider().getDocument((Object)input);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocument document = this.getDocument();
        try {
            boolean keepOn = true;
            if (PyCodeFormatterPage.getAutoformatOnlyWorkspaceFiles() && this.getIFile() == null) {
                keepOn = false;
            }
            if (keepOn && PydevSaveActionsPrefPage.getFormatBeforeSaving() && !this.isCythonFile()) {
                ITextSelection selection;
                PySelection ps;
                IStatusLineManager statusLineManager = this.getStatusLineManager();
                IDocumentProvider documentProvider = this.getDocumentProvider();
                int[] regionsForSave = null;
                if (PyCodeFormatterPage.getFormatOnlyChangedLines()) {
                    if (documentProvider instanceof PyDocumentProvider) {
                        PyDocumentProvider pyDocumentProvider = (PyDocumentProvider)documentProvider;
                        ITextFileBuffer fileBuffer = pyDocumentProvider.getFileBuffer(this.getEditorInput());
                        if (fileBuffer != null) {
                            regionsForSave = ChangedLinesComputer.calculateChangedLines(fileBuffer, (IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
                        }
                    } else {
                        Log.log((String)("Was expecting PyDocumentProvider. Found: " + documentProvider));
                    }
                }
                if (!(regionsForSave != null && regionsForSave.length <= 0 || this.hasSyntaxError((ps = new PySelection(document, selection = (ITextSelection)this.getSelectionProvider().getSelection())).getDoc()))) {
                    PyFormatStd std = new PyFormatStd();
                    boolean throwSyntaxError = true;
                    try {
                        std.applyFormatAction((IPyFormatStdProvider)this, ps, regionsForSave, throwSyntaxError, this.getSelectionProvider());
                        statusLineManager.setErrorMessage(null);
                    }
                    catch (SyntaxErrorException e) {
                        statusLineManager.setErrorMessage(e.getMessage());
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            this.fixEncoding(this.getEditorInput(), document);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            this.executeSaveActions(document);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        super.performSave(overwrite, progressMonitor);
    }

    private void executeSaveActions(IDocument document) throws BadLocationException {
        if (PydevSaveActionsPrefPage.getDateFieldActionEnabled()) {
            MatchResult matchResult;
            String contents = document.get();
            String fieldName = PydevSaveActionsPrefPage.getDateFieldName();
            String fieldPattern = String.format("^%s(\\s*)=(\\s*[ur]{0,2}['\"]{1,3})(.+?)(['\"]{1,3})", fieldName);
            Pattern pattern = Pattern.compile(fieldPattern, 8);
            Matcher matcher = pattern.matcher(contents);
            if (matcher.find() && (matchResult = matcher.toMatchResult()).groupCount() == 4) {
                String spBefore = matchResult.group(1);
                String spAfterQuoteBegin = matchResult.group(2);
                String dateStr = matchResult.group(3);
                String quoteEnd = matchResult.group(4);
                String dateFormat = PydevSaveActionsPrefPage.getDateFieldFormat();
                Date nowDate = new Date();
                SimpleDateFormat ft = new SimpleDateFormat(dateFormat);
                try {
                    Date fieldDate = ft.parse(dateStr);
                    if (fieldDate.before(nowDate)) {
                        String newDateStr = ft.format(nowDate);
                        String replacement = String.valueOf(fieldName) + spBefore + "=" + spAfterQuoteBegin + newDateStr + quoteEnd;
                        document.replace(matchResult.start(), matchResult.end() - matchResult.start(), replacement);
                    }
                }
                catch (ParseException parseException) {}
            }
        }
        if (PydevSaveActionsPrefPage.getSortImportsOnSave()) {
            boolean automatic = true;
            PyOrganizeImports organizeImports = new PyOrganizeImports(automatic);
            try {
                organizeImports.formatAll(this.getDocument(), (IPyFormatStdProvider)this, this.getIFile(), true, true);
            }
            catch (SyntaxErrorException e) {
                Log.log((Throwable)e);
            }
        }
    }

    protected BaseParserManager getParserManager() {
        return PyParserManager.getPyParserManager(null);
    }

    public boolean hasSyntaxError(IDocument doc) throws MisconfigurationException {
        BaseParser.ParseOutput reparse = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, (IGrammarVersionProvider)this, false));
        if (reparse.error != null) {
            this.getStatusLineManager().setErrorMessage(reparse.error.getMessage());
            return true;
        }
        return false;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    private void fixEncoding(final IEditorInput input, IDocument document) {
        block6: {
            if (input instanceof FileEditorInput) {
                final IFile file = (IFile)((FileEditorInput)input).getAdapter(IFile.class);
                try {
                    final String encoding = FileUtilsFileBuffer.getPythonFileEncoding((IDocument)document, (String)file.getFullPath().toOSString());
                    if (encoding == null) break block6;
                    try {
                        if (!encoding.equals(file.getCharset())) {
                            new Job("Change encoding"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        file.setCharset(encoding, monitor);
                                        ((TextFileDocumentProvider)PyEdit.this.getDocumentProvider()).setEncoding((Object)input, encoding);
                                        file.refreshLocal(2, null);
                                    }
                                    catch (CoreException e) {
                                        Log.log((Throwable)e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        }
                    }
                    catch (CoreException e) {
                        Log.log((Throwable)e);
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
    }

    @Override
    public File getEditorFile() {
        IEditorInput editorInput;
        File editorFile = super.getEditorFile();
        if (editorFile == null && (editorInput = this.getEditorInput()) instanceof PydevFileEditorInput) {
            PydevFileEditorInput pyEditorInput = (PydevFileEditorInput)editorInput;
            return pyEditorInput.getPath().toFile();
        }
        return editorFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lockHandle;
        synchronized (object) {
            this.releaseCurrentHandle();
        }
        if (!this.disposed) {
            this.disposed = true;
            object = currentlyOpenedEditorsLock;
            synchronized (object) {
                currentlyOpenedEditors.remove(this);
            }
            this.outlinePage = null;
            try {
                IFile iFile = this.getIFile();
                if (iFile != null) {
                    this.removeInvalidModuleMarkers(iFile);
                }
            }
            catch (Throwable e1) {
                Log.log((Throwable)e1);
            }
            try {
                this.onDispose.call(null);
                this.notifier.notifyOnDispose();
                PydevPrefs.getChainedPrefStore().removePropertyChangeListener(this.prefListener);
                PyParserManager.getPyParserManager(null).notifyEditorDisposed((IBaseEditor)this);
                this.colorCache.dispose();
                this.pyEditScripting = null;
                this.cache.clear();
                this.cache = null;
                if (this.resourceManager != null) {
                    this.resourceManager.dispose();
                    this.resourceManager = null;
                }
                Collection e1 = this.registeredEditListeners;
                synchronized (e1) {
                    this.registeredEditListeners.clear();
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        try {
            MyResources resources = new MyResources();
            Object action = new ContentAssistAction((ResourceBundle)resources, "ContentAssistProposal.", (ITextEditor)this);
            action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.setAction("ContentAssistProposal", (IAction)action);
            this.markAsStateDependentAction("ContentAssistProposal", true);
            PyOpenAction openAction = new PyOpenAction();
            this.setAction(ACTION_OPEN, (IAction)openAction);
            action = new OfflineAction(resources, "Pyedit.ScriptEngine.", this);
            action.setActionDefinitionId("org.python.pydev.editor.actions.scriptEngine");
            action.setId("org.python.pydev.editor.actions.scriptEngine");
            this.setAction("PyDevScriptEngine", (IAction)action);
            if (this.getIndentPrefs().getSmartLineMove()) {
                action = new PyMoveLineUpAction(resources, "Pyedit.MoveLinesUp.", this);
                action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
                action.setId("org.python.pydev.editor.actions.moveLineUp");
                this.setAction("MoveLineUp", (IAction)action);
                action = new PyMoveLineDownAction(resources, "Pyedit.MoveLinesDown.", this);
                action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
                action.setId("org.python.pydev.editor.actions.moveLineDown");
                this.setAction("MoveLineDown", (IAction)action);
            }
            this.notifier.notifyOnCreateActions((ListResourceBundle)resources);
            this.onCreateActions.call((Object)this);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.python.pydev.ui.editor.scope"});
    }

    public PyParser getParser() {
        return (PyParser)PyParserManager.getPyParserManager(null).getParser((IBaseEditor)this);
    }

    public IStatusLineManager getStatusLineManager() {
        return EditorUtils.getStatusLineManager((ITextEditor)this);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (OfflineActionTarget.class.equals((Object)adapter)) {
            IStatusLineManager manager;
            if (this.fOfflineActionTarget == null && (manager = this.getStatusLineManager()) != null) {
                this.fOfflineActionTarget = this.getSourceViewer() == null ? null : new OfflineActionTarget((ITextViewer)this.getSourceViewer(), manager, this);
            }
            return this.fOfflineActionTarget;
        }
        if (ICodeScannerKeywords.class.equals((Object)adapter)) {
            return new PyEditBasedCodeScannerKeywords(this);
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return this.getOutlinePage();
        }
        Object adaptable = this.onGetAdapter.call((Object)adapter);
        if (adaptable != null) {
            return adaptable;
        }
        return super.getAdapter(adapter);
    }

    public IOutlineModel createOutlineModel() {
        return new ParsedModel((IBaseEditor)this);
    }

    private IContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new PyOutlinePage(this);
        }
        return this.outlinePage;
    }

    public void setSelection(int offset, int length) {
        super.setSelection(offset, length);
    }

    public void revealModelNodes(ISimpleNode[] nodes) {
        if (nodes == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            int startOffset = -1;
            int endOffset = -1;
            PySelection selection = new PySelection((ITextEditor)this);
            ISimpleNode[] iSimpleNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ISimpleNode inode = iSimpleNodeArray[n2];
                SimpleNode node = (SimpleNode)inode;
                int nodeStartoffset = selection.getLineOffset(node.beginLine - 1) + node.beginColumn - 1;
                int[] colLineEnd = NodeUtils.getColLineEnd((SimpleNode)node);
                int nodeEndOffset = selection.getLineOffset(colLineEnd[0] - 1) + colLineEnd[1] - 1;
                if (startOffset == -1 || nodeStartoffset < startOffset) {
                    startOffset = nodeStartoffset;
                }
                if (endOffset == -1 || nodeEndOffset > endOffset) {
                    endOffset = nodeEndOffset;
                }
                ++n2;
            }
            this.setSelection(startOffset, endOffset - startOffset);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void revealModelNode(SimpleNode node) {
        if (node == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            PySelection selection = new PySelection((ITextEditor)this);
            int offset = selection.getLineOffset(node.beginLine - 1) + node.beginColumn - 1;
            int[] colLineEnd = NodeUtils.getColLineEnd((SimpleNode)node);
            int endOffset = selection.getLineOffset(colLineEnd[0] - 1) + colLineEnd[1] - 1;
            int length = endOffset - offset;
            this.setSelection(offset, length);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void releaseCurrentHandle() {
        if (this.handle != null) {
            ((IModulesManager)this.handle.o2).popTemporaryModule((String)this.handle.o3, ((Integer)this.handle.o1).intValue());
            this.handle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parserChanged(ChangedParserInfoForObservers info) {
        block5: {
            this.errorDescription = info.errorInfo != null ? PyParser.createParserErrorMarkers((Throwable)info.errorInfo.error, (IAdaptable)info.file, (IDocument)info.doc) : null;
            this.ast = (SimpleNode)info.root;
            this.astModificationTimeStamp = info.docModificationStamp;
            try {
                String moduleName;
                File editorFile;
                IModulesManager modulesManager;
                ICodeCompletionASTManager astManager;
                IPythonNature pythonNature = this.getPythonNature();
                if (pythonNature == null || (astManager = pythonNature.getAstManager()) == null || (modulesManager = astManager.getModulesManager()) == null || (editorFile = this.getEditorFile()) == null || (moduleName = pythonNature.resolveModule(editorFile)) == null) break block5;
                Object object = this.lockHandle;
                synchronized (object) {
                    this.releaseCurrentHandle();
                    int modHandle = modulesManager.pushTemporaryModule(moduleName, (IModule)new SourceModule(moduleName, editorFile, this.ast, null));
                    this.handle = new Tuple3((Object)modHandle, (Object)modulesManager, (Object)moduleName);
                }
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
            }
        }
        this.fireModelChanged((ISimpleNode)this.ast);
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!PyEdit.this.isDisposed()) {
                    PyEdit.this.getSourceViewer().invalidateTextPresentation();
                }
            }
        });
    }

    public void parserChanged(ISimpleNode root, IAdaptable file, IDocument doc, long docModificationStamp) {
        throw new AssertionError((Object)"Implementing IParserObserver3: this should not be called anymore");
    }

    public void parserError(Throwable error, IAdaptable original, IDocument doc) {
        throw new AssertionError((Object)"Implementing IParserObserver3: this should not be called anymore");
    }

    public void parserError(ErrorParserInfoForObservers info) {
        this.errorDescription = PyParser.createParserErrorMarkers((Throwable)info.error, (IAdaptable)info.file, (IDocument)info.doc);
        this.fireParseErrorChanged(this.errorDescription);
    }

    public SimpleNode getAST() {
        return this.ast;
    }

    public long getAstModificationTimeStamp() {
        return this.astModificationTimeStamp;
    }

    public List<String[]> getInnerStructureFromLine(int line) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        List parseToKnowGloballyAccessiblePath = FastParser.parseToKnowGloballyAccessiblePath((IDocument)this.getDocument(), (int)line);
        for (stmtType stmtType2 : parseToKnowGloballyAccessiblePath) {
            String rep = NodeUtils.getRepresentationString((SimpleNode)stmtType2);
            String image = stmtType2 instanceof ClassDef ? "icons/new/class_obj.gif" : (stmtType2 instanceof FunctionDef ? "icons/new/method_obj.gif" : "icons/showerr_tsk.gif");
            ret.add(new String[]{rep, image});
        }
        return ret;
    }

    public static void openWithPathAndInnerStructure(String projectName, IPath path, List<String> innerStructure) throws MisconfigurationException {
        IEditorPart editor;
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project != null && (file = project.getFile(path)) != null && (editor = PyOpenEditor.doOpenEditor(file)) instanceof PyEdit) {
            PyEdit pyEdit = (PyEdit)editor;
            IPythonNature nature = pyEdit.getPythonNature();
            SourceModule mod = AbstractModule.createModuleFromDoc(nature.resolveModule((IResource)file), file.getLocation().toFile(), pyEdit.getDocument(), (IGrammarVersionProvider)nature, false);
            StringBuffer tok = new StringBuffer(80);
            for (String s : innerStructure) {
                if (tok.length() > 0) {
                    tok.append('.');
                }
                tok.append(s);
            }
            try {
                IDefinition[] definitions = ((AbstractModule)mod).findDefinition(CompletionStateFactory.getEmptyCompletionState(tok.toString(), nature, new CompletionCache()), -1, -1, nature);
                ArrayList<ItemPointer> pointers = new ArrayList<ItemPointer>();
                PyRefactoringFindDefinition.getAsPointers(pointers, definitions);
                if (pointers.size() > 0) {
                    new PyOpenAction().run((ItemPointer)((Object)pointers.get(0)));
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    public ErrorDescription getErrorDescription() {
        return this.errorDescription;
    }

    public int getGrammarVersion() throws MisconfigurationException {
        if (this.isCythonFile()) {
            return 777;
        }
        IPythonNature nature = this.getPythonNature();
        if (nature != null) {
            return nature.getGrammarVersion();
        }
        File editorFile = this.getEditorFile();
        if (editorFile == null) {
            throw new MisconfigurationException();
        }
        Tuple<IPythonNature, String> infoForFile = PydevPlugin.getInfoForFile(editorFile);
        if (infoForFile == null || infoForFile.o1 == null) {
            throw new MisconfigurationException();
        }
        return ((IPythonNature)infoForFile.o1).getGrammarVersion();
    }

    public IGrammarVersionProvider getGrammarVersionProvider() {
        return new IGrammarVersionProvider(){

            public int getGrammarVersion() throws MisconfigurationException {
                return PyEdit.this.getGrammarVersion();
            }
        };
    }

    public boolean isCythonFile() {
        IFile iFile = this.getIFile();
        String fileName = null;
        if (iFile != null) {
            fileName = iFile.getName();
        } else {
            File editorFile = this.getEditorFile();
            if (editorFile != null) {
                fileName = editorFile.getName();
            }
        }
        return FileTypesPreferencesPage.isCythonFile(fileName);
    }

    @Override
    public IPythonNature getPythonNature() throws MisconfigurationException {
        IProject project = this.getProject();
        if (project == null || !project.isOpen()) {
            return null;
        }
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        if (pythonNature != null) {
            return pythonNature;
        }
        pythonNature = PythonNature.addNature(this.getEditorInput());
        if (pythonNature != null) {
            return pythonNature;
        }
        File editorFile = this.getEditorFile();
        if (editorFile == null) {
            return null;
        }
        Tuple<IPythonNature, String> infoForFile = PydevPlugin.getInfoForFile(editorFile);
        if (infoForFile == null) {
            NotConfiguredInterpreterException e = new NotConfiguredInterpreterException();
            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Error: no interpreter configured", (String)"Interpreter not configured\n(Please, Configure it under window->preferences->PyDev)", (IStatus)PydevPlugin.makeStatus(4, e.getMessage(), (Throwable)e));
            throw e;
        }
        pythonNature = (IPythonNature)infoForFile.o1;
        return pythonNature;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        try {
            this.setPreferenceStore(PydevPrefs.getChainedPrefStore());
            this.setEditorContextMenuId(PY_EDIT_CONTEXT);
            this.setRulerContextMenuId(PY_EDIT_RULER_CONTEXT);
            this.setDocumentProvider((IDocumentProvider)PyDocumentProvider.instance);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    public Collection<ActionInfo> getOfflineActionDescriptions() {
        return this.offlineActionsManager.getOfflineActionDescriptions();
    }

    public void addOfflineActionListener(String key, IAction action) {
        this.offlineActionsManager.addOfflineActionListener(key, action);
    }

    public void addOfflineActionListener(String key, IAction action, String description, boolean needsEnter) {
        this.offlineActionsManager.addOfflineActionListener(key, action, description, needsEnter);
    }

    public boolean activatesAutomaticallyOn(String key) {
        return this.offlineActionsManager.activatesAutomaticallyOn(key);
    }

    public boolean hasOfflineAction(String key) {
        return this.offlineActionsManager.hasOfflineAction(key);
    }

    public boolean onOfflineAction(String requestedStr, OfflineActionTarget target) {
        return this.offlineActionsManager.onOfflineAction(requestedStr, target);
    }

    public synchronized LocalResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public Font getFont(FontData descriptor) throws DeviceResourceException {
        Font font = this.getResourceManager().createFont(FontDescriptor.createFrom((FontData)descriptor));
        return font;
    }

    public static void checkValidateState(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditorExtension2) {
            ITextEditorExtension2 editor = (ITextEditorExtension2)iEditorPart;
            editor.validateEditorInputState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEditorOpenForResource(IResource r) {
        Object object = currentlyOpenedEditorsLock;
        synchronized (object) {
            Object adapter;
            PyEdit edit;
            IEditorInput input;
            Iterator<PyEdit> iterator = currentlyOpenedEditors.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((input = (edit = iterator.next()).getEditorInput()) == null || (adapter = input.getAdapter(IResource.class)) == null || !r.equals(adapter));
            return true;
        }
    }

    public PyFormatStd.FormatStd getFormatStd() {
        return PyFormatStd.getFormat();
    }

    public void setMessage(boolean error, String message) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        statusLine.setMessage(error, message, null);
    }

    public void showInformationDialog(String title, String message) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)title, (String)message);
    }

    public int getPrintMarginColums() {
        return PydevPrefs.getChainedPrefStore().getInt("printMarginColumn");
    }

    public void asyncExec(Runnable runnable) {
        RunInUiThread.async((Runnable)runnable);
    }

    public Class<Action> getActionClass() {
        return Action.class;
    }

    public Class<IPyCompletionProposal> getIPyCompletionProposalClass() {
        return IPyCompletionProposal.class;
    }

    public Class<PyCompletionProposal> getPyCompletionProposalClass() {
        return PyCompletionProposal.class;
    }

    public Class<UIConstants> getUIConstantsClass() {
        return UIConstants.class;
    }

    public Class<ScriptConsole> getScriptConsoleClass() {
        return ScriptConsole.class;
    }

    public Class<Display> getDisplayClass() {
        return Display.class;
    }

    public Class<Runnable> getRunnableClass() {
        return Runnable.class;
    }

    public Class<PySelection> getPySelectionClass() {
        return PySelection.class;
    }

    public Class<UIJob> getUIJobClass() {
        return UIJob.class;
    }

    public Class<IDocumentListener> getIDocumentListenerClass() {
        return IDocumentListener.class;
    }

    public Class<PythonCorrectionProcessor> getPythonCorrectionProcessorClass() {
        return PythonCorrectionProcessor.class;
    }

    public IStatus getOkStatus() {
        return Status.OK_STATUS;
    }

    public String toString() {
        return "PyEdit[" + this.getEditorFile() + "]";
    }

    public ICharacterPairMatcher2 getPairMatcher() {
        return new PythonPairMatcher();
    }

    public IScopesParser createScopesParser() {
        return new ScopesParser();
    }

    public static class MyResources
    extends ListResourceBundle {
        static final Object[][] contents = new Object[][]{{"CorrectionAssist", "CorrectionAssist"}, {"ContentAssistProposal", "ContentAssistProposal"}, {"TemplateProposals", "TemplateProposals"}};

        @Override
        public Object[][] getContents() {
            return contents;
        }
    }
}

