/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyStringScanner
implements ITokenScanner {
    private final ColorAndStyleCache colorCache;
    private Token fDocStringMarkupTextReturnToken;
    protected IToken fStringReturnToken;
    private char[] fChars;
    private int fOffset;
    private int fCurrIndex;
    private int fstart;

    public PyStringScanner(ColorAndStyleCache colorCache) {
        this.colorCache = colorCache;
        this.updateColorAndStyle();
    }

    public void updateColorAndStyle() {
        this.fStringReturnToken = new Token((Object)this.colorCache.getStringTextAttribute());
        this.fDocStringMarkupTextReturnToken = new Token((Object)this.colorCache.getDocstringMarkupTextAttribute());
    }

    public void setRange(IDocument document, int offset, int length) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        this.checkRange(offset, length, documentLength);
        this.fOffset = offset;
        this.fCurrIndex = 0;
        this.fstart = 0;
        try {
            this.fChars = document.get(offset, length).toCharArray();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    public int getTokenOffset() {
        return this.fOffset + this.fstart;
    }

    public int getTokenLength() {
        return this.fCurrIndex - this.fstart;
    }

    /*
     * Unable to fully structure code
     */
    public IToken nextToken() {
        this.fstart = this.fCurrIndex;
        c = this.read();
        if (c == -1) {
            this.fChars = null;
            return Token.EOF;
        }
        if (Character.isWhitespace(c)) {
            while (Character.isWhitespace(c) && c != -1) {
                c = this.read();
            }
            this.unread();
            return this.fStringReturnToken;
        }
        if (c != 64 && c != 58) ** GOTO lbl22
        c = this.read();
        if (c != -1) ** GOTO lbl18
        this.unread();
        return this.fDocStringMarkupTextReturnToken;
lbl-1000:
        // 1 sources

        {
            c = this.read();
lbl18:
            // 2 sources

            ** while (Character.isJavaIdentifierPart((int)c))
        }
lbl19:
        // 1 sources

        this.unread();
        return this.fDocStringMarkupTextReturnToken;
lbl-1000:
        // 1 sources

        {
            c = this.read();
lbl22:
            // 2 sources

            ** while (c != -1 && c != 13 && c != 10)
        }
lbl23:
        // 1 sources

        if (c != -1) ** GOTO lbl27
        this.unread();
        return this.fStringReturnToken;
lbl-1000:
        // 1 sources

        {
            c = this.read();
lbl27:
            // 2 sources

            ** while (c == 13 && c == 10)
        }
lbl28:
        // 1 sources

        this.unread();
        return this.fStringReturnToken;
    }

    private int read() {
        if (this.fCurrIndex >= this.fChars.length) {
            ++this.fCurrIndex;
            return -1;
        }
        char c = this.fChars[this.fCurrIndex];
        ++this.fCurrIndex;
        return c;
    }

    private void unread() {
        --this.fCurrIndex;
    }
}

