/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.IStatusFieldExtension;
import org.python.pydev.editor.KeyAssistDialog;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class OfflineActionTarget
implements VerifyKeyListener,
MouseListener,
FocusListener,
ISelectionChangedListener,
ITextListener {
    private static final String TAB = "<TAB>";
    private final ITextViewer fTextViewer;
    private final IStatusLineManager fStatusLine;
    private StringBuffer fFindString = new StringBuffer();
    private boolean fInstalled;
    private IStatusField fStatusField;
    private boolean fIsStatusFieldExtension;
    private PyEdit fEdit;
    private KeyAssistDialog keyAssistDialog;
    private Object lock = new Object();

    public OfflineActionTarget(ITextViewer viewer, IStatusLineManager manager, PyEdit edit) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)manager);
        this.fTextViewer = viewer;
        this.fStatusLine = manager;
        this.fEdit = edit;
    }

    public void beginSession() {
        if (this.fInstalled) {
            this.updateStatus();
            return;
        }
        this.fFindString.setLength(0);
        this.install();
        this.updateStatus();
    }

    public void endSession() {
    }

    private void install() {
        if (this.fInstalled) {
            return;
        }
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null) {
            return;
        }
        text.addMouseListener((MouseListener)this);
        text.addFocusListener((FocusListener)this);
        this.fTextViewer.addTextListener((ITextListener)this);
        ISelectionProvider selectionProvider = this.fTextViewer.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.fTextViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)this.fTextViewer).prependVerifyKeyListener((VerifyKeyListener)this);
        } else {
            text.addVerifyKeyListener((VerifyKeyListener)this);
        }
        this.keyAssistDialog = new KeyAssistDialog(this.fEdit);
        this.fInstalled = true;
        new UIJob(""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object object = OfflineActionTarget.this.lock;
                synchronized (object) {
                    if (OfflineActionTarget.this.fInstalled && OfflineActionTarget.this.keyAssistDialog != null) {
                        OfflineActionTarget.this.keyAssistDialog.open(OfflineActionTarget.this.fEdit.getOfflineActionDescriptions(), OfflineActionTarget.this);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule(700L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstall() {
        Object object = this.lock;
        synchronized (object) {
            StyledText text;
            if (!this.fInstalled) {
                return;
            }
            this.fTextViewer.removeTextListener((ITextListener)this);
            ISelectionProvider selectionProvider = this.fTextViewer.getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if ((text = this.fTextViewer.getTextWidget()) != null) {
                text.removeMouseListener((MouseListener)this);
                text.removeFocusListener((FocusListener)this);
            }
            if (this.fTextViewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)this.fTextViewer).removeVerifyKeyListener((VerifyKeyListener)this);
            } else if (text != null) {
                text.removeVerifyKeyListener((VerifyKeyListener)this);
            }
            if (this.keyAssistDialog != null) {
                this.keyAssistDialog.close();
            }
            this.keyAssistDialog = null;
            this.fInstalled = false;
        }
    }

    private void updateStatus() {
        if (!this.fInstalled) {
            return;
        }
        String string = this.fFindString.toString();
        this.statusMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyKey(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.character == '\u0000') {
            switch (event.keyCode) {
                case 0x1000002: {
                    Object object = this.lock;
                    synchronized (object) {
                        Table completionsTable;
                        KeyAssistDialog tempKeyAssistDialog = this.keyAssistDialog;
                        if (tempKeyAssistDialog != null && (completionsTable = this.keyAssistDialog.getCompletionsTable()) != null && !completionsTable.isDisposed()) {
                            completionsTable.setFocus();
                            completionsTable.setSelection(0);
                            event.doit = false;
                            break;
                        }
                    }
                }
                case 0x1000001: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: {
                    this.leave();
                }
            }
        } else {
            switch (event.character) {
                case '\u001b': {
                    this.leave();
                    event.doit = false;
                    break;
                }
                case '\r': {
                    boolean executed = this.doExec();
                    event.doit = false;
                    if (executed) break;
                    return;
                }
                case '\b': 
                case '\u007f': {
                    this.removeLastCharSearch();
                    event.doit = false;
                    break;
                }
                default: {
                    boolean executed;
                    if (event.stateMask != 0 && event.stateMask != 131072 && event.stateMask != 327680) break;
                    event.doit = false;
                    if (!this.addCharSearch(event.character) || (executed = this.doExec())) break;
                    return;
                }
            }
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExec() {
        boolean executed;
        this.statusClear();
        String key = this.fFindString.toString();
        if (this.fEdit.hasOfflineAction(key)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.keyAssistDialog != null) {
                    this.keyAssistDialog.close();
                    this.keyAssistDialog = null;
                }
            }
        }
        if (executed = this.fEdit.onOfflineAction(key, this)) {
            this.uninstall();
        }
        return executed;
    }

    public void removeLastCharSearchAndUpdateStatus() {
        this.removeLastCharSearch();
        this.updateStatus();
    }

    private void removeLastCharSearch() {
        int len = this.fFindString.length();
        if (len > 0) {
            this.fFindString.deleteCharAt(len - 1);
        }
    }

    private boolean addCharSearch(char c) {
        this.fFindString.append(c);
        return this.fEdit.activatesAutomaticallyOn(this.fFindString.toString());
    }

    public void leave() {
        this.statusClear();
        this.uninstall();
    }

    public void textChanged(TextEvent event) {
        if (event.getDocumentEvent() != null) {
            this.leave();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.leave();
    }

    public void mouseDown(MouseEvent e) {
        this.leave();
    }

    public void mouseUp(MouseEvent e) {
        this.leave();
    }

    public void focusGained(FocusEvent e) {
        this.leave();
    }

    public void focusLost(FocusEvent e) {
        Table completionsTable;
        KeyAssistDialog tempKeyAssistDialog = this.keyAssistDialog;
        if (tempKeyAssistDialog != null && (completionsTable = tempKeyAssistDialog.getCompletionsTable()) != null && !completionsTable.isDisposed()) {
            new UIJob("Check leave"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Object object = OfflineActionTarget.this.lock;
                    synchronized (object) {
                        if (OfflineActionTarget.this.fInstalled && OfflineActionTarget.this.keyAssistDialog != null && !completionsTable.isDisposed()) {
                            if (!completionsTable.isFocusControl()) {
                                OfflineActionTarget.this.leave();
                            } else {
                                completionsTable.addFocusListener(new FocusListener(){

                                    public void focusLost(FocusEvent e) {
                                        OfflineActionTarget.this.leave();
                                    }

                                    public void focusGained(FocusEvent e) {
                                        OfflineActionTarget.this.leave();
                                    }
                                });
                                completionsTable.addKeyListener(new KeyListener(){

                                    public void keyReleased(KeyEvent e) {
                                        if (e.character == '\u001b') {
                                            OfflineActionTarget.this.leave();
                                        }
                                    }

                                    public void keyPressed(KeyEvent e) {
                                    }
                                });
                            }
                        } else {
                            OfflineActionTarget.this.leave();
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule(50L);
        }
    }

    private void statusMessage(String string) {
        if (this.fStatusField != null) {
            if (this.fIsStatusFieldExtension) {
                ((IStatusFieldExtension)this.fStatusField).setErrorText(null);
                this.fStatusField.setText(this.escapeTabs(string));
                ((IStatusFieldExtension)this.fStatusField).setVisible(true);
                this.fStatusLine.update(true);
            } else {
                this.fStatusLine.setErrorMessage(null);
                this.fStatusField.setText(this.escapeTabs(string));
            }
        } else {
            this.fStatusLine.setErrorMessage(null);
            this.fStatusLine.setMessage(this.escapeTabs(string));
        }
    }

    public void statusError(String string) {
        if (this.fStatusField != null) {
            if (this.fIsStatusFieldExtension) {
                ((IStatusFieldExtension)this.fStatusField).setErrorText(this.escapeTabs(string));
                this.fStatusField.setText("");
                ((IStatusFieldExtension)this.fStatusField).setVisible(true);
                this.fStatusLine.update(true);
            } else {
                this.fStatusLine.setErrorMessage(this.escapeTabs(string));
                this.fStatusField.setText("");
            }
        } else {
            this.fStatusLine.setErrorMessage(this.escapeTabs(string));
            this.fStatusLine.setMessage(null);
        }
    }

    public void statusClear() {
        if (this.fStatusField != null) {
            if (this.fIsStatusFieldExtension) {
                this.fStatusField.setText("");
                ((IStatusFieldExtension)this.fStatusField).setErrorText(null);
                ((IStatusFieldExtension)this.fStatusField).setVisible(false);
                this.fStatusLine.update(true);
            } else {
                this.fStatusField.setText("");
                this.fStatusLine.setErrorMessage(null);
            }
        } else {
            this.fStatusLine.setErrorMessage(null);
            this.fStatusLine.setMessage(null);
        }
    }

    private String escapeTabs(String string) {
        FastStringBuffer buffer = new FastStringBuffer();
        int begin = 0;
        int end = string.indexOf(9, begin);
        while (end >= 0) {
            buffer.append(string.substring(begin, end));
            buffer.append(TAB);
            begin = end + 1;
            end = string.indexOf(9, begin);
        }
        buffer.append(string.substring(begin));
        return buffer.toString();
    }

    public void selectionChanged(SelectionChangedEvent e) {
    }

    void setStatusField(IStatusField statusField) {
        this.fStatusField = statusField;
        this.fIsStatusFieldExtension = this.fStatusField instanceof IStatusFieldExtension;
    }

    public boolean isInstalled() {
        return this.fInstalled;
    }
}

