/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.AbstractBlockCommentAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyAddSingleBlockComment
extends AbstractBlockCommentAction {
    public PyAddSingleBlockComment() {
    }

    PyAddSingleBlockComment(int defaultCols, boolean alignLeft) {
        super(defaultCols, alignLeft);
    }

    @Override
    public Tuple<Integer, Integer> perform(PySelection ps) {
        FastStringBuffer strbuf = new FastStringBuffer();
        ps.selectCompleteLine();
        try {
            int i = ps.getStartLineIndex();
            while (i <= ps.getEndLineIndex()) {
                String line = StringUtils.rightTrim((String)ps.getLine(i));
                if (this.getAlignRight()) {
                    strbuf.append(this.getRightAlignedFullCommentLine(line));
                    strbuf.append(line.trim());
                    if (i != ps.getEndLineIndex()) {
                        strbuf.append(ps.getEndLineDelim());
                    }
                } else {
                    Tuple<Integer, Character> colsAndChar = this.getColsAndChar();
                    int cols = (Integer)colsAndChar.o1;
                    char c = ((Character)colsAndChar.o2).charValue();
                    FastStringBuffer buffer = this.makeBufferToIndent(line, cols);
                    int lenOfStrWithTabsAsSpaces = this.getLenOfStrConsideringTabEditorLen(buffer.toString());
                    int diff = lenOfStrWithTabsAsSpaces - buffer.length();
                    buffer.append("# ");
                    buffer.append(line.trim());
                    buffer.append(' ');
                    while (buffer.length() + diff < cols) {
                        buffer.append(c);
                    }
                    strbuf.append(buffer);
                    if (i != ps.getEndLineIndex()) {
                        strbuf.append(ps.getEndLineDelim());
                    }
                }
                ++i;
            }
            int startOffset = ps.getStartLine().getOffset();
            String str = strbuf.toString();
            ps.getDoc().replace(startOffset, ps.getSelLength(), str);
            return new Tuple((Object)(startOffset + str.length()), (Object)0);
        }
        catch (Exception e) {
            PyAddSingleBlockComment.beep(e);
            return null;
        }
    }

    private boolean getAlignRight() {
        if (SharedCorePlugin.inTestMode()) {
            return this.alignRight;
        }
        PydevPlugin plugin = PydevPlugin.getDefault();
        return plugin.getPluginPreferences().getBoolean("SINGLE_BLOCK_COMMENT_ALIGN_RIGHT");
    }

    @Override
    protected String getPreferencesNameForChar() {
        return "SINGLE_BLOCK_COMMENT_CHAR";
    }

    protected String getRightAlignedFullCommentLine(String line) {
        Tuple<Integer, Character> colsAndChar = this.getColsAndChar();
        int cols = (Integer)colsAndChar.o1;
        char c = ((Character)colsAndChar.o2).charValue();
        FastStringBuffer buffer = this.makeBufferToIndent(line, cols);
        int lenOfStrWithTabsAsSpaces = this.getLenOfStrConsideringTabEditorLen(buffer.toString());
        int diff = lenOfStrWithTabsAsSpaces - buffer.length();
        buffer.append("#");
        int i = 0;
        while (i + line.length() + diff < cols - 2) {
            buffer.append(c);
            ++i;
        }
        buffer.append(" ");
        return buffer.toString();
    }

    private FastStringBuffer makeBufferToIndent(String line, int cols) {
        FastStringBuffer buffer = new FastStringBuffer(cols);
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch != '\t' && ch != ' ') break;
            buffer.append(ch);
            ++i;
        }
        return buffer;
    }
}

