/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.AbstractJavaClassModule;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PyOpenAction
extends Action {
    public IEditorPart editor;

    public static void showInEditor(ITextEditor textEdit, Location start, Location end) {
        EditorUtils.showInEditor((ITextEditor)textEdit, (Location)start, (Location)end);
    }

    public void run(ItemPointer p, IProject project) {
        this.run(p, project, null);
    }

    public void run(ItemPointer p, IProject project, IWorkbenchPartSite site) {
        File f;
        String filename;
        this.editor = null;
        Object file = p.file;
        String zipFilePath = p.zipFilePath;
        Definition definition = p.definition;
        if (!(!(file instanceof File) || PythonPathHelper.isValidSourceFile(filename = (f = (File)file).getName()) || filename.indexOf(46) == -1 || zipFilePath != null && PythonPathHelper.isValidSourceFile(zipFilePath))) {
            if (definition instanceof JavaDefinition) {
                if (site == null) {
                    site = EditorUtils.getSite();
                }
                if (site == null) {
                    Log.log((String)"Unable to open JavaDefinition because we have no active site.");
                }
                JavaDefinition javaDefinition = (JavaDefinition)definition;
                OpenAction openAction = new OpenAction((IWorkbenchSite)site);
                StructuredSelection selection = new StructuredSelection(new Object[]{javaDefinition.javaElement});
                openAction.run((IStructuredSelection)selection);
            } else {
                String message;
                boolean giveError = true;
                if (definition != null && definition.module instanceof AbstractJavaClassModule) {
                    AbstractJavaClassModule module = (AbstractJavaClassModule)definition.module;
                    message = "The definition was found at: " + f.toString() + "\n" + "as the java module: " + module.getName();
                } else {
                    if (FileTypesPreferencesPage.isValidDll(filename) && f.exists()) {
                        File parentFile = f.getParentFile();
                        File newFile = new File(parentFile, String.valueOf(StringUtils.stripExtension((String)f.getName())) + "." + "pyx");
                        if (!newFile.exists()) {
                            newFile = new File(parentFile, String.valueOf(StringUtils.stripExtension((String)f.getName())) + "." + "pxd");
                        }
                        if (!newFile.exists()) {
                            newFile = new File(parentFile, String.valueOf(StringUtils.stripExtension((String)f.getName())) + "." + "pxi");
                        }
                        if (newFile.exists()) {
                            giveError = false;
                            file = newFile;
                        }
                    }
                    message = "The definition was found at: " + f.toString() + "\n" + "(which cannot be opened because it is a compiled extension)";
                }
                if (giveError) {
                    MessageDialog.openInformation((Shell)EditorUtils.getShell(), (String)"Compiled Extension file", (String)message);
                    return;
                }
            }
        }
        if (zipFilePath != null) {
            this.editor = PyOpenEditor.doOpenEditor((File)file, zipFilePath);
        } else if (file instanceof IFile) {
            f = (IFile)file;
            this.editor = PyOpenEditor.doOpenEditor((IFile)f);
        } else if (file instanceof IPath) {
            IPath path = (IPath)file;
            this.editor = PyOpenEditor.doOpenEditor(path, project);
        } else if (file instanceof File) {
            String absPath = FileUtils.getFileAbsolutePath((File)((File)file));
            IPath path = Path.fromOSString((String)absPath);
            this.editor = PyOpenEditor.doOpenEditor(path, project);
        }
        if (this.editor instanceof ITextEditor && p.start.line >= 0) {
            EditorUtils.showInEditor((ITextEditor)((ITextEditor)this.editor), (Location)p.start, (Location)p.end);
        }
    }

    public void run(ItemPointer p) {
        this.run(p, null);
    }
}

