/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.actions.OrganizeImportsFixesUnused;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.organize_imports.ImportArranger;
import org.python.pydev.editor.actions.organize_imports.Pep8ImportArranger;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.ui.importsconf.ImportsPreferencesPage;

public class PyOrganizeImports
extends PyAction
implements IFormatter {
    private final boolean automatic;

    public PyOrganizeImports() {
        this.automatic = false;
    }

    public PyOrganizeImports(boolean automatic) {
        this.automatic = automatic;
    }

    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = this.getPyEdit();
            PySelection ps = new PySelection((ITextEditor)pyEdit);
            IDocument doc = ps.getDoc();
            if (ps.getStartLineIndex() == ps.getEndLineIndex()) {
                this.organizeImports(pyEdit, doc, null, ps);
            } else {
                String endLineDelim = ps.getEndLineDelim();
                DocumentRewriteSession session = this.startWrite(doc);
                PyOrganizeImports.performSimpleSort(doc, endLineDelim, ps.getStartLineIndex(), ps.getEndLineIndex());
                this.endWrite(doc, session);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            PyOrganizeImports.beep(e);
        }
    }

    private void organizeImports(PyEdit edit, IDocument doc, IFile f, PySelection ps) {
        DocumentRewriteSession session = null;
        String endLineDelim = ps.getEndLineDelim();
        List participants = null;
        if (f == null && !this.automatic) {
            participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_organize_imports");
            for (IOrganizeImports organizeImports : participants) {
                if (organizeImports.beforePerformArrangeImports(ps, edit, f)) continue;
                return;
            }
        }
        String indentStr = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get().getIndentationString();
        session = this.startWrite(doc);
        try {
            boolean pep8;
            boolean removeUnusedImports = false;
            if (!this.automatic && (removeUnusedImports = ImportsPreferencesPage.getDeleteUnusedImports())) {
                new OrganizeImportsFixesUnused().beforePerformArrangeImports(ps, edit, f);
            }
            if (pep8 = ImportsPreferencesPage.getPep8Imports()) {
                if (f == null) {
                    f = edit.getIFile();
                }
                IProject p = f != null ? f.getProject() : null;
                PyOrganizeImports.pep8PerformArrangeImports(doc, removeUnusedImports, endLineDelim, p, indentStr, this.automatic, (IPyFormatStdProvider)edit);
            } else {
                PyOrganizeImports.performArrangeImports(doc, removeUnusedImports, endLineDelim, indentStr, this.automatic, (IPyFormatStdProvider)edit);
            }
            if (participants != null) {
                for (IOrganizeImports organizeImports : participants) {
                    organizeImports.afterPerformArrangeImports(ps, edit);
                }
            }
        }
        finally {
            if (session != null) {
                this.endWrite(doc, session);
            }
        }
    }

    private void endWrite(IDocument doc, DocumentRewriteSession session) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            d.stopRewriteSession(session);
        }
    }

    private DocumentRewriteSession startWrite(IDocument doc) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            return d.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
        }
        return null;
    }

    public static void performArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        new ImportArranger(doc, removeUnusedImports, endLineDelim, indentStr, automatic).perform(edit);
    }

    public static void pep8PerformArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, IProject prj, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        new Pep8ImportArranger(doc, removeUnusedImports, endLineDelim, prj, indentStr, automatic).perform(edit);
    }

    public static void performSimpleSort(IDocument doc, String endLineDelim, int startLine, int endLine) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer lastLine = null;
            int i = startLine;
            while (i <= endLine) {
                String line = PySelection.getLine((IDocument)doc, (int)i);
                if (lastLine != null) {
                    int len = lastLine.length();
                    if (len > 0 && lastLine.charAt(len - 1) == '\\') {
                        lastLine.append(endLineDelim);
                        lastLine.append(line);
                    } else {
                        list.add(lastLine.toString());
                        lastLine = new StringBuffer(line);
                    }
                } else {
                    lastLine = new StringBuffer(line);
                }
                ++i;
            }
            if (lastLine != null) {
                list.add(lastLine.toString());
            }
            Collections.sort(list);
            StringBuffer all = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                all.append(element);
                if (!iter.hasNext()) continue;
                all.append(endLineDelim);
            }
            int length = doc.getLineInformation(endLine).getLength();
            int endOffset = doc.getLineInformation(endLine).getOffset() + length;
            int startOffset = doc.getLineInformation(startLine).getOffset();
            doc.replace(startOffset, endOffset - startOffset, all.toString());
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }

    public static void performArrangeImports(Document doc, String endLineDelim, String indentStr, IPyFormatStdProvider edit) {
        PyOrganizeImports.performArrangeImports((IDocument)doc, false, endLineDelim, indentStr, false, edit);
    }

    public static void performPep8ArrangeImports(Document doc, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        IProject project = null;
        PyOrganizeImports.pep8PerformArrangeImports((IDocument)doc, false, endLineDelim, project, indentStr, automatic, edit);
    }

    public void formatAll(IDocument doc, IPyFormatStdProvider edit, IFile f, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        this.organizeImports((PyEdit)edit, doc, f, new PySelection(doc));
    }

    public void formatSelection(IDocument doc, int[] regionsToFormat, IPyFormatStdProvider edit, PySelection ps) {
        throw new UnsupportedOperationException();
    }
}

