/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions.codefolding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codefolding.PyProjectionAnnotation;

public abstract class PyFoldingAction
extends PyAction {
    protected Iterator<PyProjectionAnnotation> getAnnotationsIterator(final ProjectionAnnotationModel model, boolean useExpanded) {
        Iterator iter = model.getAnnotationIterator();
        if (iter != null) {
            ArrayList<PyProjectionAnnotation> expanded = new ArrayList<PyProjectionAnnotation>();
            while (iter.hasNext()) {
                PyProjectionAnnotation element = (PyProjectionAnnotation)((Object)iter.next());
                if (element.isCollapsed() != useExpanded) continue;
                expanded.add(element);
            }
            Collections.sort(expanded, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int e2Off;
                    PyProjectionAnnotation e1 = (PyProjectionAnnotation)((Object)o1);
                    PyProjectionAnnotation e2 = (PyProjectionAnnotation)((Object)o2);
                    int e1Off = model.getPosition((Annotation)e1).getOffset();
                    if (e1Off < (e2Off = model.getPosition((Annotation)e2).getOffset())) {
                        return -1;
                    }
                    if (e1Off > e2Off) {
                        return 1;
                    }
                    return 0;
                }
            });
            iter = expanded.iterator();
        }
        return iter;
    }

    protected ProjectionAnnotationModel getModel() {
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.getTextEditor().getAdapter(ProjectionAnnotationModel.class);
        return model;
    }

    protected boolean isInsideLast(PyProjectionAnnotation element, List elements, ProjectionAnnotationModel model) {
        if (elements.size() == 0) {
            return false;
        }
        PyProjectionAnnotation top = (PyProjectionAnnotation)((Object)elements.get(elements.size() - 1));
        Position p1 = model.getPosition((Annotation)element);
        Position pTop = model.getPosition((Annotation)top);
        int p1Offset = p1.getOffset();
        int pTopoffset = pTop.getOffset();
        int pTopLen = pTopoffset + pTop.getLength();
        return p1Offset > pTopoffset && p1Offset < pTopLen;
    }

    protected boolean isInside(Position position, List elements) {
        for (Position element : elements) {
            if (position.getOffset() <= element.getOffset() || position.getOffset() >= element.getOffset() + element.getLength()) continue;
            return true;
        }
        return false;
    }
}

