/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.PyLinkedModeCompletionProposal;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.DocIterator;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyStringCodeCompletion
extends AbstractTemplateCodeCompletion {
    public static String[] EPYDOC_FIELDS = new String[]{"param", "param ${param}: ${cursor}", "A description of the parameter for a function or method.", "type", "type ${param}: ${cursor}", "The expected type for the parameter, var or property", "return", "return: ", "The return value for a function or method.", "rtype", "rtype: ", "The type of the return value for a function or method.", "keyword", "keyword ${param}: ${cursor}", "A description of the keyword parameter.", "raise", "raise ${exception}: ${cursor}", "A description of the circumstances under which a function or method raises an exception", "ivar", "ivar ${ivar}: ${cursor}", "A description of a class instance variable", "cvar", "cvar ${cvar}: ${cursor}", "A description of a static class variable", "var", "var ${var}: ${cursor}", "A description of a module variable", "group", "group ${group}: ${cursor}", "Organizes a set of related children of a module or class into a group. g is the name of the group; and c1,...,cn are the names of the children in the group. To define multiple groups, use multiple group fields.", "sort", "sort: ", "Specifies the sort order for the children of a module or class. c1,...,cn are the names of the children, in the order in which they should appear. Any children that are not included in this list will appear after the children from this list, in alphabetical order.", "see", "see: ", "A description of a related topic. see fields typically use documentation crossreference links or external hyperlinks that link to the related topic.", "note", "note: ", "A note about an object. Multiple note fields may be used to list separate notes.", "attention", "attention: ", "An important note about an object. Multiple attention fields may be used to list separate notes.", "bug", "bug: ", "A description of a bug in an object. Multiple bug fields may be used to report separate bugs.", "warning", "warning: ", "A warning about an object. Multiple warning fields may be used to report separate warnings.", "version", "version: ", "The current version of an object.", "todo", "todo: ", "A planned change to an object. If the optional argument ver  is given, then it specifies the version for which the change will be made. Multiple todo fields may be used if multiple changes are planned.", "deprecated", "deprecated: ", "Indicates that an object is deprecated. The body of the field describe the reason why the object is deprecated.", "since", "since: ", "The date or version when an object was first introduced.", "status", "status: ", "The current status of an object.", "change", "change: ", "A change log entry for this object.", "requires", "requires: ", "A requirement for using an object. Multiple requires  fields may be used if an object has multiple requirements.", "precondition", "precondition: ", "A condition that must be true before an object is used. Multiple precondition fields may be used if an object has multiple preconditions.", "postcondition", "postcondition: ", "A condition that is guaranteed to be true after an object is used. Multiple postcondition fields may be used if an object has multiple postconditions.", "invariant", "invariant: ", "A condition which should always be true for an object. Multiple invariant fields may be used if an object has multiple invariants.", "author", "author: ", "The author(s) of an object. Multiple author  fields may be used if an object has multiple authors.", "organization", "organization: ", "The organization that created or maintains an object.", "copyright", "copyright: ", "The copyright information for an object.", "license", "license: ", "The licensing information for an object.", "contact", "contact: ", "Contact information for the author or maintainer of a module, class, function, or method. Multiple contact fields may be used if an object has multiple contacts.", "summary", "summary: ", "A summary description for an object. This description overrides the default summary (which is constructed from the first sentence of the object's description)."};

    public List getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException, MisconfigurationException {
        ArrayList<ICompletionProposal> ret = new ArrayList<ICompletionProposal>();
        request.showTemplates = false;
        this.fillWithEpydocFields(viewer, request, ret);
        if (ret.size() == 0) {
            ret.addAll(this.getStringGlobalsFromParticipants(request, CompletionStateFactory.getEmptyCompletionState(request.activationToken, request.nature, new CompletionCache())));
        }
        this.fillWithParams(viewer, request, ret);
        return ret;
    }

    private void fillWithParams(ITextViewer viewer, CompletionRequest request, ArrayList<ICompletionProposal> ret) {
        PySelection ps = new PySelection(request.doc, request.documentOffset);
        try {
            String lineContentsToCursor = ps.getLineContentsToCursor();
            String trimmed = lineContentsToCursor.trim();
            if (!(trimmed.startsWith("@param") || trimmed.startsWith("@type") || trimmed.startsWith(":param") || trimmed.startsWith(":type"))) {
                return;
            }
            if (request.activationToken.trim().length() != 0) {
                return;
            }
            String initial = request.qualifier;
            DocIterator iterator = new DocIterator(false, (TextSelectionUtils)ps);
            while (iterator.hasNext()) {
                int currentLine;
                PySelection selection;
                String line = iterator.next().trim();
                if (!line.startsWith("def ") || !(selection = new PySelection(request.doc, currentLine = iterator.getCurrentLine() + 1, 0)).isInFunctionLine(true)) continue;
                Tuple insideParentesisToks = selection.getInsideParentesisToks(false);
                for (String str : (List)insideParentesisToks.o1) {
                    if (!str.startsWith(initial)) continue;
                    ret.add((ICompletionProposal)new PyLinkedModeCompletionProposal(str, request.documentOffset - request.qlen, request.qlen, str.length(), PyCodeCompletionImages.getImageForType(5), null, null, "", 0, 1, ""));
                }
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void fillWithEpydocFields(ITextViewer viewer, CompletionRequest request, ArrayList<ICompletionProposal> ret) {
        try {
            String lineContentsToCursor;
            boolean createFields;
            Region region = new Region(request.documentOffset - request.qlen, request.qlen);
            Image image = PyCodeCompletionImages.getImageForType(8);
            TemplateContext context = this.createContext(viewer, (IRegion)region, request.doc);
            char c = request.doc.getChar(request.documentOffset - request.qualifier.length() - 1);
            boolean bl = createFields = c == '@' || c == ':';
            if (createFields && (lineContentsToCursor = PySelection.getLineContentsToCursor((IDocument)request.doc, (int)(request.documentOffset - request.qualifier.length() - 1))).trim().length() != 0) {
                createFields = false;
            }
            if (createFields) {
                int i = 0;
                while (i < EPYDOC_FIELDS.length) {
                    String f = EPYDOC_FIELDS[i];
                    if (f.startsWith(request.qualifier)) {
                        Template t = new Template(f, EPYDOC_FIELDS[i + 2], "", EPYDOC_FIELDS[i + 1], false);
                        ret.add((ICompletionProposal)new TemplateProposal(t, context, (IRegion)region, image, 5){

                            public String getDisplayString() {
                                if (SharedCorePlugin.inTestMode()) {
                                    return this.getPrefixCompletionText(null, 0).toString();
                                }
                                return super.getDisplayString();
                            }
                        });
                    }
                    i += 2;
                    ++i;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private Collection getStringGlobalsFromParticipants(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        ArrayList<Object> ret = new ArrayList<Object>();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
        for (IPyDevCompletionParticipant participant : participants) {
            ret.addAll(participant.getStringGlobalCompletions(request, state));
        }
        return ret;
    }
}

