/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.ModulesKeyForJava;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public abstract class ModulesManagerWithBuild
extends ModulesManager
implements IDeltaProcessor<ModulesKey> {
    public static boolean IN_TESTS = false;
    protected volatile DeltaSaver<ModulesKey> deltaSaver;
    protected static ICallback<ModulesKey, String> readFromFileMethod = new ICallback<ModulesKey, String>(){

        public ModulesKey call(String arg) {
            List split = StringUtils.split((String)arg, (char)'|');
            if (split.size() == 1) {
                return new ModulesKey((String)split.get(0), null);
            }
            if (split.size() == 2) {
                return new ModulesKey((String)split.get(0), new File((String)split.get(1)));
            }
            return null;
        }
    };
    protected static ICallback<String, ModulesKey> toFileMethod = new ICallback<String, ModulesKey>(){

        public String call(ModulesKey arg) {
            FastStringBuffer buf = new FastStringBuffer();
            buf.append(arg.name);
            if (arg.file != null) {
                buf.append("|");
                buf.append(arg.file.toString());
            }
            return buf.toString();
        }
    };
    private final Object lockNoDeltas = new Object();
    private int noDeltas = 0;

    public void processUpdate(ModulesKey data) {
        throw new RuntimeException("Not impl");
    }

    public void processDelete(ModulesKey key) {
        this.doRemoveSingleModule(key);
    }

    public void processInsert(ModulesKey key) {
        this.addModule(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoCloseable withNoGenerateDeltas() {
        Object object = this.lockNoDeltas;
        synchronized (object) {
            DeltaSaver<ModulesKey> tempDeltaSaver;
            ++this.noDeltas;
            if (this.noDeltas == 1) {
                tempDeltaSaver = this.deltaSaver;
                if (tempDeltaSaver != null) {
                    this.deltaSaver = null;
                }
            } else {
                tempDeltaSaver = null;
            }
            return new AutoCloseable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws Exception {
                    Object object = ModulesManagerWithBuild.this.lockNoDeltas;
                    synchronized (object) {
                        ModulesManagerWithBuild modulesManagerWithBuild = ModulesManagerWithBuild.this;
                        modulesManagerWithBuild.noDeltas = modulesManagerWithBuild.noDeltas - 1;
                        if (ModulesManagerWithBuild.this.noDeltas == 0 && tempDeltaSaver != null && ModulesManagerWithBuild.this.deltaSaver == null) {
                            DeltaSaver d = ModulesManagerWithBuild.this.deltaSaver = tempDeltaSaver;
                            ModulesManagerWithBuild.this.endProcessing();
                            d.clearAll();
                        }
                    }
                }
            };
        }
    }

    @Override
    public void doRemoveSingleModule(ModulesKey key) {
        super.doRemoveSingleModule(key);
        DeltaSaver<ModulesKey> d = this.deltaSaver;
        if (d != null && !IN_TESTS) {
            d.addDeleteCommand((Object)key);
            this.checkDeltaSize();
        }
    }

    @Override
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        super.doAddSingleModule(key, n);
        DeltaSaver<ModulesKey> d = this.deltaSaver;
        if (!(d == null || IN_TESTS || key instanceof ModulesKeyForZip || key instanceof ModulesKeyForJava)) {
            d.addInsertCommand((Object)key);
            this.checkDeltaSize();
        }
    }

    private void checkDeltaSize() {
        DeltaSaver<ModulesKey> d = this.deltaSaver;
        if (d != null && d.availableDeltas() > 100) {
            this.endProcessing();
            d.clearAll();
        }
    }

    public void removeModule(File file, IProject project, IProgressMonitor monitor) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this.removeModulesBelow(file, project, monitor);
        } else if (file.getName().startsWith("__init__.")) {
            this.removeModulesBelow(file.getParentFile(), project, monitor);
        } else {
            this.removeModulesWithFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModulesWithFile(File file) {
        if (file == null) {
            return;
        }
        ArrayList<ModulesKey> toRem = new ArrayList<ModulesKey>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (key.file == null || !key.file.equals(file)) continue;
                toRem.add(key);
            }
            this.removeThem(toRem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModulesBelow(File file, IProject project, IProgressMonitor monitor) {
        if (file == null) {
            return;
        }
        String absolutePath = FileUtils.getFileAbsolutePath((File)file);
        ArrayList<ModulesKey> toRem = new ArrayList<ModulesKey>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (key.file == null || !FileUtils.getFileAbsolutePath((File)key.file).startsWith(absolutePath)) continue;
                toRem.add(key);
            }
            this.removeThem(toRem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildModule(File f, ICallback0<IDocument> doc, IProject project, IProgressMonitor monitor, IPythonNature nature) {
        String m = this.pythonPathHelper.resolveModule(FileUtils.getFileAbsolutePath((File)f), false, project);
        if (m != null) {
            this.addModule(new ModulesKey(m, f));
        } else if (f != null) {
            Object object = this.modulesKeysLock;
            synchronized (object) {
                HashSet<ModulesKey> toRemove = new HashSet<ModulesKey>();
                for (ModulesKey key : this.modulesKeys.keySet()) {
                    if (key.file == null || !key.file.equals(f)) continue;
                    toRemove.add(key);
                }
                this.removeThem(toRemove);
            }
        }
    }
}

