/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.concurrency.Semaphore;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.editor.codecompletion.shell.ProcessCreationInfo;
import org.python.pydev.editor.codecompletion.shell.ShellConvert;
import org.python.pydev.editor.codecompletion.shell.ShellsContainer;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.net.SocketUtil;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.Timer;

public abstract class AbstractShell {
    public static final int BUFFER_SIZE = 20480;
    private static final int MAIN_THREAD_SHELL = 1;
    private static final int OTHER_THREADS_SHELL = 2;
    protected static final int DEFAULT_SLEEP_BETWEEN_ATTEMPTS = 1000;
    protected static final int DEBUG_SHELL = -1;
    private volatile boolean inStart = false;
    private volatile boolean isConnected = false;
    private volatile boolean isInRead = false;
    private volatile boolean isInWrite = false;
    private volatile boolean isInRestart = false;
    private IInterpreterInfo shellInterpreter;
    private final Semaphore semaphore = new Semaphore(1L);
    private final Object ioLock = new Object();
    static final String ENCODING_UTF_8 = "UTF-8";
    static volatile boolean finishedForGood = false;
    protected ProcessCreationInfo process;
    private Socket socket;
    protected File serverFile;
    private ServerSocket serverSocket;
    private ServerSocketChannel serverSocketChannel;
    private final Object waitLock = new Object();
    private final Object lockLastPythonPath = new Object();
    private String lastPythonPath = null;

    public static int[] getAllShellIds() {
        return new int[]{1, 2};
    }

    public static final int getShellId() {
        return Display.getCurrent() != null ? 1 : 2;
    }

    private static void dbg(String string, int priority) {
        if (priority <= -1) {
            System.out.println(string);
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((String)string, AbstractShell.class);
        }
    }

    protected AbstractShell(File f) throws IOException, CoreException {
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to create a new shell.");
        }
        this.serverFile = f;
        if (!this.serverFile.exists()) {
            throw new RuntimeException("Can't find python server file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepALittle(int t) {
        try {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.wait(t);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void stopServerShell(IInterpreterInfo interpreter, int id) {
        ShellsContainer.stopServerShell(interpreter, id);
    }

    public static void shutdownAllShells() {
        ShellsContainer.shutdownAllShells();
    }

    public static String restartAllShells() {
        return ShellsContainer.restartAllShells();
    }

    public static void putServerShell(IPythonNature nature, int id, AbstractShell shell) {
        ShellsContainer.putServerShell(nature, id, shell);
    }

    public static AbstractShell getServerShell(IPythonNature nature, int id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return ShellsContainer.getServerShell(nature, id);
    }

    void startIt(IPythonNature nature) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        this.startIt(nature.getProjectInterpreter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void startIt(IInterpreterInfo interpreter) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException {
        milisSleep = 1000;
        var3_3 = this.ioLock;
        synchronized (var3_3) {
            block27: {
                this.shellInterpreter = interpreter;
                if (this.inStart || this.isConnected) {
                    return;
                }
                this.inStart = true;
                try {
                    if (AbstractShell.finishedForGood) {
                        throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to restart it.");
                    }
                    try {
                        this.serverSocketChannel = ServerSocketChannel.open();
                        this.serverSocketChannel.configureBlocking(false);
                        this.serverSocketChannel.bind(new InetSocketAddress(0));
                        this.serverSocket = this.serverSocketChannel.socket();
                        port = this.serverSocket.getLocalPort();
                        SocketUtil.checkValidPort((int)port);
                        if (this.process != null) {
                            this.endIt();
                        }
                        this.process = this.createServerProcess(interpreter, port);
                        AbstractShell.dbg("executed: " + this.process.getProcessLog(), 1);
                        this.sleepALittle(200);
                        try {
                            exitVal = this.process.exitValue();
                            msg = "Error creating python process - exited before creating sockets - exitValue = (" + exitVal + ").\n" + this.process.getProcessLog();
                            AbstractShell.dbg(msg, 1);
                            Log.log((String)msg);
                            throw new CoreException((IStatus)PydevPlugin.makeStatus(4, msg, new Exception(msg)));
                        }
                        catch (IllegalThreadStateException v0) {
                            AbstractShell.dbg("afterCreateProcess ", 1);
                            connected = false;
                            attempt = 0;
                            AbstractShell.dbg("connecting... ", 1);
                            this.sleepALittle(milisSleep);
                            maxAttempts = PyCodeCompletionPreferencesPage.getNumberOfConnectionAttempts();
                            AbstractShell.dbg("maxAttempts: " + maxAttempts, 1);
                            AbstractShell.dbg("finishedForGood: " + AbstractShell.finishedForGood, 1);
                            ** while (!connected && attempt < maxAttempts && !AbstractShell.finishedForGood)
                        }
lbl-1000:
                        // 1 sources

                        {
                            block26: {
                                AbstractShell.dbg("connecting attept..." + ++attempt, 1);
                                try {
                                    try {
                                        AbstractShell.dbg("serverSocket.accept()! ", 1);
                                        initial = System.currentTimeMillis();
                                        accept = null;
                                        while (accept == null && System.currentTimeMillis() - initial < 5000L) {
                                            AbstractShell.dbg("serverSocketChannel.accept(): waiting for python client to connect back to the eclipse java vm", 1);
                                            accept = this.serverSocketChannel.accept();
                                            if (accept != null) continue;
                                            this.sleepALittle(500);
                                        }
                                        if (accept != null) {
                                            this.socket = accept.socket();
                                            AbstractShell.dbg("socketToRead.setSoTimeout(8000) ", 1);
                                            this.socket.setSoTimeout(8000);
                                            connected = true;
                                            AbstractShell.dbg("connected! ", 1);
                                            break block26;
                                        }
                                        msg = "The python client still hasn't connected back to the eclipse java vm (will retry...)";
                                        AbstractShell.dbg(msg, 1);
                                        Log.log((String)msg);
                                    }
                                    catch (SocketTimeoutException v1) {
                                        AbstractShell.dbg("SocketTimeoutException! ", 1);
                                    }
                                }
                                catch (IOException v2) {
                                    AbstractShell.dbg("IOException! ", 1);
                                }
                            }
                            if (connected || attempt <= 1) continue;
                            msg = "Attempt: " + attempt + " of " + maxAttempts + " failed, trying again...(socket connected: " + (this.socket == null ? "still null" : Boolean.valueOf(this.socket.isConnected())) + ")";
                            AbstractShell.dbg(msg, 1);
                            Log.log((String)msg);
                            this.sleepALittle(milisSleep);
                            continue;
                        }
lbl80:
                        // 1 sources

                        if (connected || AbstractShell.finishedForGood) break block27;
                        AbstractShell.dbg("NOT connected ", 1);
                        try {
                            exitVal = this.process.exitValue();
                            isAlive = " - the process in NOT ALIVE anymore (output=" + exitVal + ") - ";
                        }
                        catch (IllegalThreadStateException v3) {
                            isAlive = " - the process in still alive (killing it now)- ";
                            this.process.destroy();
                        }
                        this.closeConn();
                        msg = "Error connecting to python process (most likely cause for failure is a firewall blocking communication or a misconfigured network).\n" + isAlive + "\n" + this.process.getProcessLog();
                        exception = new RuntimeException(msg);
                        AbstractShell.dbg(msg, 1);
                        Log.log((Throwable)exception);
                        throw exception;
                    }
                    catch (IOException e) {
                        if (this.process != null) {
                            this.process.destroy();
                            this.process = null;
                        }
                        throw e;
                    }
                }
                finally {
                    this.inStart = false;
                }
            }
            this.isConnected = true;
        }
        var3_3 = this.lockLastPythonPath;
        synchronized (var3_3) {
            this.lastPythonPath = null;
        }
    }

    protected abstract ProcessCreationInfo createServerProcess(IInterpreterInfo var1, int var2) throws IOException, JDTNotAvailableException, MisconfigurationException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FastStringBuffer read(IProgressMonitor monitor) throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            if (finishedForGood) {
                throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to read from it.");
            }
            if (this.inStart) {
                throw new RuntimeException("The shell is still not completely started, so, it is an invalid state to try to read from it.");
            }
            if (!this.isConnected) {
                throw new RuntimeException("The shell is still not connected, so, it is an invalid state to try to read from it.");
            }
            if (this.isInRead) {
                throw new RuntimeException("The shell is already in read mode, so, it is an invalid state to try to read from it.");
            }
            if (this.isInWrite) {
                throw new RuntimeException("The shell is already in write mode, so, it is an invalid state to try to read from it.");
            }
            this.isInRead = true;
            try {
                block19: {
                    FastStringBuffer fastStringBuffer;
                    int len;
                    FastStringBuffer strBuf = new FastStringBuffer(20480);
                    byte[] b = new byte[20480];
                    int searchFrom = 0;
                    while ((len = this.socket.getInputStream().read(b)) != 0) {
                        String s = new String(b, 0, len);
                        searchFrom = strBuf.length() - 5;
                        if (searchFrom < 0) {
                            searchFrom = 0;
                        }
                        strBuf.append(s);
                        if (strBuf.indexOf("END@@", searchFrom) != -1) break;
                        this.sleepALittle(10);
                    }
                    strBuf.replaceFirst("@@COMPLETIONS", "");
                    if ((searchFrom -= "@@COMPLETIONS".length()) < 0) {
                        searchFrom = 0;
                    }
                    try {
                        int endIndex = strBuf.indexOf("END@@", searchFrom);
                        if (endIndex == -1) break block19;
                        strBuf.setCount(endIndex);
                        fastStringBuffer = strBuf;
                    }
                    catch (RuntimeException e) {
                        if (strBuf.length() > 500) {
                            strBuf.setCount(499).append("...(continued)...");
                        }
                        Log.log((int)4, (String)("ERROR WITH STRING:" + strBuf), (Throwable)e);
                        FastStringBuffer fastStringBuffer2 = new FastStringBuffer();
                        return fastStringBuffer2;
                    }
                    return fastStringBuffer;
                }
                throw new RuntimeException("Couldn't find END@@ on received string.");
            }
            finally {
                this.isInRead = false;
            }
        }
    }

    private FastStringBuffer read() throws IOException {
        FastStringBuffer r = this.read(null);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String str) throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            if (finishedForGood) {
                throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to write to it.");
            }
            if (this.inStart) {
                throw new RuntimeException("The shell is still not completely started, so, it is an invalid state to try to write to it.");
            }
            if (!this.isConnected) {
                throw new RuntimeException("The shell is still not connected, so, it is an invalid state to try to write to it.");
            }
            if (this.isInRead) {
                throw new RuntimeException("The shell is already in read mode, so, it is an invalid state to try to write to it.");
            }
            if (this.isInWrite) {
                throw new RuntimeException("The shell is already in write mode, so, it is an invalid state to try to write to it.");
            }
            this.isInWrite = true;
            try {
                OutputStream outputStream = this.socket.getOutputStream();
                outputStream.write(str.getBytes());
                outputStream.flush();
            }
            finally {
                this.isInWrite = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConn() throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {}
            this.socket = null;
            try {
                if (this.serverSocketChannel != null) {
                    this.serverSocketChannel.close();
                }
            }
            catch (Exception exception) {}
            this.serverSocketChannel = null;
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception exception) {}
            this.serverSocket = null;
        }
        object = this.lockLastPythonPath;
        synchronized (object) {
            this.lastPythonPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.ioLock;
        synchronized (object) {
            this.socket = null;
            this.serverSocket = null;
            this.serverSocketChannel = null;
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
        object = this.lockLastPythonPath;
        synchronized (object) {
            this.lastPythonPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endIt() {
        Object object = this.ioLock;
        synchronized (object) {
            try {
                this.closeConn();
            }
            catch (Exception exception) {}
            this.isConnected = false;
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
        object = this.lockLastPythonPath;
        synchronized (object) {
            this.lastPythonPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartShell() throws CoreException {
        Object object = this.ioLock;
        synchronized (object) {
            if (!this.isInRestart) {
                this.isInRestart = true;
                try {
                    if (finishedForGood) {
                        throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to restart a new shell.");
                    }
                    try {
                        this.endIt();
                    }
                    catch (Exception exception) {}
                    try {
                        this.startIt(this.shellInterpreter);
                    }
                    catch (Exception e) {
                        Log.log((int)4, (String)"ERROR restarting shell.", (Throwable)e);
                    }
                }
                finally {
                    this.isInRestart = false;
                }
            }
        }
    }

    private AutoCloseable acquire(String msg) {
        final Timer timer = new Timer();
        this.semaphore.acquire();
        final String s = msg;
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                AbstractShell.this.semaphore.release();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FastStringBuffer writeAndGetResults(String ... str) throws CoreException {
        try {
            Object object = this.ioLock;
            synchronized (object) {
                try {
                    FastStringBuffer read;
                    this.write(StringUtils.join((String)"", (String[])str));
                    FastStringBuffer fastStringBuffer = read = this.read();
                    return fastStringBuffer;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        String message = "ERROR reading shell.";
                        if (this.process != null) {
                            message = String.valueOf(message) + "\n" + this.process.getProcessLog();
                        }
                        Log.log((int)4, (String)message, (Throwable)e);
                        this.restartShell();
                        return null;
                    }
                }
            }
        }
        finally {
            if (this.process != null) {
                this.process.clearOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalChangePythonPath(List<String> pythonpath) throws Exception {
        String pythonpathStr;
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to change its dir.");
        }
        Object object = this.lockLastPythonPath;
        synchronized (object) {
            pythonpathStr = StringUtils.join((String)"|", (String[])pythonpath.toArray(new String[pythonpath.size()]));
            if (this.lastPythonPath != null && this.lastPythonPath.equals(pythonpathStr)) {
                return;
            }
            this.lastPythonPath = pythonpathStr;
        }
        try {
            this.writeAndGetResults("@@CHANGE_PYTHONPATH:", URLEncoder.encode(pythonpathStr, ENCODING_UTF_8), "\nEND@@");
        }
        catch (Exception e) {
            Log.log((String)("Error changing the pythonpath to: " + StringUtils.join((String)"\n", pythonpath)), (Throwable)e);
            throw e;
        }
    }

    public Tuple<String, List<String[]>> getImportCompletions(String str, List<String> pythonpath) throws Exception {
        FastStringBuffer read = null;
        str = URLEncoder.encode(str, ENCODING_UTF_8);
        Throwable throwable = null;
        Object var5_6 = null;
        try (AutoCloseable permit = this.acquire(StringUtils.join((String)"", (Object[])new Object[]{"getImportCompletions: ", str}));){
            this.internalChangePythonPath(pythonpath);
            read = this.writeAndGetResults("@@IMPORTS:", str, "\nEND@@");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ShellConvert.convertStringToCompletions(read);
    }

    public Tuple<String[], int[]> getLineCol(String moduleName, String token, List<String> pythonpath) throws Exception {
        FastStringBuffer read = null;
        String str = String.valueOf(moduleName) + "." + token;
        str = URLEncoder.encode(str, ENCODING_UTF_8);
        Throwable throwable = null;
        Object var7_8 = null;
        try (AutoCloseable permit = this.acquire("getLineCol");){
            this.internalChangePythonPath(pythonpath);
            read = this.writeAndGetResults("@@SEARCH", str, "\nEND@@");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Tuple<String, List<String[]>> theCompletions = ShellConvert.convertStringToCompletions(read);
        List def = (List)theCompletions.o2;
        if (def.size() == 0) {
            return null;
        }
        String[] comps = (String[])def.get(0);
        if (comps.length == 0) {
            return null;
        }
        int line = Integer.parseInt(comps[0]);
        int col = Integer.parseInt(comps[1]);
        String foundAs = comps[2];
        return new Tuple((Object)new String[]{(String)theCompletions.o1, foundAs}, (Object)new int[]{line, col});
    }

    public List<CompiledToken> getJediCompletions(File editorFile, PySelection ps, String charset, List<String> pythonpath) throws Exception {
        FastStringBuffer read = null;
        String str = StringUtils.join((String)"|", (String[])new String[]{String.valueOf(ps.getCursorLine()), String.valueOf(ps.getCursorColumn()), charset, FileUtils.getFileAbsolutePath((File)editorFile), StringUtils.replaceNewLines((String)ps.getDoc().get(), (String)"\n")});
        str = URLEncoder.encode(str, ENCODING_UTF_8);
        Throwable throwable = null;
        Object var8_9 = null;
        try (AutoCloseable permit = this.acquire("getJediCompletions");){
            this.internalChangePythonPath(pythonpath);
            read = this.writeAndGetResults("@@MSG_JEDI:", str, "\nEND@@");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Tuple<String, List<String[]>> theCompletions = ShellConvert.convertStringToCompletions(read);
        ArrayList<CompiledToken> lst = new ArrayList<CompiledToken>(((List)theCompletions.o2).size());
        for (String[] s : (List)theCompletions.o2) {
            lst.add(new CompiledToken(s[0], s[1], "", "", Integer.parseInt(s[3])));
        }
        return lst;
    }
}

