/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

class ShellConvert {
    private static final String TYPE_UNKNOWN_STR = String.valueOf(-1);
    private static final String ENCODING_UTF_8 = "UTF-8";

    ShellConvert() {
    }

    private static Tuple<String, List<String[]>> getInvalidCompletion() {
        ArrayList l = new ArrayList();
        return new Tuple(null, l);
    }

    static Tuple<String, List<String[]>> convertStringToCompletions(FastStringBuffer read) throws IOException {
        if (read == null) {
            return ShellConvert.getInvalidCompletion();
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        FastStringBuffer string = read.replaceAll("(", "").replaceAll(")", "");
        StringTokenizer tokenizer = new StringTokenizer(string.toString(), ",");
        string = null;
        ObjectsPool.ObjectsPoolMap map = new ObjectsPool.ObjectsPoolMap();
        String file = "";
        if (tokenizer.hasMoreTokens()) {
            file = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
            while (tokenizer.hasMoreTokens()) {
                String token = ObjectsPool.internLocal((ObjectsPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                if (!tokenizer.hasMoreTokens()) {
                    return new Tuple((Object)file, list);
                }
                String description = ObjectsPool.internLocal((ObjectsPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                String args = "";
                if (tokenizer.hasMoreTokens()) {
                    args = ObjectsPool.internLocal((ObjectsPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                }
                String type = TYPE_UNKNOWN_STR;
                if (tokenizer.hasMoreTokens()) {
                    type = ObjectsPool.internLocal((ObjectsPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                }
                if (!token.equals("ERROR:")) {
                    list.add(new String[]{token, description, args, type});
                    continue;
                }
                if (!DebugSettings.DEBUG_CODE_COMPLETION) continue;
                Log.addLogLevel();
                try {
                    Log.toLogFile((String)"Code completion shell error:", AbstractShell.class);
                    Log.toLogFile((String)token, AbstractShell.class);
                    Log.toLogFile((String)description, AbstractShell.class);
                    Log.toLogFile((String)args, AbstractShell.class);
                    Log.toLogFile((String)type, AbstractShell.class);
                }
                finally {
                    Log.remLogLevel();
                }
            }
        }
        return new Tuple((Object)file, list);
    }
}

