/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editor.codecompletion.shell.IronpythonShell;
import org.python.pydev.editor.codecompletion.shell.JythonShell;
import org.python.pydev.editor.codecompletion.shell.PythonShell;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.plugin.PydevPlugin;

public class ShellsContainer {
    private static Map<String, Map<Integer, AbstractShell>> shells = new HashMap<String, Map<Integer, AbstractShell>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServerShell(IInterpreterInfo interpreter, int id) {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            Map<Integer, AbstractShell> typeToShell = ShellsContainer.getTypeToShellFromId(interpreter);
            AbstractShell pythonShell = typeToShell.get(new Integer(id));
            if (pythonShell != null) {
                try {
                    pythonShell.endIt();
                }
                catch (Exception exception) {}
            }
            typeToShell.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAllShells() {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((String)"Shutting down all shells (for good)...", AbstractShell.class);
            }
            Iterator<Map<Integer, AbstractShell>> iter = shells.values().iterator();
            while (iter.hasNext()) {
                AbstractShell.finishedForGood = true;
                Map<Integer, AbstractShell> rel = iter.next();
                if (rel == null) continue;
                for (AbstractShell element : rel.values()) {
                    if (element == null) continue;
                    try {
                        element.shutdown();
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            shells.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String restartAllShells() {
        String ret = "";
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            try {
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.toLogFile((String)"Restarting all shells and clearing caches...", AbstractShell.class);
                }
                for (Map<Integer, AbstractShell> val : shells.values()) {
                    IInterpreterManager[] interpreterManagers;
                    for (AbstractShell val2 : val.values()) {
                        if (val2 == null) continue;
                        val2.endIt();
                    }
                    IInterpreterManager[] iInterpreterManagerArray = interpreterManagers = PydevPlugin.getAllInterpreterManagers();
                    int n = interpreterManagers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInterpreterManager iInterpreterManager = iInterpreterManagerArray[n2];
                        if (iInterpreterManager != null) {
                            try {
                                iInterpreterManager.clearCaches();
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                                ret = String.valueOf(ret) + e.getMessage() + "\n";
                            }
                        }
                        ++n2;
                    }
                    ModulesManager.clearCache();
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                ret = String.valueOf(ret) + e.getMessage() + "\n";
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, AbstractShell> getTypeToShellFromId(IInterpreterInfo interpreter) {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            Map<Integer, AbstractShell> typeToShell = shells.get(interpreter.getExecutableOrJar());
            if (typeToShell == null) {
                typeToShell = new HashMap<Integer, AbstractShell>();
                shells.put(interpreter.getExecutableOrJar(), typeToShell);
            }
            return typeToShell;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putServerShell(IPythonNature nature, int id, AbstractShell shell) {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            try {
                Map<Integer, AbstractShell> typeToShell = ShellsContainer.getTypeToShellFromId(nature.getProjectInterpreter());
                typeToShell.put(new Integer(id), shell);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static AbstractShell getServerShell(IPythonNature nature, int id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return ShellsContainer.getServerShell(nature.getProjectInterpreter(), nature.getInterpreterType(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractShell getServerShell(IInterpreterInfo interpreter, int relatedTo, int id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException {
        AbstractShell pythonShell = null;
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            Map<Integer, AbstractShell> typeToShell;
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((String)"Synchronizing on shells...", AbstractShell.class);
            }
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                String flavor;
                switch (relatedTo) {
                    case 1: {
                        flavor = "Jython";
                        break;
                    }
                    case 2: {
                        flavor = "IronPython";
                        break;
                    }
                    default: {
                        flavor = "Python";
                    }
                }
                Log.toLogFile((String)("Getting shell related to:" + flavor + " id:" + id + " interpreter: " + interpreter.getExecutableOrJar()), AbstractShell.class);
            }
            if ((pythonShell = (typeToShell = ShellsContainer.getTypeToShellFromId(interpreter)).get(new Integer(id))) == null) {
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.toLogFile((String)"pythonShell == null", AbstractShell.class);
                }
                if (relatedTo == 0) {
                    pythonShell = new PythonShell();
                } else if (relatedTo == 1) {
                    pythonShell = new JythonShell();
                } else if (relatedTo == 2) {
                    pythonShell = new IronpythonShell();
                } else {
                    throw new RuntimeException("unknown related id");
                }
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.toLogFile((String)"pythonShell.startIt()", AbstractShell.class);
                    Log.addLogLevel();
                }
                pythonShell.startIt(interpreter);
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.remLogLevel();
                    Log.toLogFile((String)"Finished pythonShell.startIt()", AbstractShell.class);
                }
                typeToShell.put(new Integer(id), pythonShell);
            }
        }
        return pythonShell;
    }
}

