/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.commentblocks;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.FontUtils;

public class CommentBlocksPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor multiBlock;
    private StringFieldEditor singleBlock;
    private BooleanFieldEditor alignSingle;
    private Label labelMulti;
    private Label labelSingle;
    public static final String MULTI_BLOCK_COMMENT_CHAR = "MULTI_BLOCK_COMMENT_CHAR";
    public static final String DEFAULT_MULTI_BLOCK_COMMENT_CHAR = "=";
    public static final String MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME = "MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME";
    public static final boolean DEFAULT_MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME = true;
    public static final String MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME = "MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME";
    public static final boolean DEFAULT_MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME = true;
    public static final String SINGLE_BLOCK_COMMENT_CHAR = "SINGLE_BLOCK_COMMENT_CHAR";
    public static final String DEFAULT_SINGLE_BLOCK_COMMENT_CHAR = "-";
    public static final String SINGLE_BLOCK_COMMENT_ALIGN_RIGHT = "SINGLE_BLOCK_COMMENT_ALIGN_RIGHT";
    public static final boolean DEFAULT_SINGLE_BLOCK_COMMENT_ALIGN_RIGHT = true;

    public CommentBlocksPreferences() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Comment Block Preferences");
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.multiBlock = new StringFieldEditor(MULTI_BLOCK_COMMENT_CHAR, "Multi-block char (ctrl+4):", 2, p);
        this.multiBlock.getTextControl(p).setTextLimit(1);
        this.multiBlock.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.multiBlock);
        this.addField((FieldEditor)new BooleanFieldEditor(MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME, "In a class name, create block only with class name above of class?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME, "In a function name, create block only with function name above of function?", p));
        this.labelMulti = new Label(p, 0);
        this.singleBlock = new StringFieldEditor(SINGLE_BLOCK_COMMENT_CHAR, "Single-block char (ctrl+shift+4):", 2, p);
        this.singleBlock.setEmptyStringAllowed(false);
        this.singleBlock.getTextControl(p).setTextLimit(1);
        this.addField((FieldEditor)this.singleBlock);
        this.alignSingle = new BooleanFieldEditor(SINGLE_BLOCK_COMMENT_ALIGN_RIGHT, "Align text in single-block to the right?", p);
        this.addField((FieldEditor)this.alignSingle);
        this.labelSingle = new Label(p, 0);
        IPreferenceStore store = this.getPreferenceStore();
        this.setLabelFont(p, this.labelSingle);
        this.setLabelFont(p, this.labelMulti);
        this.updateMulti(store.getString(MULTI_BLOCK_COMMENT_CHAR));
        this.updateSingle(store.getString(SINGLE_BLOCK_COMMENT_CHAR), store.getBoolean(SINGLE_BLOCK_COMMENT_ALIGN_RIGHT));
    }

    private void setLabelFont(Composite composite, Label label) {
        try {
            FontData labelFontData = FontUtils.getFontData((int)2, (boolean)true);
            labelFontData.setStyle(1);
            label.setFont(new Font((Device)composite.getDisplay(), labelFontData));
        }
        catch (Throwable throwable) {}
    }

    private void updateSingle(String val, boolean alignToRight) {
        FastStringBuffer buf = new FastStringBuffer(200);
        if (val.length() == 0) {
            buf.append("Invalid");
            buf.appendN(' ', 23);
        } else {
            buf.appendN(val.charAt(0), 10);
            if (alignToRight) {
                buf.append(" my single block");
            } else {
                buf.insert(0, " my single block ");
            }
            buf.insert(0, '#');
        }
        this.labelSingle.setText("Result:\n" + buf.toString());
    }

    private void updateMulti(String val) {
        FastStringBuffer buf = new FastStringBuffer(200);
        if (val.length() == 0) {
            buf.append("Invalid");
            buf.appendN(' ', 23);
            buf.append('\n');
            buf.appendN(' ', 30);
            buf.append('\n');
            buf.appendN(' ', 30);
        } else {
            buf.append("#");
            buf.appendN(val.charAt(0), 26);
            buf.append("\n# my multi block");
            buf.append("\n#");
            buf.appendN(val.charAt(0), 26);
        }
        this.labelMulti.setText("Result:\n" + buf.toString() + "\n\n\n");
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.multiBlock.equals(event.getSource())) {
            this.updateMulti(this.multiBlock.getStringValue());
        } else if (this.singleBlock.equals(event.getSource()) || this.alignSingle.equals(event.getSource())) {
            this.updateSingle(this.singleBlock.getStringValue(), this.alignSingle.getBooleanValue());
        }
    }
}

