/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.codingstd.ICodingStd;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.correctionassist.heuristics.AssistAssignCompletionProposal;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;
import org.python.pydev.plugin.preferences.PyCodeStylePreferencesPage;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.ImageCache;

public class AssistAssign
implements IAssistProps {
    private ICodingStd std;

    public AssistAssign() {
        this(new ICodingStd(){

            @Override
            public boolean localsAndAttrsCamelcase() {
                return PyCodeStylePreferencesPage.useLocalsAndAttrsCamelCase();
            }
        });
    }

    public AssistAssign(ICodingStd std) {
        this.std = std;
    }

    private Image getImage(ImageCache imageCache, String c) {
        if (imageCache != null) {
            return imageCache.get(c);
        }
        return null;
    }

    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        PySourceViewer viewer = null;
        if (edit != null) {
            viewer = edit.getPySourceViewer();
        }
        return this.getProps(ps, imageCache, (ISourceViewer)viewer, offset, PyAction.getLineWithoutComments(ps), PySelection.getFirstCharPosition((IDocument)ps.getDoc(), (int)ps.getAbsoluteCursorOffset()));
    }

    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, ISourceViewer sourceViewer, int offset, String lineWithoutComments, int firstCharAbsolutePosition) throws BadLocationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        if (lineWithoutComments.trim().length() == 0) {
            return l;
        }
        String callName = this.getTokToAssign(ps);
        if (callName.length() > 0) {
            if (callName.toLowerCase().startsWith("get") && callName.length() > 3) {
                callName = callName.substring(3);
            }
            callName = this.changeToCodingStd(callName);
            int i = 0;
            while (i < callName.length()) {
                char c = callName.charAt(i);
                if (c != '_') {
                    callName = PyAction.lowerChar(callName, i);
                    break;
                }
                ++i;
            }
        } else {
            callName = "result";
        }
        String loc = callName;
        if (loc.startsWith("_")) {
            loc = loc.substring(1);
        }
        l.add((ICompletionProposal)new AssistAssignCompletionProposal(String.valueOf(loc) + " = ", firstCharAbsolutePosition, 0, 0, this.getImage(imageCache, "icons/new/attrpub_obj.gif"), "Assign to local (" + loc + ")", null, null, 10, sourceViewer));
        l.add((ICompletionProposal)new AssistAssignCompletionProposal("self." + callName + " = ", firstCharAbsolutePosition, 0, 5, this.getImage(imageCache, "icons/new/attrpub_obj.gif"), "Assign to field (self." + callName + ")", null, null, 10, sourceViewer));
        return l;
    }

    private String changeToCodingStd(String callName) {
        if (this.std.localsAndAttrsCamelcase()) {
            return StringUtils.asStyleCamelCaseFirstLower((String)callName);
        }
        return StringUtils.asStyleLowercaseUnderscores((String)callName);
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return this.isValid(ps.getTextSelection().getLength(), sel, offset);
    }

    public boolean isValid(int selectionLength, String lineContents, int offset) {
        if (selectionLength != 0) {
            return false;
        }
        if (lineContents.indexOf("class ") != -1 || lineContents.indexOf("def ") != -1 || lineContents.indexOf("import ") != -1) {
            return false;
        }
        String eqReplaced = lineContents.replaceAll("==", "");
        if (eqReplaced.indexOf("=") != -1) {
            if (eqReplaced.indexOf(40) == -1) {
                return false;
            }
            int i = eqReplaced.indexOf(40);
            if (eqReplaced.substring(0, i).indexOf(61) != -1) {
                return false;
            }
        }
        return true;
    }

    private static String getStringToAnalyze(PySelection ps) {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)ps.getDoc());
        FastStringBuffer buf = new FastStringBuffer();
        String string = null;
        try {
            parsingUtils.getFullFlattenedLine(ps.getStartLineOffset(), buf);
            if (buf.length() > 0) {
                string = buf.toString();
            }
        }
        catch (SyntaxErrorException e) {
            Log.log((Throwable)e);
        }
        if (string == null) {
            string = PyAction.getLineWithoutComments(ps);
        }
        return string.trim();
    }

    private static String getBeforeParentesisTok(String string) {
        String callName = "";
        int i = string.lastIndexOf("(");
        if (i != -1) {
            callName = "";
            int j = i - 1;
            while (j >= 0 && PyAction.stillInTok(string, j)) {
                callName = String.valueOf(string.charAt(j)) + callName;
                --j;
            }
        }
        return callName;
    }

    private String getTokToAssign(PySelection ps) {
        String string = AssistAssign.getStringToAnalyze(ps);
        String tokToAssign = this.getTokToAssign(string);
        if (tokToAssign == null || tokToAssign.length() == 0) {
            return "result";
        }
        return tokToAssign;
    }

    private String changeToLowerUppercaseConstant(String callName) {
        if (StringUtils.isAllUpper((String)callName)) {
            return callName.toLowerCase();
        }
        return callName;
    }

    public String getTokToAssign(String string) {
        int i;
        string = string.trim();
        String callName = "";
        String beforeParentesisTok = AssistAssign.getBeforeParentesisTok(string);
        if (beforeParentesisTok.length() > 0) {
            callName = beforeParentesisTok;
        } else {
            i = string.lastIndexOf(".");
            if (i != -1) {
                callName = "";
                int j = i + 1;
                while (j < string.length() && PyAction.stillInTok(string, j)) {
                    callName = String.valueOf(callName) + string.charAt(j);
                    ++j;
                }
            }
            if (callName.length() == 0 && PyStringUtils.isPythonIdentifier((String)string)) {
                callName = string;
            }
        }
        callName = this.changeToLowerUppercaseConstant(callName);
        if (callName.length() > 0) {
            if (callName.toLowerCase().startsWith("get") && callName.length() > 3) {
                callName = callName.substring(3);
            } else if (callName.toLowerCase().startsWith("_get") && callName.length() > 4) {
                callName = callName.substring(4);
            }
            callName = this.changeToCodingStd(callName);
            i = 0;
            while (i < callName.length()) {
                char c = callName.charAt(i);
                if (c != '_') {
                    callName = PyAction.lowerChar(callName, i);
                    break;
                }
                ++i;
            }
        } else {
            callName = null;
        }
        return callName;
    }
}

