/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.correctionassist.FixCompletionProposal;
import org.python.pydev.editor.correctionassist.IgnoreCompletionProposalInSameLine;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;
import org.python.pydev.shared_ui.ImageCache;

public class AssistImport
implements IAssistProps {
    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        String messageToIgnore;
        String cursorLineContents;
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        String sel = PyAction.getLineWithoutComments(ps).trim();
        int i = sel.indexOf("import");
        if (ps.getStartLineIndex() != ps.getEndLineIndex()) {
            return l;
        }
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        boolean isFuture = PySelection.isFutureImportLine((String)sel);
        int lineToMoveImport = ps.getLineAvailableForImport(isFuture);
        try {
            int lineToMoveOffset = ps.getDoc().getLineOffset(lineToMoveImport);
            if (i >= 0) {
                l.add(new FixCompletionProposal(String.valueOf(sel) + delimiter, lineToMoveOffset, 0, ps.getStartLine().getOffset(), imageCache.get("icons/correction_move.gif"), "Move import to global scope", null, null, ps.getStartLineIndex() + 1));
            }
        }
        catch (BadLocationException badLocationException) {}
        if (i >= 0 && !(cursorLineContents = ps.getCursorLineContents()).contains(messageToIgnore = "@NoMove")) {
            IgnoreCompletionProposalInSameLine proposal = new IgnoreCompletionProposalInSameLine(messageToIgnore, ps.getEndLineOffset(), 0, offset, imageCache.get("icons/annotation_obj.gif"), messageToIgnore.substring(1), null, null, 10, edit, cursorLineContents, ps, null);
            l.add((ICompletionProposal)proposal);
        }
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return sel.indexOf("import ") != -1;
    }
}

