/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.docutils.StringEscapeUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyInformationPresenter;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.hover.IPyHoverParticipant;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;

public class PyTextHover
implements ITextHover,
ITextHoverExtension {
    private final boolean pythonCommentOrMultiline;
    private final FastStringBuffer buf = new FastStringBuffer();
    private ITextSelection textSelection;

    public PyTextHover(ISourceViewer sourceViewer, String contentType) {
        boolean pythonCommentOrMultiline = false;
        String[] stringArray = IPythonPartitions.types;
        int n = IPythonPartitions.types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(contentType)) {
                pythonCommentOrMultiline = true;
                break;
            }
            ++n2;
        }
        this.pythonCommentOrMultiline = pythonCommentOrMultiline;
    }

    public synchronized String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.buf.clear();
        if (!this.pythonCommentOrMultiline && textViewer instanceof PySourceViewer) {
            PySourceViewer s = (PySourceViewer)textViewer;
            PySelection ps = new PySelection(s.getDocument(), hoverRegion.getOffset() + hoverRegion.getLength());
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_hover");
            for (IPyHoverParticipant pyHoverParticipant : participants) {
                try {
                    String hoverText = pyHoverParticipant.getHoverText(hoverRegion, s, ps, this.textSelection);
                    if (hoverText == null || hoverText.trim().length() <= 0) continue;
                    if (this.buf.length() > 0) {
                        this.buf.append(PyInformationPresenter.LINE_DELIM);
                    }
                    this.buf.append(hoverText);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            this.getMarkerHover(hoverRegion, s);
            if (PyHoverPreferencesPage.getShowDocstringOnHover()) {
                this.getDocstringHover(hoverRegion, s, ps);
            }
        }
        return this.buf.toString();
    }

    private void getMarkerHover(IRegion hoverRegion, PySourceViewer s) {
        Iterator<MarkerAnnotationAndPosition> it = s.getMarkerIterator();
        while (it.hasNext()) {
            MarkerAnnotationAndPosition marker = it.next();
            try {
                Object msg;
                if (marker.position == null) continue;
                int cStart = marker.position.offset;
                int cEnd = cStart + marker.position.length;
                int offset = hoverRegion.getOffset();
                if (cStart > offset || cEnd < offset) continue;
                if (this.buf.length() > 0) {
                    this.buf.append(PyInformationPresenter.LINE_DELIM);
                }
                if ("PyDev breakpoint".equals(msg = marker.markerAnnotation.getMarker().getAttribute("message"))) continue;
                this.buf.appendObject(msg);
            }
            catch (CoreException coreException) {}
        }
    }

    private void getDocstringHover(IRegion hoverRegion, PySourceViewer s, PySelection ps) {
        RefactoringRequest request;
        CompletionCache completionCache = new CompletionCache();
        ArrayList<IDefinition> selected = new ArrayList<IDefinition>();
        PyEdit edit = s.getEdit();
        IPythonNature nature = null;
        try {
            nature = edit.getPythonNature();
            request = new RefactoringRequest(edit.getEditorFile(), ps, (IProgressMonitor)new NullProgressMonitor(), nature, edit);
        }
        catch (MisconfigurationException misconfigurationException) {
            return;
        }
        String[] tokenAndQual = null;
        try {
            tokenAndQual = PyRefactoringFindDefinition.findActualDefinition(request, completionCache, selected);
        }
        catch (CompletionRecursionException e1) {
            Log.log((Throwable)e1);
            this.buf.append("Unable to compute hover. Details: " + e1.getMessage());
            return;
        }
        FastStringBuffer temp = new FastStringBuffer();
        if (tokenAndQual != null && selected.size() > 0) {
            for (IDefinition d : selected) {
                String str;
                ItemPointer pointer;
                String asPortableString;
                Definition def = (Definition)d;
                SimpleNode astToPrint = null;
                if (def.ast != null) {
                    stmtType stmt;
                    SimpleNode peek;
                    FastStack scopeStack;
                    astToPrint = def.ast;
                    if ((astToPrint instanceof Name || astToPrint instanceof NameTok) && def.scope != null && (scopeStack = def.scope.getScopeStack()) != null && scopeStack.size() > 0 && (peek = (SimpleNode)scopeStack.peek()) != null && (stmt = NodeUtils.findStmtForNode((SimpleNode)peek, (SimpleNode)astToPrint)) != null) {
                        astToPrint = stmt;
                    }
                    try {
                        astToPrint = astToPrint.createCopy();
                        MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)astToPrint);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                temp = temp.clear();
                if (def.value != null) {
                    if (astToPrint instanceof FunctionDef) {
                        temp.append("def ");
                    } else if (astToPrint instanceof ClassDef) {
                        temp.append("class ");
                    }
                    temp.append("<pydev_hint_bold>");
                    temp.append(def.value);
                    temp.append("</pydev_hint_bold>");
                    temp.append(' ');
                }
                if (def.module != null) {
                    temp.append("Found at: ");
                    temp.append("<pydev_hint_bold>");
                    temp.append(def.module.getName());
                    temp.append("</pydev_hint_bold>");
                    temp.append(PyInformationPresenter.LINE_DELIM);
                }
                if (def.module != null && def.value != null && (asPortableString = (pointer = PyRefactoringFindDefinition.createItemPointer(def)).asPortableString()) != null) {
                    temp.replaceAll("<pydev_hint_bold>", StringUtils.format((String)"<pydev_link pointer=\"%s\">", (Object[])new Object[]{StringEscapeUtils.escapeXml((String)asPortableString)}));
                    temp.replaceAll("</pydev_hint_bold>", "</pydev_link>");
                }
                if ((str = PyTextHover.printAst(edit, astToPrint)) != null && str.trim().length() > 0) {
                    temp.append(PyInformationPresenter.LINE_DELIM);
                    temp.append(str);
                } else {
                    String docstring = d.getDocstring(nature, (ICompletionCache)completionCache);
                    if (docstring != null && docstring.trim().length() > 0) {
                        IIndentPrefs indentPrefs = edit.getIndentPrefs();
                        temp.append(PyStringUtils.fixWhitespaceColumnsToLeftFromDocstring((String)docstring, (String)indentPrefs.getIndentationString()));
                    }
                }
                if (temp.length() <= 0) continue;
                if (this.buf.length() > 0) {
                    this.buf.append(PyInformationPresenter.LINE_DELIM);
                }
                this.buf.append(temp);
            }
        }
    }

    public static String printAst(PyEdit edit, SimpleNode astToPrint) {
        String str = null;
        if (astToPrint != null) {
            IIndentPrefs indentPrefs = edit != null ? edit.getIndentPrefs() : DefaultIndentPrefs.get();
            Str docStr = NodeUtils.getNodeDocStringNode((SimpleNode)astToPrint);
            if (docStr != null) {
                docStr.s = PyStringUtils.fixWhitespaceColumnsToLeftFromDocstring((String)docStr.s, (String)indentPrefs.getIndentationString());
            }
            PrettyPrinterPrefsV2 prefsV2 = PrettyPrinterV2.createDefaultPrefs((IGrammarVersionProvider)edit, (IIndentPrefs)indentPrefs, (String)PyInformationPresenter.LINE_DELIM);
            PrettyPrinterV2 prettyPrinterV2 = new PrettyPrinterV2((IPrettyPrinterPrefs)prefsV2);
            try {
                str = prettyPrinterV2.print(astToPrint);
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        return str;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        this.textSelection = (ITextSelection)textViewer.getSelectionProvider().getSelection();
        return new Region(offset, 0);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                String tooltipAffordanceString = null;
                try {
                    tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                }
                catch (Throwable throwable) {}
                PyInformationControl ret = new PyInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new PyInformationPresenter(), tooltipAffordanceString);
                return ret;
            }
        };
    }

    private final class PyInformationControl
    extends DefaultInformationControl
    implements IInformationControlExtension3 {
        private PyInformationControl(Shell parent, int textStyles, DefaultInformationControl.IInformationPresenter presenter, String statusFieldText) {
            super(parent, textStyles, presenter, statusFieldText);
        }
    }
}

