/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.refactoring;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.DecoratableObject;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.structure.Tuple;

public class RefactoringRequest
extends DecoratableObject {
    public static final String FIND_REFERENCES_ONLY_IN_LOCAL_SCOPE = "findReferencesOnlyOnLocalScope";
    public static final String FIND_DEFINITION_IN_ADDITIONAL_INFO = "findDefinitionInAdditionalInfo";
    public final File file;
    public PySelection ps;
    private final Stack<IProgressMonitor> monitors = new Stack();
    public IPythonNature nature;
    public final PyEdit pyEdit;
    private IModule module;
    public String moduleName;
    public String inputName;
    public String initialName;
    private Map<String, List<Tuple<List<ModulesKey>, IPythonNature>>> tokenToLastReferences = new HashMap<String, List<Tuple<List<ModulesKey>, IPythonNature>>>();

    public RefactoringRequest(File file, PySelection selection, IPythonNature nature) {
        this(file, selection, null, nature, null);
    }

    public RefactoringRequest(PyEdit pyEdit, PySelection ps) throws MisconfigurationException {
        this(pyEdit.getEditorFile(), ps, null, pyEdit.getPythonNature(), pyEdit);
    }

    public RefactoringRequest(File file, PySelection ps, IProgressMonitor monitor, IPythonNature nature, PyEdit pyEdit) {
        this.file = file;
        this.ps = ps;
        this.pushMonitor(monitor);
        if (nature == null) {
            Tuple<IPythonNature, String> infoForFile = PydevPlugin.getInfoForFile(file);
            if (infoForFile != null) {
                this.nature = (IPythonNature)infoForFile.o1;
                this.moduleName = (String)infoForFile.o2;
            } else {
                this.nature = null;
            }
        } else {
            this.nature = nature;
            if (file != null) {
                this.moduleName = this.resolveModule();
            }
        }
        this.pyEdit = pyEdit;
    }

    public synchronized void communicateWork(String desc) throws OperationCanceledException {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.setTaskName(desc);
            monitor.worked(1);
            this.checkCancelled();
        }
    }

    public void checkCancelled() throws OperationCanceledException {
        if (this.getMonitor().isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public String resolveModule() {
        if (this.moduleName == null && this.file != null && this.nature != null) {
            try {
                this.moduleName = this.nature.resolveModule(this.file);
            }
            catch (MisconfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.moduleName;
    }

    public int getBeginCol() {
        return this.ps.getAbsoluteCursorOffset() - this.ps.getStartLine().getOffset();
    }

    public int getEndCol() {
        return this.ps.getAbsoluteCursorOffset() + this.ps.getSelLength() - this.ps.getEndLine().getOffset();
    }

    public int getEndLine() {
        return this.ps.getEndLineIndex() + 1;
    }

    public int getBeginLine() {
        return this.ps.getStartLineIndex() + 1;
    }

    public IModule getModule() {
        if (this.module == null) {
            SimpleNode ast;
            if (this.pyEdit != null && (ast = this.pyEdit.getAST()) != null) {
                IDocument doc = this.ps.getDoc();
                long astModificationTimeStamp = this.pyEdit.getAstModificationTimeStamp();
                if (astModificationTimeStamp != -1L && astModificationTimeStamp == ((IDocumentExtension4)doc).getModificationStamp()) {
                    this.module = AbstractModule.createModule(ast, this.file, this.resolveModule());
                }
            }
            if (this.module == null) {
                try {
                    this.module = AbstractModule.createModuleFromDoc(this.resolveModule(), this.file, this.ps.getDoc(), (IGrammarVersionProvider)this.nature, false);
                }
                catch (MisconfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.module;
    }

    public SimpleNode getAST() {
        IModule mod = this.getModule();
        if (mod instanceof SourceModule) {
            return ((SourceModule)mod).getAst();
        }
        return null;
    }

    public void fillInitialNameAndOffset() {
        try {
            Tuple currToken = this.ps.getCurrToken();
            this.initialName = (String)currToken.o1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IDocument getDoc() {
        return this.ps.getDoc();
    }

    public void pushMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.monitors.push(monitor);
    }

    public IProgressMonitor popMonitor() {
        return this.monitors.pop();
    }

    public IProgressMonitor getMonitor() {
        return this.monitors.peek();
    }

    public IFile getIFile() {
        if (this.pyEdit == null) {
            return null;
        }
        return this.pyEdit.getIFile();
    }

    public boolean isModuleRenameRefactoringRequest() {
        return false;
    }

    public IPythonNature getTargetNature() {
        return this.nature;
    }

    public List<Tuple<List<ModulesKey>, IPythonNature>> getPossibleReferences(String initialName) {
        return this.tokenToLastReferences.get(initialName);
    }

    public void setPossibleReferences(String initialName, List<Tuple<List<ModulesKey>, IPythonNature>> ret) {
        this.tokenToLastReferences.put(initialName, ret);
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.setAdditionalInfo(FIND_REFERENCES_ONLY_IN_LOCAL_SCOPE, !updateReferences);
    }
}

