/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.editorinput.PydevZipFileEditorInput;
import org.python.pydev.editorinput.PydevZipFileStorage;

public class PyEditorInputFactory
implements IElementFactory {
    public static final String FACTORY_ID = "org.python.pydev.editorinput.pyEditorInputFactory";
    private static final String TAG_FILE = "file";
    private static final String TAG_ZIP_PATH = "zip_path";

    public IAdaptable createElement(IMemento memento) {
        String file = memento.getString(TAG_FILE);
        if (file == null || file.length() == 0) {
            return null;
        }
        String zipPath = memento.getString(TAG_ZIP_PATH);
        if (zipPath == null || zipPath.length() == 0) {
            return PydevFileEditorInput.create(new File(file), false);
        }
        return new PydevZipFileEditorInput(new PydevZipFileStorage(new File(file), zipPath));
    }

    public static void saveState(IMemento memento, PydevZipFileEditorInput pydevZipFileEditorInput) {
        memento.putString(TAG_FILE, pydevZipFileEditorInput.getFile().toString());
        memento.putString(TAG_ZIP_PATH, pydevZipFileEditorInput.getZipPath());
    }

    public static void saveState(IMemento memento, PydevFileEditorInput pydevFileEditorInput) {
        memento.putString(TAG_FILE, pydevFileEditorInput.getFile().toString());
    }
}

