/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.core.IPyStackFrame;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editorinput.PyFileLabelProvider;
import org.python.pydev.editorinput.PySourceLocatorPrefs;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.locator.GetContainers;
import org.python.pydev.shared_core.locator.GetFiles;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PySourceLocatorBase {
    private static final GetFiles getFiles = new GetFiles(){

        protected IFile getFileInProject(IPath location, IProject project) {
            IFile file = super.getFileInProject(location, project);
            if (file != null) {
                return file;
            }
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                try {
                    Set projectSourcePathSet = pythonPathNature.getProjectSourcePathFolderSet();
                    for (IResource iResource : projectSourcePathSet) {
                        IContainer iContainer;
                        if (!(iResource instanceof IContainer) || (file = this.getFileInContainer(location, iContainer = (IContainer)iResource)) == null) continue;
                        return file;
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };
    private static final GetContainers getContainers = new GetContainers(){

        protected IContainer getContainerInProject(IPath location, IProject project) {
            IContainer file = super.getContainerInProject(location, project);
            if (file != null) {
                return file;
            }
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                try {
                    Set projectSourcePathSet = pythonPathNature.getProjectSourcePathFolderSet();
                    for (IResource iResource : projectSourcePathSet) {
                        IContainer iContainer;
                        if (!(iResource instanceof IContainer) || (file = this.getContainerInContainer(location, iContainer = (IContainer)iResource)) == null) continue;
                        return file;
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };

    public IEditorInput createEditorInput(IPath path, IProject project) {
        return this.createEditorInput(path, true, null, project);
    }

    public IEditorInput createEditorInput(IPath path) {
        return this.createEditorInput(path, true, null, null);
    }

    public IFile[] getFilesForLocation(IPath location, IProject project, boolean stopOnFirst) {
        return getFiles.getFilesForLocation(location, project, stopOnFirst);
    }

    public IFile getFileForLocation(IPath location, IProject project) {
        return getFiles.getFileForLocation(location, project);
    }

    public IFile getWorkspaceFile(File file, IProject project) {
        return this.getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()), project);
    }

    public IFile[] getWorkspaceFiles(File file) {
        boolean stopOnFirst = false;
        IFile[] files = this.getFilesForLocation(Path.fromOSString((String)file.getAbsolutePath()), null, stopOnFirst);
        if (files == null || files.length == 0) {
            return null;
        }
        return files;
    }

    public IContainer getContainerForLocation(IPath location, IProject project) {
        return getContainers.getContainerForLocation(location, project);
    }

    public IContainer[] getContainersForLocation(IPath location) {
        boolean stopOnFirst = false;
        return getContainers.getContainersForLocation(location, null, stopOnFirst);
    }

    public IEditorInput createEditorInput(IPath path, boolean askIfDoesNotExist, IPyStackFrame pyStackFrame, IProject project) {
        IEditorInput edInput;
        block19: {
            IFile fileForLocation;
            int onSourceNotFound = PySourceLocatorPrefs.getOnSourceNotFound();
            edInput = null;
            String pathTranslation = PySourceLocatorPrefs.getPathTranslation(path);
            if (pathTranslation != null) {
                if (!pathTranslation.equals("DONTASK")) {
                    path = Path.fromOSString((String)pathTranslation);
                } else {
                    askIfDoesNotExist = false;
                }
            }
            if ((fileForLocation = this.getFileForLocation(path, project)) != null && fileForLocation.exists()) {
                return new FileEditorInput(fileForLocation);
            }
            File systemFile = path.toFile();
            if (systemFile.exists()) {
                edInput = PydevFileEditorInput.create(systemFile, true);
            }
            if (edInput == null) {
                IEditorInput input = this.getEditorInputFromExistingEditors(systemFile.getName());
                if (input != null) {
                    return input;
                }
                if (askIfDoesNotExist && (onSourceNotFound == 0 || onSourceNotFound == 1)) {
                    File file;
                    IPath location;
                    IWorkspace w = ResourcesPlugin.getWorkspace();
                    List<IFile> likelyFiles = this.getLikelyFiles(path, w);
                    IFile iFile = this.selectWorkspaceFile(likelyFiles.toArray(new IFile[0]));
                    if (iFile != null && (location = iFile.getLocation()) != null) {
                        PySourceLocatorPrefs.addPathTranslation(path, location);
                        return new FileEditorInput(iFile);
                    }
                    IEditorInput pydevFileEditorInput = this.selectFilesystemFileForPath(path);
                    input = pydevFileEditorInput;
                    if (input != null && (file = PydevFileEditorInput.getFile(pydevFileEditorInput)) != null) {
                        PySourceLocatorPrefs.addPathTranslation(path, Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)file)));
                        return input;
                    }
                    PySourceLocatorPrefs.setIgnorePathTranslation(path);
                }
            }
            if (edInput == null && (onSourceNotFound == 1 || onSourceNotFound == 2) && pyStackFrame != null) {
                try {
                    String fileContents = pyStackFrame.getFileContents();
                    if (fileContents == null || fileContents.length() <= 0) break block19;
                    String lastSegment = path.lastSegment();
                    File workspaceMetadataFile = PydevPlugin.getWorkspaceMetadataFile("temporary_files");
                    if (!workspaceMetadataFile.exists()) {
                        workspaceMetadataFile.mkdirs();
                    }
                    File file = new File(workspaceMetadataFile, lastSegment);
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {}
                    FileUtils.writeStrToFile((String)fileContents, (File)file);
                    try {
                        file.setReadOnly();
                    }
                    catch (Exception exception) {}
                    edInput = PydevFileEditorInput.create(file, true);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return edInput;
    }

    private IEditorInput getEditorInputFromExistingEditors(final String matchName) {
        final Tuple workbenchAndReturn = new Tuple((Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IEditorReference[] editorReferences;
                IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)workbenchAndReturn.o1;
                if (workbenchWindow == null) {
                    workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
                if (workbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = workbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editor = editorReference.getEditor(false);
                    if (editor != null && editor instanceof PyEdit) {
                        PyEdit pyEdit = (PyEdit)editor;
                        IEditorInput editorInput = pyEdit.getEditorInput();
                        if (editorInput instanceof IPathEditorInput) {
                            String considerName;
                            IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                            IPath localPath = pathEditorInput.getPath();
                            if (localPath != null && matchName.equals(considerName = localPath.segment(localPath.segmentCount() - 1))) {
                                workbenchAndReturn.o2 = editorInput;
                                return;
                            }
                        } else {
                            File editorFile = pyEdit.getEditorFile();
                            if (editorFile != null && editorFile.getName().equals(matchName)) {
                                workbenchAndReturn.o2 = editorInput;
                                return;
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
        if (workbenchAndReturn.o1 == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        return (IEditorInput)workbenchAndReturn.o2;
    }

    protected IEditorInput selectFilesystemFileForPath(final IPath path) {
        final ArrayList l = new ArrayList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog dialog = new FileDialog(shell);
                dialog.setText(path + " - select correspondent filesystem file.");
                String[] wildcardValidSourceFiles = FileTypesPreferencesPage.getWildcardValidSourceFiles();
                wildcardValidSourceFiles = StringUtils.addString((String[])wildcardValidSourceFiles, (String)"*");
                dialog.setFilterExtensions(wildcardValidSourceFiles);
                String string = dialog.open();
                if (string != null) {
                    l.add(string);
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (l.size() > 0) {
            String fileAbsolutePath = FileUtils.getFileAbsolutePath((String)((String)l.get(0)));
            return PydevFileEditorInput.create(new File(fileAbsolutePath), true);
        }
        return null;
    }

    private List<IFile> getLikelyFiles(IPath path, IWorkspace w) {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            IResource[] resources = w.getRoot().members();
            this.getLikelyFiles(path, ret, resources);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    private void getLikelyFiles(IPath path, List<IFile> ret, IResource[] resources) throws CoreException {
        String strPath = path.removeFileExtension().lastSegment().toLowerCase();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile f = (IFile)resource;
                if (PythonPathHelper.isValidSourceFile(f) && resource.getFullPath().removeFileExtension().lastSegment().toLowerCase().equals(strPath)) {
                    ret.add((IFile)resource);
                }
            } else if (resource instanceof IContainer) {
                this.getLikelyFiles(path, ret, ((IContainer)resource).members());
            }
            ++n2;
        }
    }

    private IFile selectWorkspaceFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final ArrayList selected = new ArrayList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new PyFileLabelProvider());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("File may be matched to multiple files in the workspace.");
                if (dialog.open() == 0) {
                    selected.add((IFile)dialog.getFirstResult());
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (selected.size() > 0) {
            return (IFile)selected.get(0);
        }
        return null;
    }
}

