/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.InterpreterInfoTreeNode;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.PythonpathTreeNode;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.ImageCache;

public class InterpreterInfoTreeNodeRoot<X>
extends InterpreterInfoTreeNode<X> {
    public final IInterpreterInfo interpreterInfo;
    private final PythonpathTreeNode belowRootFiles;
    private final InterpreterInfoTreeNode<LabelAndImage> systemLibs;
    private final InterpreterInfoTreeNode<LabelAndImage> externalLibs;
    private final InterpreterInfoTreeNode<LabelAndImage> predefinedCompletions;
    private final InterpreterInfoTreeNode<LabelAndImage> forcedBuiltins;

    public InterpreterInfoTreeNodeRoot(IInterpreterInfo interpreterInfo, IPythonNature nature, Object parent, X data) {
        super(parent, data);
        this.interpreterInfo = interpreterInfo;
        Assert.isNotNull((Object)interpreterInfo);
        InterpreterInfoTreeNodeRoot root = this;
        ImageCache imageCache = PydevPlugin.getImageCache();
        String executableOrJar = interpreterInfo.getExecutableOrJar();
        File file = new File(executableOrJar);
        this.belowRootFiles = file.exists() ? new PythonpathTreeNode(root, file.getParentFile(), imageCache.get("icons/python_16x16.png"), true) : null;
        this.systemLibs = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("System Libs", imageCache.get("icons/library_obj.gif")));
        List pythonPath = interpreterInfo.getPythonPath();
        Collections.sort(pythonPath);
        for (String string : pythonPath) {
            new PythonpathTreeNode(this.systemLibs, new File(string), imageCache.get("icons/jar_l_obj.gif"), true);
        }
        this.externalLibs = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("External Libs", imageCache.get("icons/library_obj.gif")));
        IPythonPathNature pythonPathNature = nature.getPythonPathNature();
        try {
            List projectExternalSourcePath = pythonPathNature.getProjectExternalSourcePathAsList(true);
            Collections.sort(projectExternalSourcePath);
            for (Object string : projectExternalSourcePath) {
                File f = new File((String)string);
                new PythonpathTreeNode(this.externalLibs, f, imageCache.get("icons/jar_l_obj.gif"), true);
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        this.predefinedCompletions = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("Predefined Completions", imageCache.get("icons/library_obj.gif")));
        for (String string : interpreterInfo.getPredefinedCompletionsPath()) {
            new PythonpathTreeNode(this.predefinedCompletions, new File(string), imageCache.get("icons/jar_l_obj.gif"), true);
        }
        this.forcedBuiltins = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("Forced builtins", imageCache.get("icons/library_obj.gif")));
        Iterator it = interpreterInfo.forcedLibsIterator();
        while (it.hasNext()) {
            Object string;
            string = (String)it.next();
            new InterpreterInfoTreeNode<LabelAndImage>(this.forcedBuiltins, new LabelAndImage((String)string, imageCache.get("icons/jar_obj.gif")));
        }
    }

    public List<TreeNode> getNodesOrderedForFileSearch() {
        ArrayList<TreeNode> ret = new ArrayList<TreeNode>();
        ret.add(this.externalLibs);
        ret.add(this.systemLibs);
        if (this.belowRootFiles != null) {
            ret.add(this.belowRootFiles);
        }
        ret.add(this.predefinedCompletions);
        return ret;
    }
}

