/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.AutoConfigMaker;
import org.python.pydev.ui.pythonpathconf.IInterpreterProviderFactory;
import org.python.pydev.ui.pythonpathconf.InterpreterConfigHelpers;
import org.python.pydev.utils.ICallback;

public class PyProjectPythonDetails
extends PropertyPage {
    public IAdaptable element;
    public ProjectInterpreterAndGrammarConfig projectConfig = new ProjectInterpreterAndGrammarConfig();

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    public Control createContents(Composite p) {
        Control contents = this.projectConfig.doCreateContents(p);
        this.setSelected();
        return contents;
    }

    private void setSelected() {
        PythonNature pythonNature = PythonNature.getPythonNature(this.getProject());
        try {
            String version = pythonNature.getVersion();
            if (IPythonNature.Versions.ALL_PYTHON_VERSIONS.contains(version)) {
                this.projectConfig.radioPy.setSelection(true);
            } else if (IPythonNature.Versions.ALL_IRONPYTHON_VERSIONS.contains(version)) {
                this.projectConfig.radioIron.setSelection(true);
            } else if (IPythonNature.Versions.ALL_JYTHON_VERSIONS.contains(version)) {
                this.projectConfig.radioJy.setSelection(true);
            }
            String v = (String)StringUtils.split((String)version, (char)' ').get(1);
            this.projectConfig.comboGrammarVersion.setText(v);
            this.projectConfig.selectionListener.widgetSelected(null);
            String configuredInterpreter = pythonNature.getProjectInterpreterName();
            if (configuredInterpreter != null) {
                this.projectConfig.interpretersChoice.setText(configuredInterpreter);
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
    }

    protected void performApply() {
        this.doIt();
    }

    public boolean performOk() {
        return this.doIt();
    }

    public boolean performCancel() {
        PyDialogHelpers.enableAskInterpreterStep(true);
        return super.performCancel();
    }

    private boolean doIt() {
        IProject project = this.getProject();
        if (project != null) {
            String projectInterpreter;
            PythonNature pythonNature;
            block4: {
                pythonNature = PythonNature.getPythonNature(project);
                projectInterpreter = this.projectConfig.getProjectInterpreter();
                if (projectInterpreter != null) break block4;
                return false;
            }
            try {
                pythonNature.setVersion(this.projectConfig.getSelectedPythonOrJythonAndGrammarVersion(), projectInterpreter);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        PyDialogHelpers.enableAskInterpreterStep(true);
        return true;
    }

    public static class ProjectInterpreterAndGrammarConfig {
        private static final String INTERPRETER_NOT_CONFIGURED_MSG = "<a>Please configure an interpreter before proceeding.</a>";
        public Button radioPy;
        public Button radioJy;
        public Button radioIron;
        public Combo comboGrammarVersion;
        public Label versionLabel;
        public Combo interpretersChoice;
        private Link interpreterNoteText;
        private SelectionListener selectionListener;
        private ICallback onSelectionChanged;
        private Label interpreterLabel;

        public ProjectInterpreterAndGrammarConfig() {
            PyDialogHelpers.enableAskInterpreterStep(false);
        }

        public ProjectInterpreterAndGrammarConfig(ICallback callback) {
            this.onSelectionChanged = callback;
        }

        public Control doCreateContents(Composite p) {
            Composite topComp = new Composite(p, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 1;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            topComp.setLayout((Layout)innerLayout);
            GridData gd = new GridData(1808);
            topComp.setLayoutData((Object)gd);
            Group group = new Group(topComp, 0);
            group.setText("Choose the project type");
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 8;
            layout.numColumns = 3;
            group.setLayout((Layout)layout);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            this.radioPy = new Button((Composite)group, 16400);
            this.radioPy.setText("Python");
            this.radioJy = new Button((Composite)group, 16400);
            this.radioJy.setText("Jython");
            this.radioIron = new Button((Composite)group, 16400);
            this.radioIron.setText("IronPython");
            this.versionLabel = new Label(topComp, 0);
            this.versionLabel.setText("Grammar Version");
            gd = new GridData(768);
            this.versionLabel.setLayoutData((Object)gd);
            this.comboGrammarVersion = new Combo(topComp, 8);
            for (String s : IPythonNature.Versions.VERSION_NUMBERS) {
                this.comboGrammarVersion.add(s);
            }
            gd = new GridData(768);
            this.comboGrammarVersion.setLayoutData((Object)gd);
            this.interpreterLabel = new Label(topComp, 0);
            this.interpreterLabel.setText("Interpreter");
            gd = new GridData(768);
            this.interpreterLabel.setLayoutData((Object)gd);
            final String[] idToConfig = new String[]{"org.python.pydev.ui.pythonpathconf.interpreterPreferencesPagePython"};
            this.interpretersChoice = new Combo(topComp, 8);
            this.selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Button source;
                    if (e != null && !(source = (Button)e.getSource()).getSelection()) {
                        return;
                    }
                    IInterpreterManager interpreterManager = ProjectInterpreterAndGrammarConfig.this.radioJy.getSelection() ? PydevPlugin.getJythonInterpreterManager() : (ProjectInterpreterAndGrammarConfig.this.radioIron.getSelection() ? PydevPlugin.getIronpythonInterpreterManager() : PydevPlugin.getPythonInterpreterManager());
                    IInterpreterInfo[] interpretersInfo = interpreterManager.getInterpreterInfos();
                    if (interpretersInfo.length > 0) {
                        ArrayList<String> interpretersWithDefault = new ArrayList<String>();
                        interpretersWithDefault.add("Default");
                        IInterpreterInfo[] iInterpreterInfoArray = interpretersInfo;
                        int n = interpretersInfo.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IInterpreterInfo info = iInterpreterInfoArray[n2];
                            interpretersWithDefault.add(info.getName());
                            ++n2;
                        }
                        ProjectInterpreterAndGrammarConfig.this.interpretersChoice.setItems(interpretersWithDefault.toArray(new String[0]));
                        ProjectInterpreterAndGrammarConfig.this.interpretersChoice.setVisible(true);
                        ProjectInterpreterAndGrammarConfig.this.interpreterNoteText.setText("<a>Click here to configure an interpreter not listed.</a>");
                        ProjectInterpreterAndGrammarConfig.this.interpretersChoice.setText("Default");
                    } else {
                        ProjectInterpreterAndGrammarConfig.this.interpretersChoice.setVisible(false);
                        ProjectInterpreterAndGrammarConfig.this.interpreterNoteText.setText(ProjectInterpreterAndGrammarConfig.INTERPRETER_NOT_CONFIGURED_MSG);
                    }
                    switch (interpreterManager.getInterpreterType()) {
                        case 0: {
                            idToConfig[0] = "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPagePython";
                            break;
                        }
                        case 1: {
                            idToConfig[0] = "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageJython";
                            break;
                        }
                        case 2: {
                            idToConfig[0] = "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageIronpython";
                            break;
                        }
                        default: {
                            throw new RuntimeException("Cannot recognize type: " + interpreterManager.getInterpreterType());
                        }
                    }
                    ProjectInterpreterAndGrammarConfig.this.triggerCallback();
                }
            };
            gd = new GridData(768);
            this.interpretersChoice.setLayoutData((Object)gd);
            this.radioPy.addSelectionListener(this.selectionListener);
            this.radioJy.addSelectionListener(this.selectionListener);
            this.radioIron.addSelectionListener(this.selectionListener);
            this.interpreterNoteText = new Link(topComp, 16448);
            gd = new GridData(768);
            this.interpreterNoteText.setLayoutData((Object)gd);
            this.interpreterNoteText.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String interpreterName = ProjectInterpreterAndGrammarConfig.this.getProjectInterpreter();
                    if (interpreterName != null) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)idToConfig[0], null, null);
                        dialog.open();
                        ProjectInterpreterAndGrammarConfig.this.selectionListener.widgetSelected(null);
                    } else {
                        MessageDialog mdialog = new MessageDialog(null, "Configure interpreter", null, "How would you like to configure the interpreter?", 3, InterpreterConfigHelpers.CONFIG_NAMES, 0);
                        int open = mdialog.open();
                        if (open == 0) {
                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)idToConfig[0], null, null);
                            dialog.open();
                            ProjectInterpreterAndGrammarConfig.this.selectionListener.widgetSelected(null);
                        } else if (open != -1) {
                            IInterpreterProviderFactory.InterpreterType interpreterType = ProjectInterpreterAndGrammarConfig.this.radioJy.getSelection() ? IInterpreterProviderFactory.InterpreterType.JYTHON : (ProjectInterpreterAndGrammarConfig.this.radioIron.getSelection() ? IInterpreterProviderFactory.InterpreterType.IRONPYTHON : IInterpreterProviderFactory.InterpreterType.PYTHON);
                            JobChangeAdapter onJobComplete = new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!ProjectInterpreterAndGrammarConfig.this.interpreterNoteText.isDisposed()) {
                                                ProjectInterpreterAndGrammarConfig.this.selectionListener.widgetSelected(null);
                                            }
                                        }
                                    });
                                }
                            };
                            ProjectInterpreterAndGrammarConfig.this.interpreterNoteText.setText("Configuration in progress...");
                            boolean advanced = open == 2;
                            AutoConfigMaker a = new AutoConfigMaker(interpreterType, advanced, null, null);
                            if (a.autoConfigSingleApply(onJobComplete)) {
                                ProjectInterpreterAndGrammarConfig.this.triggerCallback();
                            } else {
                                ProjectInterpreterAndGrammarConfig.this.selectionListener.widgetSelected(null);
                            }
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return topComp;
        }

        private void triggerCallback() {
            if (this.onSelectionChanged != null) {
                try {
                    this.onSelectionChanged.call(null);
                }
                catch (Exception e1) {
                    Log.log((Throwable)e1);
                }
            }
        }

        public String getSelectedPythonOrJythonAndGrammarVersion() {
            if (this.radioPy.getSelection()) {
                return "python " + this.comboGrammarVersion.getText();
            }
            if (this.radioJy.getSelection()) {
                return "jython " + this.comboGrammarVersion.getText();
            }
            if (this.radioIron.getSelection()) {
                return "ironpython " + this.comboGrammarVersion.getText();
            }
            throw new RuntimeException("Some radio must be selected");
        }

        public String getProjectInterpreter() {
            if (INTERPRETER_NOT_CONFIGURED_MSG.equals(this.interpreterNoteText.getText())) {
                return null;
            }
            return this.interpretersChoice.getText();
        }

        public void setDefaultSelection() {
            this.radioPy.setSelection(true);
            this.comboGrammarVersion.setText("2.7");
            this.selectionListener.widgetSelected(null);
        }
    }
}

