/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterConfigHelpers;

public class PyDialogHelpers {
    public static final int INTERPRETER_CANCEL_CONFIG = -1;
    private static MessageDialog dialog = null;
    private static int enableAskInterpreter = 0;

    public static void openWarning(String title, String message) {
        DialogHelpers.openWarning((String)title, (String)message);
    }

    public static void openCritical(String title, String message) {
        DialogHelpers.openCritical((String)title, (String)message);
    }

    public static boolean openQuestion(String title, String message) {
        return DialogHelpers.openQuestion((String)title, (String)message);
    }

    public static int openWarningWithIgnoreToggle(String title, String message, String key) {
        Shell shell = EditorUtils.getShell();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(key);
        if (val.trim().length() == 0) {
            val = "prompt";
        }
        if (!val.equals("always")) {
            MessageDialogWithToggle.openWarning((Shell)shell, (String)title, (String)message, (String)"Don't show this message again", (boolean)false, (IPreferenceStore)store, (String)key);
        }
        return 0;
    }

    public static int openCriticalWithChoices(String title, String message, String[] choices) {
        Shell shell = EditorUtils.getShell();
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 1, choices, 0);
        return dialog.open();
    }

    public static void enableAskInterpreterStep(boolean enable) {
        if ((enableAskInterpreter = Math.min(enableAskInterpreter + (enable ? 1 : -1), 0)) < 0 && dialog != null) {
            dialog.close();
            dialog = null;
        }
    }

    public static int openQuestionConfigureInterpreter(AbstractInterpreterManager m) {
        String key;
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        boolean val = store.getBoolean(key = "NOTIFY_NO_INTERPRETER_" + m.getInterpreterType());
        if (val) {
            String title = String.valueOf(m.getInterpreterUIName()) + " not configured";
            String message = "It seems that the " + m.getInterpreterUIName() + " interpreter is not currently configured.\n\nHow do you want to proceed?";
            Shell shell = EditorUtils.getShell();
            String[] dialogButtonLabels = new String[4];
            int i = 0;
            while (i < InterpreterConfigHelpers.CONFIG_NAMES.length) {
                dialogButtonLabels[i] = InterpreterConfigHelpers.CONFIG_NAMES[i];
                ++i;
            }
            dialogButtonLabels[dialogButtonLabels.length - 1] = "Don't ask again";
            dialog = new MessageDialog(shell, title, null, message, 3, dialogButtonLabels, 0);
            int open = dialog.open();
            if (dialog != null) {
                dialog = null;
                if (open == dialogButtonLabels.length - 1) {
                    store.setValue(key, false);
                    return -1;
                }
                return open;
            }
        }
        return -1;
    }

    public static boolean getAskAgainInterpreter(AbstractInterpreterManager m) {
        if (enableAskInterpreter < 0) {
            return false;
        }
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("NOTIFY_NO_INTERPRETER_" + m.getInterpreterType());
    }
}

