/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.utils.AsynchronousProgressMonitorDialog;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;

public abstract class AbstractInterpreterPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected AbstractInterpreterEditor pathEditor;
    private boolean inApply = false;

    public AbstractInterpreterPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        PyDialogHelpers.enableAskInterpreterStep(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected abstract AbstractInterpreterEditor getInterpreterEditor(Composite var1);

    public static SelectionDialog createChooseIntepreterInfoDialog(IWorkbenchWindow workbenchWindow, IInterpreterInfo[] interpreters, String msg, boolean selectMultiple) {
        Object selectionDialog;
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IInterpreterInfo[]) {
                    return (IInterpreterInfo[])inputElement;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return PydevPlugin.getImageCache().get("icons/python_16x16.png");
            }

            public String getText(Object element) {
                if (element != null && element instanceof IInterpreterInfo) {
                    IInterpreterInfo info = (IInterpreterInfo)element;
                    return info.getNameForUI();
                }
                return super.getText(element);
            }
        };
        if (selectMultiple) {
            selectionDialog = new ListSelectionDialog(workbenchWindow.getShell(), interpreters, contentProvider, (ILabelProvider)labelProvider, msg){

                protected Control createContents(Composite parent) {
                    Control ret = super.createContents(parent);
                    PydevPlugin.setCssId(parent, "py-select-dialog", true);
                    return ret;
                }
            };
        } else {
            ListDialog listDialog = new ListDialog(workbenchWindow.getShell()){

                protected Control createContents(Composite parent) {
                    Control ret = super.createContents(parent);
                    PydevPlugin.setCssId(parent, "py-select-dialog", true);
                    return ret;
                }
            };
            listDialog.setContentProvider(contentProvider);
            listDialog.setLabelProvider((ILabelProvider)labelProvider);
            listDialog.setInput((Object)interpreters);
            listDialog.setMessage(msg);
            selectionDialog = listDialog;
        }
        return selectionDialog;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.inApply = true;
        try {
            super.performApply();
        }
        finally {
            this.inApply = false;
        }
    }

    protected void performDefaults() {
    }

    public boolean performCancel() {
        PyDialogHelpers.enableAskInterpreterStep(true);
        return super.performCancel();
    }

    public boolean performOk() {
        super.performOk();
        this.pathEditor.updateTree();
        IInterpreterManager interpreterManager = this.getInterpreterManager();
        String newStringToPersist = AbstractInterpreterManager.getStringToPersist(this.pathEditor.getExesList());
        String oldStringToPersist = AbstractInterpreterManager.getStringToPersist(interpreterManager.getInterpreterInfos());
        boolean changed = !newStringToPersist.equals(oldStringToPersist);
        if (changed || this.inApply) {
            this.restoreInterpreterInfos(changed);
        }
        if (!this.inApply) {
            PyDialogHelpers.enableAskInterpreterStep(true);
        }
        return true;
    }

    protected abstract IInterpreterManager getInterpreterManager();

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.pathEditor = this.getInterpreterEditor(p);
        this.addField(this.pathEditor);
    }

    protected void restoreInterpreterInfos(boolean editorChanged) {
        final Set<String> interpreterNamesToRestore = this.pathEditor.getInterpreterExeOrJarToRestoreAndClear();
        final IInterpreterInfo[] exesList = this.pathEditor.getExesList();
        if (!editorChanged && interpreterNamesToRestore.size() == 0) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            SelectionDialog listDialog = AbstractInterpreterPreferencesPage.createChooseIntepreterInfoDialog(workbenchWindow, exesList, "Select interpreters to be restored", true);
            int open = listDialog.open();
            if (open != 0) {
                return;
            }
            Object[] result = listDialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                interpreterNamesToRestore.add(((IInterpreterInfo)o).getExecutableOrJar());
                ++n2;
            }
        }
        AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(this.getShell());
        monitorDialog.setBlockOnOpen(false);
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Restoring PYTHONPATH", -1);
                    try {
                        AbstractInterpreterPreferencesPage.this.pathEditor.pushExpectedSetInfos();
                        AbstractInterpreterPreferencesPage.this.getInterpreterManager().setInfos(exesList, interpreterNamesToRestore, monitor);
                    }
                    finally {
                        AbstractInterpreterPreferencesPage.this.pathEditor.popExpectedSetInfos();
                        monitor.done();
                    }
                }
            };
            monitorDialog.run(true, true, operation);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

