/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.log.Log;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterProviderFactory;
import org.python.pydev.ui.pythonpathconf.AlreadyInstalledInterpreterProvider;
import org.python.pydev.ui.pythonpathconf.IInterpreterProvider;
import org.python.pydev.ui.pythonpathconf.IInterpreterProviderFactory;

public class JythonInterpreterProviderFactory
extends AbstractInterpreterProviderFactory {
    @Override
    public IInterpreterProvider[] getInterpreterProviders(IInterpreterProviderFactory.InterpreterType type) {
        if (type != IInterpreterProviderFactory.InterpreterType.JYTHON) {
            return null;
        }
        LinkedHashSet<String> pathsToSearch = new LinkedHashSet<String>();
        try {
            Map<String, String> env = SimpleRunner.getDefaultSystemEnv(null);
            if (env.containsKey("JYTHON_HOME")) {
                pathsToSearch.add(env.get("JYTHON_HOME"));
            }
            if (env.containsKey("PYTHON_HOME")) {
                pathsToSearch.add(env.get("PYTHON_HOME"));
            }
            if (env.containsKey("JYTHONHOME")) {
                pathsToSearch.add(env.get("JYTHONHOME"));
            }
            if (env.containsKey("PYTHONHOME")) {
                pathsToSearch.add(env.get("PYTHONHOME"));
            }
            if (env.containsKey("PATH")) {
                String path = env.get("PATH");
                String separator = SimpleRunner.getPythonPathSeparator();
                List split = StringUtils.split((String)path, (String)separator);
                pathsToSearch.addAll(split);
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        pathsToSearch.add("/usr/share/java");
        pathsToSearch.add("/usr/bin");
        pathsToSearch.add("/usr/local/bin");
        String[] searchResults = this.searchPaths(pathsToSearch, Arrays.asList("jython.jar"));
        if (searchResults.length > 0) {
            return AlreadyInstalledInterpreterProvider.create("jython", searchResults);
        }
        return null;
    }
}

