/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.ArrayList;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.grammarcommon.AbstractTreeBuilderHelpers;
import org.python.pydev.parser.grammarcommon.ComprehensionCollection;
import org.python.pydev.parser.grammarcommon.Decorators;
import org.python.pydev.parser.grammarcommon.IdentityNode;
import org.python.pydev.parser.grammarcommon.JJTPythonGrammarState;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.DictComp;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.ExtSlice;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.SetComp;
import org.python.pydev.parser.jython.ast.Starred;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.StrJoin;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.WithItem;
import org.python.pydev.parser.jython.ast.WithItemType;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.sliceType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.string.FastStringBuffer;

public abstract class AbstractTreeBuilder
extends AbstractTreeBuilderHelpers {
    private SimpleNode lastOpened;
    private final FastStringBuffer tempBuffer = new FastStringBuffer(20);

    @Override
    public final SimpleNode getLastOpened() {
        return this.lastOpened;
    }

    public AbstractTreeBuilder(JJTPythonGrammarState stack) {
        super(stack);
        if (!stack.getGrammar().generateTree) {
            throw new AssertionError((Object)"Should not create a tree builder if the grammar won't generate the AST.");
        }
    }

    protected abstract SimpleNode onCloseNode(SimpleNode var1, int var2) throws Exception;

    @Override
    public final SimpleNode openNode(int id) {
        SimpleNode ret;
        switch (id) {
            case 554: {
                ret = new Module(null);
                break;
            }
            case 621: {
                ret = new Name("False", 1, true);
                break;
            }
            case 622: {
                ret = new Name("True", 1, true);
                break;
            }
            case 623: {
                ret = new Name("None", 1, true);
                break;
            }
            case 543: 
            case 580: {
                ret = new Name(null, 1, false);
                break;
            }
            case 585: {
                ret = new Num(null, -1, null);
                break;
            }
            case 598: 
            case 610: 
            case 619: {
                ret = new Str(null, -1, false, false, false);
                break;
            }
            case 556: {
                ret = new For(null, null, null, null);
                break;
            }
            case 548: {
                ret = new Exec(null, null, null);
                break;
            }
            case 589: {
                ret = new Pass();
                break;
            }
            case 529: {
                ret = new Break();
                break;
            }
            case 536: {
                ret = new Continue();
                break;
            }
            case 516: {
                ret = new decoratorsType(null, null, null, null, null, false);
                break;
            }
            case 562: {
                ret = new If(null, null, null);
                break;
            }
            case 512: {
                ret = new AugAssign(null, 1, null);
                break;
            }
            case 508: {
                ret = new AugAssign(null, 2, null);
                break;
            }
            case 510: {
                ret = new AugAssign(null, 3, null);
                break;
            }
            case 505: {
                ret = new AugAssign(null, 4, null);
                break;
            }
            case 509: {
                ret = new AugAssign(null, 5, null);
                break;
            }
            case 504: {
                ret = new AugAssign(null, 11, null);
                break;
            }
            case 511: {
                ret = new AugAssign(null, 9, null);
                break;
            }
            case 515: {
                ret = new AugAssign(null, 10, null);
                break;
            }
            case 507: {
                ret = new AugAssign(null, 7, null);
                break;
            }
            case 514: {
                ret = new AugAssign(null, 8, null);
                break;
            }
            case 513: {
                ret = new AugAssign(null, 6, null);
                break;
            }
            case 506: {
                ret = new AugAssign(null, 12, null);
                break;
            }
            case 587: {
                ret = new BinOp(null, 9, null);
                break;
            }
            case 615: {
                ret = new BinOp(null, 10, null);
                break;
            }
            case 501: {
                ret = new BinOp(null, 11, null);
                break;
            }
            case 577: {
                ret = new BinOp(null, 7, null);
                break;
            }
            case 596: {
                ret = new BinOp(null, 8, null);
                break;
            }
            case 500: {
                ret = new BinOp(null, 1, null);
                break;
            }
            case 602: {
                ret = new BinOp(null, 2, null);
                break;
            }
            case 579: {
                ret = new BinOp(null, 3, null);
                break;
            }
            case 541: {
                ret = new BinOp(null, 4, null);
                break;
            }
            case 578: {
                ret = new BinOp(null, 5, null);
                break;
            }
            case 591: {
                ret = new BinOp(null, 6, null);
                break;
            }
            case 555: {
                ret = new BinOp(null, 12, null);
                break;
            }
            case 590: {
                ret = new UnaryOp(3, null);
                break;
            }
            case 581: {
                ret = new UnaryOp(4, null);
                break;
            }
            case 567: {
                ret = new UnaryOp(1, null);
                break;
            }
            case 583: {
                ret = new UnaryOp(2, null);
                break;
            }
            case 563: {
                ret = new Import(null);
                break;
            }
            case 544: {
                ret = new Attribute(null, null, 1);
                break;
            }
            case 635: {
                ret = new Starred(null, 2);
                break;
            }
            default: {
                ret = new IdentityNode(id);
            }
        }
        ret.setId(id);
        this.lastOpened = ret;
        return ret;
    }

    @Override
    public final SimpleNode closeNode(SimpleNode n, int arity) throws Exception {
        switch (n.getId()) {
            case -1: {
                throw new ParseException("Illegal node found: " + n, n);
            }
            case 554: {
                Module m = (Module)n;
                m.body = this.makeStmts(arity);
                return m;
            }
            case 516: 
            case 529: 
            case 532: 
            case 533: 
            case 536: 
            case 580: 
            case 585: 
            case 589: 
            case 598: 
            case 610: 
            case 619: 
            case 621: 
            case 622: 
            case 623: {
                return n;
            }
            case 603: {
                stmtType[] stmts = new stmtType[arity];
                int i = arity - 1;
                while (i >= 0) {
                    SimpleNode yield_or_stmt = this.stack.popNode();
                    if (yield_or_stmt instanceof Yield) {
                        stmts[i] = new Expr((Yield)yield_or_stmt);
                    } else {
                        try {
                            stmts[i] = (stmtType)yield_or_stmt;
                        }
                        catch (ClassCastException e) {
                            this.recoverFromClassCastException(yield_or_stmt, e);
                            stmts[i] = new Pass();
                        }
                    }
                    --i;
                }
                return new Suite(stmts);
            }
            case 556: {
                Suite orelseSuite = null;
                if (this.stack.nodeArity() == 5) {
                    orelseSuite = this.popSuiteAndSuiteType();
                }
                stmtType[] body = this.popSuite();
                exprType iter = (exprType)this.stack.popNode();
                exprType target = (exprType)this.stack.popNode();
                this.ctx.setStore(target);
                For forStmt = (For)n;
                forStmt.target = target;
                forStmt.iter = iter;
                forStmt.body = body;
                forStmt.orelse = orelseSuite;
                return forStmt;
            }
            case 518: {
                return new If(null, null, null);
            }
            case 562: {
                return this.handleIfConstruct(n, arity);
            }
            case 548: {
                exprType locals = arity >= 3 ? (exprType)this.stack.popNode() : null;
                exprType globals = arity >= 2 ? (exprType)this.stack.popNode() : null;
                exprType value = (exprType)this.stack.popNode();
                Exec exec = (Exec)n;
                exec.body = value;
                exec.locals = locals;
                exec.globals = globals;
                return exec;
            }
            case 537: {
                ArrayList<SimpleNode> list2 = new ArrayList<SimpleNode>();
                ArrayList<SimpleNode> listArgs = new ArrayList<SimpleNode>();
                while (this.stack.nodeArity() > 0) {
                    SimpleNode node = this.stack.popNode();
                    while (!(node instanceof decoratorsType)) {
                        if (node instanceof comprehensionType) {
                            listArgs.add(node);
                            listArgs.add(this.stack.popNode());
                        } else if (node instanceof ComprehensionCollection) {
                            listArgs.add(((ComprehensionCollection)node).getGenerators()[0]);
                            listArgs.add(this.stack.popNode());
                        } else {
                            listArgs.add(node);
                        }
                        node = this.stack.popNode();
                    }
                    listArgs.add(node);
                    list2.add(0, this.makeDecorator(listArgs));
                    listArgs.clear();
                }
                return new Decorators(list2.toArray(new decoratorsType[0]), 537);
            }
            case 601: {
                sliceType[] dims = new sliceType[arity];
                int i = arity - 1;
                while (i >= 0) {
                    SimpleNode sliceNode = this.stack.popNode();
                    if (sliceNode instanceof sliceType) {
                        dims[i] = (sliceType)sliceNode;
                    } else if (!(sliceNode instanceof IdentityNode)) {
                        throw new RuntimeException("Expected a sliceType or an IdentityNode. Received :" + sliceNode.getClass());
                    }
                    --i;
                }
                return new ExtSlice(dims);
            }
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 515: {
                AugAssign augAssign = (AugAssign)n;
                exprType value1 = (exprType)this.stack.popNode();
                exprType target1 = (exprType)this.stack.popNode();
                this.ctx.setAugStore(target1);
                augAssign.target = target1;
                augAssign.value = value1;
                return n;
            }
            case 588: {
                return new BoolOp(2, this.makeExprs());
            }
            case 502: {
                return new BoolOp(1, this.makeExprs());
            }
            case 534: {
                if (arity <= 2) {
                    throw new ParseException("Internal error: To make a compare, at least 3 nodes are needed.", n);
                }
                int l = arity / 2;
                exprType[] comparators = new exprType[l];
                int[] ops = new int[l];
                int i = l - 1;
                while (i >= 0) {
                    comparators[i] = (exprType)this.stack.popNode();
                    SimpleNode op = this.stack.popNode();
                    switch (op.getId()) {
                        case 573: {
                            ops[i] = 3;
                            break;
                        }
                        case 559: {
                            ops[i] = 5;
                            break;
                        }
                        case 546: {
                            ops[i] = 1;
                            break;
                        }
                        case 560: {
                            ops[i] = 6;
                            break;
                        }
                        case 574: {
                            ops[i] = 4;
                            break;
                        }
                        case 582: {
                            ops[i] = 2;
                            break;
                        }
                        case 568: {
                            ops[i] = 9;
                            break;
                        }
                        case 584: {
                            ops[i] = 10;
                            break;
                        }
                        case 570: {
                            ops[i] = 8;
                            break;
                        }
                        case 569: {
                            ops[i] = 7;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown cmp op:" + op.getId());
                        }
                    }
                    --i;
                }
                return new Compare((exprType)this.stack.popNode(), ops, comparators);
            }
            case 546: 
            case 559: 
            case 560: 
            case 568: 
            case 569: 
            case 570: 
            case 573: 
            case 574: 
            case 582: 
            case 584: {
                return n;
            }
            case 500: 
            case 501: 
            case 541: 
            case 555: 
            case 577: 
            case 578: 
            case 579: 
            case 587: 
            case 591: 
            case 596: 
            case 602: 
            case 615: {
                BinOp op = (BinOp)n;
                exprType right = (exprType)this.stack.popNode();
                exprType left = (exprType)this.stack.popNode();
                op.right = right;
                op.left = left;
                return n;
            }
            case 567: 
            case 581: 
            case 583: 
            case 590: {
                ((UnaryOp)n).operand = (exprType)this.stack.popNode();
                return n;
            }
            case 563: {
                ((Import)n).names = this.makeAliases(arity);
                return n;
            }
            case 544: {
                NameTok attr = this.makeName(8);
                exprType value = (exprType)this.stack.popNode();
                Attribute attribute = (Attribute)n;
                attribute.value = value;
                attribute.attr = attr;
                return n;
            }
            case 517: {
                return new Delete(null);
            }
            case 539: {
                SimpleNode[] exprs = this.makeExprs(arity - 1);
                this.ctx.setDelete(exprs);
                Delete d = (Delete)this.stack.popNode();
                d.targets = exprs;
                return d;
            }
            case 543: {
                Name name = (Name)n;
                FastStringBuffer sb = this.tempBuffer.clear();
                int i = 0;
                while (i < arity) {
                    if (i > 0) {
                        sb.insert(0, '.');
                    }
                    Name name0 = (Name)this.stack.popNode();
                    sb.insert(0, name0.id);
                    this.addSpecials(name0, name);
                    name0.specialsBefore = name.getSpecialsBefore();
                    name0.specialsAfter = name.getSpecialsAfter();
                    ++i;
                }
                name.id = sb.toString();
                return name;
            }
            case 542: {
                NameTok asname = null;
                if (arity > 1) {
                    asname = this.makeName(4);
                }
                return new aliasType(this.makeName(4), asname);
            }
            case 565: {
                NameTok asname = null;
                if (arity > 1) {
                    asname = this.makeName(4);
                }
                return new aliasType(this.makeName(4), asname);
            }
            case 635: {
                Starred s = (Starred)n;
                s.value = (exprType)this.stack.popNode();
                this.ctx.setStore(s);
                return s;
            }
            case 599: {
                StrJoin ret;
                Str str2 = (Str)this.stack.popNode();
                SimpleNode o = this.stack.popNode();
                if (o instanceof Str) {
                    Str str1 = (Str)o;
                    ret = new StrJoin(new exprType[]{str1, str2});
                } else {
                    StrJoin strJ = (StrJoin)o;
                    exprType[] newStrs = new exprType[strJ.strs.length + 1];
                    System.arraycopy(strJ.strs, 0, newStrs, 0, strJ.strs.length);
                    newStrs[strJ.strs.length] = str2;
                    strJ.strs = newStrs;
                    ret = strJ;
                }
                ret.beginLine = ret.strs[0].beginLine;
                ret.beginColumn = ret.strs[0].beginColumn;
                return ret;
            }
        }
        return this.onCloseNode(n, arity);
    }

    private final SimpleNode handleIfConstruct(SimpleNode n, int arity) {
        If last;
        Suite orelse = null;
        if (arity % 3 == 1) {
            arity -= 2;
            orelse = this.popSuiteAndSuiteType();
        }
        Suite suite = (Suite)this.stack.popNode();
        --arity;
        stmtType[] body = suite.body;
        exprType test = (exprType)this.stack.popNode();
        if (--arity == 0) {
            last = (If)n;
        } else {
            last = (If)this.stack.popNode();
            --arity;
        }
        last.test = test;
        last.body = body;
        last.orelse = orelse;
        this.addSpecialsAndClearOriginal(suite, last);
        while (arity > 0) {
            suite = (Suite)this.stack.popNode();
            --arity;
            body = suite.body;
            test = (exprType)this.stack.popNode();
            Suite newOrElse = new Suite(new stmtType[]{last});
            if (--arity == 0) {
                last = (If)n;
            } else {
                last = (If)this.stack.popNode();
                --arity;
            }
            last.test = test;
            last.body = body;
            last.orelse = newOrElse;
            this.addSpecialsAndClearOriginal(suite, last);
        }
        return last;
    }

    protected final SimpleNode makeImportFrom25Onwards(int arity) throws ParseException {
        NameTok nT;
        ArrayList<aliasType> aliastL = new ArrayList<aliasType>();
        while (arity > 0 && this.stack.peekNode() instanceof aliasType) {
            aliastL.add(0, (aliasType)this.stack.popNode());
            --arity;
        }
        if (arity > 0) {
            nT = this.makeName(7);
        } else {
            nT = new NameTok("", 7);
            Object temporaryTok = this.stack.getGrammar().temporaryToken;
            ISpecialStr temporaryToken = temporaryTok instanceof ISpecialStr ? (ISpecialStr)temporaryTok : ((Token)temporaryTok).asSpecialStr();
            if (temporaryToken.toString().equals("from")) {
                nT.beginColumn = temporaryToken.getBeginCol();
                nT.beginLine = temporaryToken.getBeginLine();
            } else {
                Log.log((String)"Expected to find 'from' token as the current temporary token (begin col/line can be wrong)!");
            }
        }
        return new ImportFrom(nT, aliastL.toArray(new aliasType[0]), 0);
    }

    protected final ComprehensionCollection makeCompFor(int arity) throws Exception {
        ComprehensionCollection col = null;
        if (this.stack.peekNode() instanceof ComprehensionCollection) {
            col = (ComprehensionCollection)this.stack.popNode();
            --arity;
        } else {
            col = new ComprehensionCollection();
        }
        ArrayList<exprType> ifs = new ArrayList<exprType>();
        int i = arity - 3;
        while (i >= 0) {
            SimpleNode ifsNode = this.stack.popNode();
            ifs.add((exprType)ifsNode);
            --i;
        }
        exprType iter = (exprType)this.stack.popNode();
        exprType target = (exprType)this.stack.popNode();
        this.ctx.setStore(target);
        col.added.add(new Comprehension(target, iter, ifs.toArray(new exprType[0])));
        return col;
    }

    protected final SimpleNode makeDictionaryOrSet(int arity) {
        if (arity == 0) {
            return new Dict(new exprType[0], new exprType[0]);
        }
        SimpleNode dictNode0 = this.stack.popNode();
        if (dictNode0 instanceof Set) {
            Set set = (Set)dictNode0;
            exprType[] elts = new exprType[arity - 1];
            int i = arity - 2;
            while (i >= 0) {
                elts[i] = (exprType)this.stack.popNode();
                --i;
            }
            set.elts = elts;
            return set;
        }
        if (dictNode0 instanceof ComprehensionCollection) {
            if (arity == 2) {
                ComprehensionCollection comp = (ComprehensionCollection)dictNode0;
                return new SetComp((exprType)this.stack.popNode(), comp.getGenerators());
            }
            if (arity == 3) {
                SimpleNode dictNode1 = this.stack.popNode();
                ComprehensionCollection comp = (ComprehensionCollection)dictNode0;
                return new DictComp((exprType)this.stack.popNode(), (exprType)dictNode1, comp.getGenerators());
            }
        }
        boolean isDictComplete = arity % 2 == 0;
        int l = arity / 2;
        exprType[] keys = isDictComplete ? new exprType[l] : new exprType[l + 1];
        boolean node0Used = false;
        exprType[] vals = new exprType[l];
        int i = l - 1;
        while (i >= 0) {
            if (!node0Used) {
                node0Used = true;
                vals[i] = (exprType)dictNode0;
                keys[i] = (exprType)this.stack.popNode();
            } else {
                vals[i] = (exprType)this.stack.popNode();
                keys[i] = (exprType)this.stack.popNode();
            }
            --i;
        }
        if (!isDictComplete) {
            keys[keys.length - 1] = node0Used ? (exprType)this.stack.popNode() : (exprType)dictNode0;
        }
        return new Dict(keys, vals);
    }

    protected final SimpleNode makeWithItem(int arity) throws Exception {
        exprType expr = (exprType)this.stack.popNode();
        exprType asExpr = null;
        if (--arity > 0) {
            asExpr = expr;
            expr = (exprType)this.stack.popNode();
            this.ctx.setStore(asExpr);
        }
        return new WithItem(expr, asExpr);
    }

    protected final SimpleNode makeWithStmt(int arity) {
        Suite suite = (Suite)this.stack.popNode();
        WithItemType[] items = new WithItem[--arity];
        while (arity > 0) {
            items[arity - 1] = (WithItem)this.stack.popNode();
            --arity;
        }
        Suite s = new Suite(suite.body);
        this.addSpecialsAndClearOriginal(suite, s);
        return new With(items, s);
    }
}

