/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import org.python.pydev.parser.grammarcommon.JJTPythonGrammarState;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Visitor;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.List;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Starred;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.shared_core.string.StringUtils;

public final class CtxVisitor
extends Visitor {
    private int ctx;
    private JJTPythonGrammarState stack;

    public CtxVisitor(JJTPythonGrammarState stack) {
        this.stack = stack;
    }

    public void setParam(SimpleNode node) throws Exception {
        this.ctx = 6;
        this.visit(node);
    }

    public void setKwOnlyParam(SimpleNode node) throws Exception {
        this.ctx = 8;
        this.visit(node);
    }

    public void setStore(SimpleNode node) throws Exception {
        this.ctx = 2;
        this.visit(node);
    }

    public void setStore(SimpleNode[] nodes) throws Exception {
        int i = 0;
        while (i < nodes.length) {
            this.setStore(nodes[i]);
            ++i;
        }
    }

    public void setDelete(SimpleNode node) throws Exception {
        this.ctx = 3;
        this.visit(node);
    }

    public void setDelete(SimpleNode[] nodes) throws Exception {
        int i = 0;
        while (i < nodes.length) {
            this.setDelete(nodes[i]);
            ++i;
        }
    }

    public void setAugStore(SimpleNode node) throws Exception {
        this.ctx = 5;
        this.visit(node);
    }

    @Override
    public Object visitName(Name node) throws Exception {
        if (this.ctx == 2 && node.reserved) {
            String msg = StringUtils.format((String)"Cannot assign value to %s (because it's a keyword)", (Object[])new Object[]{node.id});
            this.stack.getGrammar().addAndReport(new ParseException(msg, node), msg);
        } else {
            node.ctx = this.ctx;
        }
        return null;
    }

    @Override
    public Object visitStarred(Starred node) throws Exception {
        node.ctx = this.ctx;
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitAttribute(Attribute node) throws Exception {
        node.ctx = this.ctx;
        return null;
    }

    @Override
    public Object visitSubscript(Subscript node) throws Exception {
        node.ctx = this.ctx;
        return null;
    }

    @Override
    public Object visitList(List node) throws Exception {
        if (this.ctx == 5) {
            String msg = "Augmented assign to list not possible";
            this.stack.getGrammar().addAndReport(new ParseException(msg, node), msg);
        } else {
            node.ctx = this.ctx;
        }
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitTuple(Tuple node) throws Exception {
        if (this.ctx == 5) {
            String msg = "Augmented assign to tuple not possible";
            this.stack.getGrammar().addAndReport(new ParseException(msg, node), msg);
        } else {
            node.ctx = this.ctx;
        }
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitCall(Call node) throws Exception {
        throw new ParseException("can't assign to function call", node);
    }

    public Object visitListComp(Call node) throws Exception {
        throw new ParseException("can't assign to list comprehension call", node);
    }

    @Override
    public Object unhandled_node(SimpleNode node) throws Exception {
        throw new ParseException("can't assign to operator:" + node, node);
    }
}

