/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.exprType;

public final class Comprehension
extends comprehensionType {
    public exprType target;
    public exprType iter;
    public exprType[] ifs;

    public Comprehension(exprType target, exprType iter, exprType[] ifs) {
        this.target = target;
        this.iter = iter;
        this.ifs = ifs;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.iter == null ? 0 : this.iter.hashCode());
        result = 31 * result + Arrays.hashCode(this.ifs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comprehension other = (Comprehension)obj;
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        if (this.iter == null ? other.iter != null : !this.iter.equals(other.iter)) {
            return false;
        }
        return Arrays.equals(this.ifs, other.ifs);
    }

    @Override
    public Comprehension createCopy() {
        return this.createCopy(true);
    }

    @Override
    public Comprehension createCopy(boolean copyComments) {
        commentType commentType2;
        exprType[] new0;
        if (this.ifs != null) {
            new0 = new exprType[this.ifs.length];
            int i = 0;
            while (i < this.ifs.length) {
                new0[i] = (exprType)(this.ifs[i] != null ? this.ifs[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.ifs;
        }
        Comprehension temp = new Comprehension(this.target != null ? (exprType)this.target.createCopy(copyComments) : null, this.iter != null ? (exprType)this.iter.createCopy(copyComments) : null, new0);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Comprehension[");
        sb.append("target=");
        sb.append(this.dumpThis(this.target));
        sb.append(", ");
        sb.append("iter=");
        sb.append(this.dumpThis(this.iter));
        sb.append(", ");
        sb.append("ifs=");
        sb.append(this.dumpThis(this.ifs));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitComprehension(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.target != null) {
            this.target.accept(visitor);
        }
        if (this.iter != null) {
            this.iter.accept(visitor);
        }
        if (this.ifs != null) {
            int i = 0;
            while (i < this.ifs.length) {
                if (this.ifs[i] != null) {
                    this.ifs[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

