/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.stmtType;

public final class ImportFrom
extends stmtType {
    public NameTokType module;
    public aliasType[] names;
    public int level;

    public ImportFrom(NameTokType module, aliasType[] names, int level) {
        this.module = module;
        this.names = names;
        this.level = level;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + Arrays.hashCode(this.names);
        result = 31 * result + this.level;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportFrom other = (ImportFrom)obj;
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        if (!Arrays.equals(this.names, other.names)) {
            return false;
        }
        return this.level == other.level;
    }

    @Override
    public ImportFrom createCopy() {
        return this.createCopy(true);
    }

    @Override
    public ImportFrom createCopy(boolean copyComments) {
        commentType commentType2;
        aliasType[] new0;
        if (this.names != null) {
            new0 = new aliasType[this.names.length];
            int i = 0;
            while (i < this.names.length) {
                new0[i] = this.names[i] != null ? this.names[i].createCopy(copyComments) : null;
                ++i;
            }
        } else {
            new0 = this.names;
        }
        ImportFrom temp = new ImportFrom(this.module != null ? (NameTokType)this.module.createCopy(copyComments) : null, new0, this.level);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("ImportFrom[");
        sb.append("module=");
        sb.append(this.dumpThis(this.module));
        sb.append(", ");
        sb.append("names=");
        sb.append(this.dumpThis(this.names));
        sb.append(", ");
        sb.append("level=");
        sb.append(this.dumpThis(this.level));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitImportFrom(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.module != null) {
            this.module.accept(visitor);
        }
        if (this.names != null) {
            int i = 0;
            while (i < this.names.length) {
                if (this.names[i] != null) {
                    this.names[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

