/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;
import org.python.pydev.parser.visitors.FindLastLineVisitor;
import org.python.pydev.parser.visitors.StopVisitingException;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorVisitor;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorWithLoop;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.Reflection;

public class NodeUtils {
    protected static final String[] strTypes = new String[]{"'''", "\"\"\"", "'", "\""};

    public static String getNodeArgs(SimpleNode node) {
        if (node instanceof ClassDef) {
            node = NodeUtils.getClassDefInit((ClassDef)node);
        }
        if (node instanceof FunctionDef) {
            FunctionDef f = (FunctionDef)node;
            String startPar = "( ";
            FastStringBuffer buffer = new FastStringBuffer(startPar, 40);
            int i = 0;
            while (i < f.args.args.length) {
                if (buffer.length() > startPar.length()) {
                    buffer.append(", ");
                }
                buffer.append(NodeUtils.getRepresentationString(f.args.args[i]));
                ++i;
            }
            buffer.append(" )");
            return buffer.toString();
        }
        return "";
    }

    public static String getFullArgs(SimpleNode ast) {
        if (ast != null) {
            if (ast instanceof ClassDef) {
                ast = NodeUtils.getClassDefInit((ClassDef)ast);
            }
            if (ast instanceof FunctionDef) {
                String printed;
                FunctionDef functionDef = (FunctionDef)ast;
                if (functionDef.args != null && (printed = PrettyPrinterV2.printArguments(new IGrammarVersionProvider(){

                    public int getGrammarVersion() throws MisconfigurationException {
                        return 99;
                    }
                }, functionDef.args)) != null) {
                    if (!printed.startsWith("(") || !printed.endsWith(")")) {
                        printed = "(" + printed + ")";
                    }
                    return printed;
                }
            }
        }
        return "";
    }

    public static SimpleNode getClassDefInit(ClassDef classDef) {
        stmtType[] stmtTypeArray = classDef.body;
        int n = classDef.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType t = stmtTypeArray[n2];
            if (t instanceof FunctionDef) {
                FunctionDef def = (FunctionDef)t;
                if (((NameTok)def.name).id.equals("__init__")) {
                    return def;
                }
            }
            ++n2;
        }
        return null;
    }

    private static String discoverRep(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof NameTok) {
            return ((NameTok)o).id;
        }
        if (o instanceof SimpleNode) {
            return NodeUtils.getRepresentationString((SimpleNode)o);
        }
        throw new RuntimeException("Expecting a String or a SimpleNode");
    }

    public static String getRepresentationString(SimpleNode node) {
        return NodeUtils.getRepresentationString(node, false);
    }

    public static String getRepresentationString(SimpleNode node, boolean useTypeRepr) {
        SimpleNode type;
        String val;
        if (node instanceof NameTok) {
            NameTok tok = (NameTok)node;
            return tok.id;
        }
        if (node instanceof Name) {
            Name name = (Name)node;
            return name.id;
        }
        if (node instanceof aliasType) {
            aliasType type2 = (aliasType)node;
            return ((NameTok)type2.name).id;
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return NodeUtils.discoverRep(attribute.attr);
        }
        if (node instanceof keywordType) {
            keywordType type3 = (keywordType)node;
            return NodeUtils.discoverRep(type3.arg);
        }
        if (node instanceof ClassDef) {
            ClassDef def = (ClassDef)node;
            return ((NameTok)def.name).id;
        }
        if (node instanceof FunctionDef) {
            FunctionDef def = (FunctionDef)node;
            return ((NameTok)def.name).id;
        }
        if (node instanceof Call) {
            Call call = (Call)node;
            return NodeUtils.getRepresentationString(call.func, useTypeRepr);
        }
        if (node instanceof org.python.pydev.parser.jython.ast.List || node instanceof ListComp) {
            String val2 = "[]";
            if (useTypeRepr) {
                val2 = NodeUtils.getBuiltinType(val2);
            }
            return val2;
        }
        if (node instanceof Dict) {
            String val3 = "{}";
            if (useTypeRepr) {
                val3 = NodeUtils.getBuiltinType(val3);
            }
            return val3;
        }
        if (node instanceof BinOp) {
            BinOp binOp = (BinOp)node;
            if (binOp.left instanceof Str && binOp.op == 5) {
                node = binOp.left;
            }
        }
        if (node instanceof Str) {
            val = useTypeRepr ? NodeUtils.getBuiltinType("''") : "'" + ((Str)node).s + "'";
            return val;
        }
        if (node instanceof Tuple) {
            StringBuffer buf = new StringBuffer();
            Tuple t = (Tuple)node;
            exprType[] exprTypeArray = t.elts;
            int n = t.elts.length;
            int n2 = 0;
            while (n2 < n) {
                exprType e = exprTypeArray[n2];
                buf.append(NodeUtils.getRepresentationString(e, useTypeRepr));
                buf.append(", ");
                ++n2;
            }
            if (t.elts.length > 0) {
                int l = buf.length();
                buf.deleteCharAt(l - 1);
                buf.deleteCharAt(l - 2);
            }
            String val4 = "(" + buf + ")";
            if (useTypeRepr) {
                val4 = NodeUtils.getBuiltinType(val4);
            }
            return val4;
        }
        if (node instanceof Num) {
            val = ((Num)node).n.toString();
            if (useTypeRepr) {
                val = NodeUtils.getBuiltinType(val);
            }
            return val;
        }
        if (node instanceof Import) {
            aliasType[] names;
            aliasType[] aliasTypeArray = names = ((Import)node).names;
            if (names.length != 0) {
                aliasType n = aliasTypeArray[0];
                if (n.asname != null) {
                    return ((NameTok)n.asname).id;
                }
                return ((NameTok)n.name).id;
            }
        }
        if (node instanceof commentType) {
            type = (commentType)node;
            return type.id;
        }
        if (node instanceof excepthandlerType) {
            type = (excepthandlerType)node;
            return ((excepthandlerType)type).name.toString();
        }
        return null;
    }

    public static String getNodeDocString(SimpleNode node) {
        Str s = NodeUtils.getNodeDocStringNode(node);
        if (s != null) {
            return s.s;
        }
        return null;
    }

    public static Str getNodeDocStringNode(SimpleNode node) {
        stmtType def;
        Str s = null;
        stmtType[] body = null;
        if (node instanceof FunctionDef) {
            def = (FunctionDef)node;
            body = def.body;
        } else if (node instanceof ClassDef) {
            def = (ClassDef)node;
            body = ((ClassDef)def).body;
        }
        if (body != null && body.length > 0 && body[0] instanceof Expr) {
            Expr e = (Expr)body[0];
            if (e.value instanceof Str) {
                s = (Str)e.value;
            }
        }
        return s;
    }

    public static String getFullRepresentationString(SimpleNode node) {
        return NodeUtils.getFullRepresentationString(node, false);
    }

    public static String getFullRepresentationString(SimpleNode node, boolean fullOnSubscriptOrCall) {
        if (node instanceof Dict) {
            return "dict";
        }
        if (node instanceof Str || node instanceof Num) {
            return NodeUtils.getRepresentationString(node, true);
        }
        if (node instanceof Tuple) {
            return NodeUtils.getRepresentationString(node, true);
        }
        if (node instanceof Subscript) {
            return NodeUtils.getFullRepresentationString(((Subscript)node).value);
        }
        if (node instanceof Call) {
            Call c = (Call)node;
            node = c.func;
            if (Reflection.hasAttr((Object)node, (String)"value") && Reflection.hasAttr((Object)node, (String)"attr")) {
                return String.valueOf(NodeUtils.getFullRepresentationString((SimpleNode)Reflection.getAttrObj((Object)node, (String)"value"))) + "." + NodeUtils.discoverRep(Reflection.getAttrObj((Object)node, (String)"attr"));
            }
        }
        if (node instanceof Attribute) {
            List<SimpleNode> attributeParts = NodeUtils.getAttributeParts((Attribute)node);
            StringBuffer buf = new StringBuffer();
            for (SimpleNode part : attributeParts) {
                if (part instanceof Call) {
                    if (!fullOnSubscriptOrCall) {
                        return buf.toString();
                    }
                    buf.append("()");
                    continue;
                }
                if (part instanceof Subscript) {
                    if (!fullOnSubscriptOrCall) {
                        return NodeUtils.getFullRepresentationString(((Subscript)part).value);
                    }
                    buf.append(NodeUtils.getFullRepresentationString(((Subscript)part).value));
                    buf.append("[]");
                    continue;
                }
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(NodeUtils.getRepresentationString(part, true));
            }
            return buf.toString();
        }
        if (node instanceof BinOp) {
            BinOp binOp = (BinOp)node;
            if (binOp.left instanceof Str && binOp.op == 5) {
                return NodeUtils.getRepresentationString(node, true);
            }
        }
        return NodeUtils.getRepresentationString(node, true);
    }

    public static boolean isWithin(int line, int col, SimpleNode node) {
        int colDefinition = NodeUtils.getColDefinition(node);
        int lineDefinition = NodeUtils.getLineDefinition(node);
        int[] colLineEnd = NodeUtils.getColLineEnd(node, false);
        return lineDefinition <= line && colDefinition <= col && colLineEnd[0] >= line && colLineEnd[1] >= col;
    }

    public static SimpleNode getNameTokFromNode(SimpleNode ast2) {
        if (ast2 instanceof ClassDef) {
            ClassDef c = (ClassDef)ast2;
            return c.name;
        }
        if (ast2 instanceof FunctionDef) {
            FunctionDef c = (FunctionDef)ast2;
            return c.name;
        }
        return ast2;
    }

    public static int getNameLineDefinition(SimpleNode ast2) {
        return NodeUtils.getLineDefinition(NodeUtils.getNameTokFromNode(ast2));
    }

    public static int getNameColDefinition(SimpleNode ast2) {
        return NodeUtils.getColDefinition(NodeUtils.getNameTokFromNode(ast2));
    }

    public static int getLineDefinition(SimpleNode ast2) {
        while (ast2 instanceof Attribute) {
            exprType val = ((Attribute)ast2).value;
            if (val instanceof Call) break;
            ast2 = val;
        }
        if (ast2 instanceof FunctionDef) {
            return ((FunctionDef)ast2).name.beginLine;
        }
        if (ast2 instanceof ClassDef) {
            return ((ClassDef)ast2).name.beginLine;
        }
        return ast2.beginLine;
    }

    public static int getColDefinition(SimpleNode ast2) {
        return NodeUtils.getColDefinition(ast2, true);
    }

    public static int getColDefinition(SimpleNode ast2, boolean always1ForImports) {
        if (ast2 instanceof Attribute) {
            exprType value = ((Attribute)ast2).value;
            return NodeUtils.getColDefinition(value);
        }
        if (ast2 instanceof Call) {
            Call c = (Call)ast2;
            return NodeUtils.getColDefinition(c.func);
        }
        if (ast2 instanceof Subscript) {
            Subscript s = (Subscript)ast2;
            return NodeUtils.getColDefinition(s.value);
        }
        if (always1ForImports && (ast2 instanceof Import || ast2 instanceof ImportFrom)) {
            return 1;
        }
        return NodeUtils.getClassOrFuncColDefinition(ast2);
    }

    public static int getClassOrFuncColDefinition(SimpleNode ast2) {
        if (ast2 instanceof ClassDef) {
            ClassDef def = (ClassDef)ast2;
            return def.name.beginColumn;
        }
        if (ast2 instanceof FunctionDef) {
            FunctionDef def = (FunctionDef)ast2;
            return def.name.beginColumn;
        }
        return ast2.beginColumn;
    }

    public static int[] getColLineEnd(SimpleNode v) {
        return NodeUtils.getColLineEnd(v, true);
    }

    public static int[] getColLineEnd(SimpleNode v, boolean getOnlyToFirstDot) {
        int lineEnd = NodeUtils.getLineEnd(v);
        int col = 0;
        if (v instanceof Import || v instanceof ImportFrom) {
            return new int[]{lineEnd, -1};
        }
        if (v instanceof Str) {
            if (lineEnd == NodeUtils.getLineDefinition(v)) {
                String s = ((Str)v).s;
                col = NodeUtils.getColDefinition(v) + s.length();
                return new int[]{lineEnd, col};
            }
            String s = ((Str)v).s;
            int i = s.lastIndexOf(10);
            String sub = s.substring(i, s.length());
            col = sub.length();
            return new int[]{lineEnd, col};
        }
        col = NodeUtils.getEndColFromRepresentation(v, getOnlyToFirstDot);
        return new int[]{lineEnd, col};
    }

    private static int getEndColFromRepresentation(SimpleNode v, boolean getOnlyToFirstDot) {
        int colDefinition;
        int i;
        String representationString = NodeUtils.getFullRepresentationString(v);
        if (representationString == null) {
            return -1;
        }
        if (getOnlyToFirstDot && (i = representationString.indexOf(46)) != -1) {
            representationString = representationString.substring(0, i);
        }
        if ((colDefinition = NodeUtils.getColDefinition(v)) == -1) {
            return -1;
        }
        int col = colDefinition + representationString.length();
        return col;
    }

    public static int getLineEnd(SimpleNode v) {
        FindLastLineVisitor findLastLineVisitor;
        stmtType f;
        if (v instanceof Expr) {
            Expr expr = (Expr)v;
            v = expr.value;
        }
        if (v instanceof ImportFrom) {
            f = (ImportFrom)v;
            findLastLineVisitor = new FindLastLineVisitor();
            try {
                ((ImportFrom)f).accept(findLastLineVisitor);
                SimpleNode lastNode = findLastLineVisitor.getLastNode();
                ISpecialStr lastSpecialStr = findLastLineVisitor.getLastSpecialStr();
                if (lastSpecialStr != null && lastSpecialStr.toString().equals(")")) {
                    return lastSpecialStr.getBeginLine();
                }
                return lastNode.beginLine;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if (v instanceof Import) {
            f = (Import)v;
            findLastLineVisitor = new FindLastLineVisitor();
            try {
                ((Import)f).accept(findLastLineVisitor);
                SimpleNode lastNode = findLastLineVisitor.getLastNode();
                return lastNode.beginLine;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if (v instanceof Str) {
            String s = ((Str)v).s;
            int found = 0;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == '\n') {
                    ++found;
                }
                ++i;
            }
            return NodeUtils.getLineDefinition(v) + found;
        }
        return NodeUtils.getLineDefinition(v);
    }

    public static String getBuiltinType(String tok) {
        if (tok.endsWith("'") || tok.endsWith("\"")) {
            return "str";
        }
        if (tok.endsWith("]") && tok.startsWith("[")) {
            return "list";
        }
        if (tok.endsWith("}") && tok.startsWith("{")) {
            return "dict";
        }
        if (tok.endsWith(")") && tok.startsWith("(")) {
            return "tuple";
        }
        try {
            Integer.parseInt(tok);
            return "int";
        }
        catch (Exception exception) {
            try {
                Float.parseFloat(tok);
                return "float";
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static String getNameFromNameTok(NameTokType tok) {
        return ((NameTok)tok).id;
    }

    public static String getNameFromNameTok(NameTok tok) {
        return tok.id;
    }

    public static List<SimpleNode> getAttributeParts(Attribute node) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        nodes.add(node.attr);
        exprType s = node.value;
        while (true) {
            if (s instanceof Attribute) {
                nodes.add(s);
                s = ((Attribute)s).value;
                continue;
            }
            if (!(s instanceof Call)) break;
            nodes.add(s);
            s = ((Call)s).func;
        }
        nodes.add(s);
        Collections.reverse(nodes);
        return nodes;
    }

    public static List<String> getParentNames(ClassDef def, boolean onlyLastSegment) {
        ArrayList<String> ret = new ArrayList<String>();
        exprType[] exprTypeArray = def.bases;
        int n = def.bases.length;
        int n2 = 0;
        while (n2 < n) {
            exprType base = exprTypeArray[n2];
            String rep = NodeUtils.getFullRepresentationString(base);
            if (onlyLastSegment) {
                rep = FullRepIterable.getLastPart((String)rep);
            }
            ret.add(rep);
            ++n2;
        }
        return ret;
    }

    public static boolean isImport(SimpleNode ast) {
        return ast instanceof Import || ast instanceof ImportFrom;
    }

    public static boolean isComment(SimpleNode ast) {
        return ast instanceof commentType;
    }

    public static NameTok getNameForAlias(aliasType t) {
        if (t.asname != null) {
            return (NameTok)t.asname;
        }
        return (NameTok)t.name;
    }

    public static NameTok getNameForRep(aliasType[] names, String representation) {
        aliasType[] aliasTypeArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            aliasType name = aliasTypeArray[n2];
            NameTok nameForAlias = NodeUtils.getNameForAlias(name);
            String aliasRep = NodeUtils.getRepresentationString(nameForAlias);
            if (representation.equals(aliasRep)) {
                return nameForAlias;
            }
            ++n2;
        }
        return null;
    }

    public static String getContextName(int lineNumber, SimpleNode ast) {
        if (ast != null) {
            EasyASTIteratorVisitor visitor = EasyASTIteratorVisitor.create(ast);
            Iterator<ASTEntry> classesAndMethodsIterator = visitor.getClassesAndMethodsIterator();
            ASTEntry last = null;
            while (classesAndMethodsIterator.hasNext()) {
                ASTEntry entry = classesAndMethodsIterator.next();
                if (entry.node.beginLine > lineNumber + 1) break;
                last = entry;
            }
            while (last != null && last.endLine <= lineNumber) {
                last = last.parent;
            }
            if (last != null) {
                return NodeUtils.getFullMethodName(last);
            }
        }
        return null;
    }

    public static String getFullMethodName(ASTEntry last) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        while (last != null) {
            String name = last.getName();
            buffer.insert(0, name);
            last = last.parent;
            if (!first) {
                buffer.insert(name.length(), ".");
            }
            first = false;
        }
        return buffer.toString();
    }

    public static boolean isValidContextForSetNext(SimpleNode ast, int sourceLine, int targetLine) {
        String targetFunctionName;
        String sourceFunctionName = NodeUtils.getContextName(sourceLine - 1, ast);
        if (NodeUtils.compareMethodName(sourceFunctionName, targetFunctionName = NodeUtils.getContextName(targetLine, ast))) {
            ASTEntry sourceAST = NodeUtils.getLoopContextName(sourceLine, ast);
            ASTEntry targetAST = NodeUtils.getLoopContextName(targetLine + 1, ast);
            if (targetAST == null) {
                return true;
            }
            if (NodeUtils.isValidElseBlock(sourceAST, targetAST, sourceLine, targetLine)) {
                return true;
            }
            if (sourceAST == null && targetAST != null) {
                return false;
            }
            if (sourceAST != null && targetAST != null) {
                if (sourceAST.equals((Object)targetAST)) {
                    return NodeUtils.isValidInterLoopContext(sourceLine, targetLine, sourceAST, targetAST);
                }
                ASTEntry last = sourceAST;
                boolean retVal = false;
                while (last != null) {
                    ASTEntry parentAST = last.parent;
                    if (parentAST != null && parentAST.equals((Object)targetAST)) {
                        retVal = true;
                        break;
                    }
                    last = parentAST;
                }
                return retVal;
            }
            return true;
        }
        return false;
    }

    public static boolean compareMethodName(String sourceMethodName, String targetMethodName) {
        if (sourceMethodName == null && targetMethodName == null) {
            return true;
        }
        return sourceMethodName != null && sourceMethodName.equals(targetMethodName);
    }

    public static ASTEntry getLoopContextName(int lineNumber, SimpleNode ast) {
        ASTEntry loopContext = null;
        if (ast != null) {
            int highestBeginLine = 0;
            ArrayList<ASTEntry> contextBlockList = new ArrayList<ASTEntry>();
            EasyASTIteratorWithLoop visitor = EasyASTIteratorWithLoop.create(ast);
            Iterator<ASTEntry> blockIterator = visitor.getIterators();
            while (blockIterator.hasNext()) {
                ASTEntry entry = blockIterator.next();
                if (entry.node.beginLine >= lineNumber || entry.endLine < lineNumber) continue;
                contextBlockList.add(entry);
                if (entry.node.beginLine <= highestBeginLine) continue;
                highestBeginLine = entry.node.beginLine;
            }
            for (ASTEntry astEntry : contextBlockList) {
                if (astEntry.node.beginLine != highestBeginLine) continue;
                loopContext = astEntry;
            }
        }
        return loopContext;
    }

    public static boolean isValidElseBlock(ASTEntry sourceAST, ASTEntry targetAST, int sourceLine, int targetLine) {
        int targetElseBeginLine;
        boolean retval = false;
        if ((targetAST.node instanceof For || targetAST.node instanceof While) && (targetElseBeginLine = NodeUtils.getElseBeginLine(targetAST)) > 0 && targetLine + 1 > targetElseBeginLine) {
            if ((targetAST.parent == null || targetAST.parent.node instanceof FunctionDef) && sourceAST == null) {
                retval = true;
            } else if (targetAST.parent != null && targetAST.parent.equals((Object)sourceAST)) {
                int sourceElseBeginLine = NodeUtils.getElseBeginLine(sourceAST);
                retval = sourceLine <= sourceElseBeginLine;
            }
        }
        return retval;
    }

    public static int getElseBeginLine(ASTEntry astEntry) {
        int beginLine = 0;
        if (astEntry.node instanceof TryExcept && ((TryExcept)astEntry.node).handlers.length > 0) {
            beginLine = ((TryExcept)astEntry.node).handlers[0].beginLine;
        } else if (astEntry.node instanceof For && ((For)astEntry.node).orelse != null) {
            beginLine = ((For)astEntry.node).orelse.beginLine;
        } else if (astEntry.node instanceof While && ((While)astEntry.node).orelse != null) {
            beginLine = ((While)astEntry.node).orelse.beginLine;
        }
        return beginLine;
    }

    public static boolean isValidInterLoopContext(int sourceLine, int targetLine, ASTEntry sourceAST, ASTEntry targetAST) {
        boolean retval = true;
        if (sourceAST.node instanceof TryExcept && targetAST.node instanceof TryExcept && !NodeUtils.isValidTryExceptContext(sourceAST, targetAST, sourceLine, targetLine)) {
            retval = false;
        } else if (sourceAST.node instanceof For && targetAST.node instanceof For && !NodeUtils.isValidForContext(sourceAST, targetAST, sourceLine, targetLine)) {
            retval = false;
        } else if (sourceAST.node instanceof While && targetAST.node instanceof While && !NodeUtils.isValidWhileContext(sourceAST, targetAST, sourceLine, targetLine)) {
            retval = false;
        }
        return retval;
    }

    public static boolean isValidTryExceptContext(ASTEntry sourceAST, ASTEntry targetAST, int sourceLine, int targetLine) {
        excepthandlerType[] exceptionHandlers = ((TryExcept)sourceAST.node).handlers;
        if (((TryExcept)sourceAST.node).specialsAfter != null) {
            List specialList = ((TryExcept)sourceAST.node).specialsAfter;
            for (Object obj : specialList) {
                if (!(obj instanceof commentType) || targetLine + 1 != ((commentType)obj).beginLine) continue;
                return false;
            }
        }
        int i = 0;
        while (i < exceptionHandlers.length) {
            excepthandlerType exceptionHandler = exceptionHandlers[i];
            if (targetLine + 1 == exceptionHandler.beginLine) {
                return false;
            }
            ++i;
        }
        if (exceptionHandlers.length > 0) {
            int exceptionBeginLine = exceptionHandlers[0].beginLine;
            if (targetLine + 1 > ((TryExcept)sourceAST.node).beginLine && targetLine + 1 < exceptionBeginLine && sourceLine >= exceptionBeginLine) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidWhileContext(ASTEntry sourceAST, ASTEntry targetAST, int sourceLine, int targetLine) {
        if (((While)sourceAST.node).orelse != null) {
            int elseBeginLine = ((While)sourceAST.node).orelse.beginLine;
            if (targetLine + 1 > ((While)sourceAST.node).beginLine && targetLine + 1 < elseBeginLine && sourceLine >= elseBeginLine) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidForContext(ASTEntry sourceAST, ASTEntry targetAST, int sourceLine, int targetLine) {
        if (((For)sourceAST.node).orelse != null) {
            int elseBeginLine = ((For)sourceAST.node).orelse.beginLine;
            if (targetLine + 1 > ((For)sourceAST.node).beginLine && targetLine + 1 < elseBeginLine && sourceLine >= elseBeginLine) {
                return false;
            }
        }
        return true;
    }

    public static String getStringToPrint(Str node) {
        StringBuffer buffer = new StringBuffer();
        if (node.unicode) {
            buffer.append("u");
        }
        if (node.binary) {
            buffer.append("b");
        }
        if (node.raw) {
            buffer.append("r");
        }
        String s = strTypes[node.type - 1];
        buffer.append(s);
        buffer.append(node.s);
        buffer.append(s);
        return buffer.toString();
    }

    public static boolean isIfMAinNode(If node) {
        if (node.test instanceof Compare) {
            Compare compareNode = (Compare)node.test;
            if (compareNode.left instanceof Name && ((Name)compareNode.left).id.equals("__name__") && compareNode.ops != null && compareNode.ops.length == 1 && compareNode.ops[0] == 1 && compareNode.comparators != null && compareNode.comparators.length == 1 && compareNode.comparators[0] instanceof Str && ((Str)compareNode.comparators[0]).s.equals("__main__")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidNameRepresentation(String rep) {
        if (rep == null) {
            return false;
        }
        return !"pass".equals(rep) && !rep.startsWith("!<") && rep.indexOf(32) == -1;
    }

    public static exprType makeAttribute(String attrString) {
        List dotSplit = StringUtils.dotSplit((String)attrString);
        Assert.isTrue((dotSplit.size() > 1 ? 1 : 0) != 0);
        exprType first = null;
        Attribute last = null;
        Attribute attr = null;
        int i = dotSplit.size() - 1;
        while (i > 0) {
            Call call = null;
            String part = (String)dotSplit.get(i);
            if (part.endsWith("()")) {
                if (i == dotSplit.size() - 1) {
                    part = part.substring(0, part.length() - 2);
                    call = new Call(null, new exprType[0], new keywordType[0], null, null);
                    first = call;
                } else {
                    throw new RuntimeException("Call only accepted in the last part.");
                }
            }
            attr = new Attribute(null, new NameTok(part, 8), 1);
            if (call != null) {
                call.func = attr;
            }
            if (last != null) {
                last.value = attr;
            }
            last = attr;
            if (first == null) {
                first = last;
            }
            --i;
        }
        String lastPart = (String)dotSplit.get(0);
        last.value = lastPart.endsWith("()") ? new Call(new Name(lastPart.substring(0, lastPart.length() - 2), 1, false), null, null, null, null) : new Name(lastPart, 1, false);
        return first;
    }

    public static stmtType[] getBody(SimpleNode node) {
        if (node instanceof Module) {
            Module module = (Module)node;
            return module.body;
        }
        if (node instanceof ClassDef) {
            ClassDef module = (ClassDef)node;
            return module.body;
        }
        if (node instanceof FunctionDef) {
            FunctionDef module = (FunctionDef)node;
            return module.body;
        }
        if (node instanceof excepthandlerType) {
            excepthandlerType module = (excepthandlerType)node;
            return module.body;
        }
        if (node instanceof For) {
            For module = (For)node;
            return module.body;
        }
        if (node instanceof If) {
            If module = (If)node;
            return module.body;
        }
        if (node instanceof Suite) {
            Suite module = (Suite)node;
            return module.body;
        }
        if (node instanceof suiteType) {
            suiteType module = (suiteType)node;
            return module.body;
        }
        if (node instanceof TryExcept) {
            TryExcept module = (TryExcept)node;
            return module.body;
        }
        if (node instanceof TryFinally) {
            TryFinally module = (TryFinally)node;
            return module.body;
        }
        if (node instanceof While) {
            While module = (While)node;
            return module.body;
        }
        if (node instanceof With) {
            With module = (With)node;
            return module.body.body;
        }
        return new stmtType[0];
    }

    public static SimpleNode getNodeFromPath(SimpleNode node, String path) {
        stmtType leafTestNode = null;
        SimpleNode last = node;
        for (String s : StringUtils.dotSplit((String)path)) {
            stmtType found = null;
            stmtType[] stmtTypeArray = NodeUtils.getBody(last);
            int n = stmtTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                stmtType n3 = stmtTypeArray[n2];
                if (s.equals(NodeUtils.getRepresentationString(n3))) {
                    found = n3;
                    last = n3;
                    break;
                }
                ++n2;
            }
            if (found == null) {
                leafTestNode = null;
                break;
            }
            leafTestNode = found;
        }
        return leafTestNode;
    }

    public static stmtType findStmtForNode(SimpleNode source, final SimpleNode ast) {
        VisitorBase v = new VisitorBase(){
            private stmtType lastStmtFound;

            @Override
            protected Object unhandled_node(SimpleNode node) throws Exception {
                if (node instanceof stmtType) {
                    this.lastStmtFound = (stmtType)node;
                }
                if (node.beginColumn == ast.beginColumn && node.beginLine == ast.beginLine && node.getClass() == ast.getClass() && node.toString().equals(ast.toString())) {
                    throw new StopVisitingException(this.lastStmtFound);
                }
                return null;
            }

            @Override
            public void traverse(SimpleNode node) throws Exception {
                node.traverse(this);
            }
        };
        stmtType[] body = NodeUtils.getBody(source);
        stmtType last = null;
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType stmtType2 = stmtTypeArray[n2];
            if (stmtType2.beginLine > ast.beginLine && last != null) {
                return NodeUtils.checkNode(v, last);
            }
            if (stmtType2.beginLine == ast.beginLine) {
                stmtType n3 = NodeUtils.checkNode(v, stmtType2);
                if (n3 != null) {
                    return n3;
                }
            } else {
                last = stmtType2;
            }
            ++n2;
        }
        return null;
    }

    private static stmtType checkNode(VisitorBase v, stmtType last) {
        try {
            last.accept(v);
        }
        catch (StopVisitingException e) {
            if (e.lastStmtFound != null) {
                return e.lastStmtFound;
            }
            return last;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public static int getOffset(IDocument doc, SimpleNode node) {
        int nodeOffsetBegin = PySelection.getAbsoluteCursorOffset((IDocument)doc, (int)(node.beginLine - 1), (int)(node.beginColumn - 1));
        return nodeOffsetBegin;
    }

    public static String getTypeForParameterFromDocstring(String actTok, SimpleNode node) {
        String nodeDocString = NodeUtils.getNodeDocString(node);
        if (nodeDocString != null) {
            return NodeUtils.getTypeForParameterFromDocstring(actTok, nodeDocString);
        }
        return null;
    }

    public static String getTypeForParameterFromDocstring(String actTok, String nodeDocString) {
        String possible = null;
        Iterable iterLines = StringUtils.iterLines((String)nodeDocString);
        for (String string : iterLines) {
            String trimmed = string.trim();
            if (trimmed.startsWith(":type") || trimmed.startsWith("@type")) {
                if (!(trimmed = trimmed.substring(5).trim()).startsWith(actTok) || !(trimmed = trimmed.substring(actTok.length()).trim()).startsWith(":")) continue;
                trimmed = trimmed.substring(1).trim();
                return NodeUtils.fixType(trimmed);
            }
            if (trimmed.startsWith(":param")) {
                List split;
                int i = trimmed.indexOf(58, 2);
                if (i == -1 || (split = StringUtils.split((String)(trimmed = trimmed.substring(6, i).trim()), (char)' ')).size() != 2 || !((String)split.get(1)).equals(actTok)) continue;
                possible = ((String)split.get(0)).trim();
                continue;
            }
            if (!trimmed.startsWith("@param") || !(trimmed = trimmed.substring(6).trim()).startsWith(actTok) || !(trimmed = trimmed.substring(actTok.length())).startsWith(":") || (trimmed = trimmed.substring(1).trim()).indexOf(32) != -1 || trimmed.indexOf(9) != -1) continue;
            possible = trimmed;
        }
        return NodeUtils.fixType(possible);
    }

    private static String fixType(String trimmed) {
        if (trimmed != null) {
            int i;
            if ((trimmed = trimmed.trim()).startsWith(":")) {
                trimmed = trimmed.substring(1);
            }
            if ((i = trimmed.indexOf(58)) != -1) {
                trimmed = trimmed.substring(i + 1);
            }
            FastStringBuffer ret = new FastStringBuffer(trimmed, 0);
            HashSet<Character> set = new HashSet<Character>();
            set.add(Character.valueOf('`'));
            set.add(Character.valueOf('!'));
            set.add(Character.valueOf('~'));
            trimmed = ret.removeChars(set).toString();
            i = trimmed.indexOf(32);
            if (i != -1) {
                trimmed = trimmed.substring(i + 1);
            }
        }
        return trimmed;
    }

    public static String getReturnTypeFromDocstring(SimpleNode node) {
        String nodeDocString;
        Str stringNode = NodeUtils.getNodeDocStringNode(node);
        String possible = null;
        if (stringNode != null && (nodeDocString = stringNode.s) != null) {
            Iterable iterLines = StringUtils.iterLines((String)nodeDocString);
            for (String string : iterLines) {
                String trimmed = string.trim();
                if (trimmed.startsWith(":rtype") || trimmed.startsWith("@rtype")) {
                    if ((trimmed = trimmed.substring(6).trim()).startsWith(":")) {
                        trimmed = trimmed.substring(1).trim();
                    }
                    return NodeUtils.fixType(trimmed);
                }
                if (!trimmed.startsWith("@return") && !trimmed.startsWith(":return") || !(trimmed = trimmed.substring(7).trim()).endsWith(":") || (trimmed = trimmed.substring(0, trimmed.length() - 1)).indexOf(32) != -1 || trimmed.indexOf(9) != -1) continue;
                possible = trimmed;
            }
        }
        return NodeUtils.fixType(possible);
    }
}

