/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.overview_ruler;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.python.pydev.overview_ruler.CopiedOverviewRuler;
import org.python.pydev.overview_ruler.MinimapOverviewRulerPreferencesPage;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.outline.IParsedItem;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class MinimapOverviewRuler
extends CopiedOverviewRuler {
    private Color selectionColor;
    private IPropertyChangeListener listener;
    private IPreferenceStore preferenceStore;
    private IOutlineModel fOutlineModel;
    private IPropertyChangeListener propertyListener;
    private ICallbackListener<IOutlineModel> modelListener;
    private static final Object lockStackedParameters = new Object();
    private WeakReference<StyledText> styledText;
    private final PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (!MinimapOverviewRuler.this.fCanvas.isDisposed()) {
                MinimapOverviewRuler.this.redraw();
            }
        }
    };
    private Color lastBackground;
    private Color lastForeground;
    private volatile Image baseImage;
    private volatile Image lastImage;
    private Object[] cacheKey;
    private long lastModelChange;
    private final RedrawJob redrawJob = new RedrawJob("Redraw overview ruler");
    MouseEvent lastMouseDown = null;

    private Color getSelectionColor() {
        if (this.selectionColor == null || this.selectionColor.isDisposed()) {
            this.preferenceStore = SharedUiPlugin.getDefault().getPreferenceStore();
            this.fillSelectionColorField();
            this.listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("MINIMAP_SELECTION_COLOR".equals(event.getProperty())) {
                        MinimapOverviewRuler.this.selectionColor.dispose();
                        MinimapOverviewRuler.this.selectionColor = null;
                        MinimapOverviewRuler.this.fillSelectionColorField();
                    }
                }
            };
            this.preferenceStore.addPropertyChangeListener(this.listener);
        }
        return this.selectionColor;
    }

    private void fillSelectionColorField() {
        String colorCode = this.preferenceStore.getString("MINIMAP_SELECTION_COLOR");
        RGB asRGB = StringConverter.asRGB((String)colorCode);
        this.selectionColor = new Color((Device)Display.getDefault(), asRGB);
    }

    @Override
    protected void handleDispose() {
        try {
            if (this.preferenceStore != null && this.listener != null) {
                this.preferenceStore.removePropertyChangeListener(this.listener);
                this.preferenceStore = null;
                this.listener = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.preferenceStore != null && this.propertyListener != null) {
                this.preferenceStore.removePropertyChangeListener(this.propertyListener);
                this.preferenceStore = null;
                this.listener = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.selectionColor != null) {
                this.selectionColor.dispose();
            }
            this.selectionColor = null;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.fOutlineModel != null && this.modelListener != null) {
                ICallbackWithListeners<IOutlineModel> onModelChangedListener = this.fOutlineModel.getOnModelChangedCallback();
                onModelChangedListener.unregisterListener(this.modelListener);
                this.modelListener = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        this.fOutlineModel = null;
        super.handleDispose();
    }

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static int getFirstCharPosition(String src) {
        int i = 0;
        boolean breaked = false;
        while (i < src.length()) {
            if (!Character.isWhitespace(src.charAt(i)) && src.charAt(i) != '\t') {
                ++i;
                breaked = true;
                break;
            }
            ++i;
        }
        if (!breaked) {
            ++i;
        }
        return i - 1;
    }

    public MinimapOverviewRuler(IAnnotationAccess annotationAccess, ISharedTextColors sharedColors, IOutlineModel outlineModel) {
        super(annotationAccess, MinimapOverviewRulerPreferencesPage.getMinimapWidth(), sharedColors);
        this.fOutlineModel = outlineModel;
        this.propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("MINIMAP_WIDTH".equals(event.getProperty())) {
                    MinimapOverviewRuler.this.updateWidth();
                }
            }
        };
        if (outlineModel != null) {
            this.modelListener = new ICallbackListener<IOutlineModel>(){

                public Object call(IOutlineModel obj) {
                    MinimapOverviewRuler.this.lastModelChange = System.currentTimeMillis();
                    MinimapOverviewRuler.this.update();
                    return null;
                }
            };
            ICallbackWithListeners<IOutlineModel> onModelChangedListener = outlineModel.getOnModelChangedCallback();
            onModelChangedListener.registerListener(this.modelListener);
        }
    }

    private void updateWidth() {
        this.fWidth = MinimapOverviewRulerPreferencesPage.getMinimapWidth();
    }

    @Override
    protected void doubleBufferPaint(GC dest) {
        if (this.fTextViewer != null) {
            StyledText textWidget = this.fTextViewer.getTextWidget();
            Color background = textWidget.getBackground();
            if (this.lastBackground == null || !this.lastBackground.equals((Object)background)) {
                this.fCanvas.setBackground(background);
                this.lastBackground = background;
            }
            Color foreground = textWidget.getForeground();
            if (this.lastForeground == null || !this.lastForeground.equals((Object)foreground)) {
                this.fCanvas.setForeground(foreground);
                this.lastForeground = foreground;
            }
        }
        super.doubleBufferPaint(dest);
    }

    @Override
    public Control createControl(Composite parent, ITextViewer textViewer) {
        Control ret = super.createControl(parent, textViewer);
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                MinimapOverviewRuler.this.onMouseMove(event);
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MinimapOverviewRuler.this.onDispose();
            }
        });
        StyledText textWidget = textViewer.getTextWidget();
        if (!textWidget.isDisposed()) {
            this.styledText = new WeakReference<StyledText>(textWidget);
            textWidget.addPaintListener(this.paintListener);
        }
        return ret;
    }

    private void onMouseMove(MouseEvent event) {
        if ((event.stateMask & 0x80000) != 0) {
            this.handleDrag(event);
        }
    }

    private void onDispose() {
        try {
            StyledText textWidget;
            if (this.baseImage != null && !this.baseImage.isDisposed()) {
                this.baseImage.dispose();
                this.baseImage = null;
            }
            if (this.lastImage != null && !this.lastImage.isDisposed()) {
                this.lastImage.dispose();
                this.lastImage = null;
            }
            if (this.styledText != null && (textWidget = (StyledText)this.styledText.get()) != null && !textWidget.isDisposed()) {
                textWidget.removePaintListener(this.paintListener);
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            this.redrawJob.cancel();
            this.redrawJob.disposeStackedParameters();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    @Override
    protected void doPaint1(GC paintGc) {
        IDocumentExtension4 document;
        if (this.fTextViewer != null && (document = (IDocumentExtension4)this.fTextViewer.getDocument()) != null) {
            StyledText styledText = this.fTextViewer.getTextWidget();
            Point size = this.fCanvas.getSize();
            if (size.x != 0 && size.y != 0) {
                int lineCount = super.getLineCount(styledText);
                IPreferenceStore preferenceStore = EditorsUI.getPreferenceStore();
                int marginCols = preferenceStore.getInt("printMarginColumn");
                String strColor = preferenceStore.getString("printMarginColor");
                RGB marginRgb = StringConverter.asRGB((String)strColor);
                Color marginColor = new Color((Device)Display.getCurrent(), marginRgb);
                int maxChars = (int)((double)marginCols + (double)marginCols * 0.1);
                int imageHeight = lineCount * 1;
                int imageWidth = maxChars;
                Color background = styledText.getBackground();
                boolean isDark = (double)background.getRed() * 0.21 + (double)background.getGreen() * 0.71 + (double)background.getBlue() * 0.07 <= 128.0;
                Object[] currCacheKey = new Object[]{document.getModificationStamp(), size.x, size.y, styledText.getForeground(), background, marginCols, marginRgb, this.lastModelChange};
                double scaleX = (double)size.x / (double)imageWidth;
                double scaleY = (double)size.y / (double)imageHeight;
                Transform transform = new Transform((Device)Display.getCurrent());
                transform.scale((float)scaleX, (float)scaleY);
                Color styledTextForeground = styledText.getForeground();
                if (this.baseImage == null || !Arrays.equals(this.cacheKey, currCacheKey)) {
                    this.cacheKey = currCacheKey;
                    Image tmpImage = new Image((Device)Display.getCurrent(), size.x, size.y);
                    GC gc = new GC((Drawable)tmpImage);
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    gc.setBackground(background);
                    gc.setForeground(background);
                    gc.fillRectangle(0, 0, size.x, size.y);
                    Color marginColor2 = new Color((Device)Display.getCurrent(), marginRgb);
                    this.redrawJob.cancel();
                    this.redrawJob.setParameters(new Parameters(gc, styledTextForeground, size, lineCount, marginCols, marginColor2, 1, imageHeight, transform, tmpImage));
                    this.redrawJob.schedule();
                }
                try {
                    if (this.baseImage != null && !this.baseImage.isDisposed()) {
                        if (this.lastImage != null && !this.lastImage.isDisposed()) {
                            this.lastImage.dispose();
                        }
                        Image image = new Image((Device)Display.getCurrent(), size.x, size.y);
                        GC gc2 = new GC((Drawable)image);
                        gc2.setAntialias(1);
                        try {
                            gc2.setBackground(background);
                            gc2.fillRectangle(0, 0, size.x, size.y);
                            gc2.drawImage(this.baseImage, 0, 0);
                            Rectangle clientArea = styledText.getClientArea();
                            int top = styledText.getLineIndex(0);
                            int bottom = styledText.getLineIndex(clientArea.height) + 1;
                            float[] rect = new float[]{0.0f, top * 1, imageWidth, bottom * 1 - top * 1};
                            transform.transform(rect);
                            gc2.setLineWidth(3);
                            gc2.setAlpha(30);
                            gc2.setForeground(styledTextForeground);
                            gc2.drawLine(0, 0, 0, size.y);
                            if (!isDark) {
                                gc2.setAlpha(30);
                            } else {
                                gc2.setAlpha(100);
                            }
                            Color localSelectionColor = this.getSelectionColor();
                            if (localSelectionColor.isDisposed()) {
                                localSelectionColor = styledText.getSelectionBackground();
                            }
                            gc2.setForeground(localSelectionColor);
                            gc2.setBackground(localSelectionColor);
                            gc2.fillRectangle(Math.round(rect[0]), Math.round(rect[1]), Math.round(rect[2]), Math.round(rect[3]));
                            gc2.setAlpha(255);
                            gc2.setLineWidth(1);
                            gc2.drawRectangle(Math.round(rect[0]), Math.round(rect[1]), Math.round(rect[2]) - 1, Math.round(rect[3]));
                        }
                        finally {
                            gc2.dispose();
                        }
                        this.lastImage = image;
                    }
                    if (this.lastImage != null && !this.lastImage.isDisposed()) {
                        paintGc.drawImage(this.lastImage, 0, 0);
                    }
                }
                finally {
                    marginColor.dispose();
                }
            }
        }
        super.doPaint1(paintGc);
    }

    @Override
    protected void handleMouseDown(MouseEvent event) {
        this.handleDrag(event);
        this.lastMouseDown = event;
    }

    @Override
    protected void handleMouseUp(MouseEvent event) {
        if (this.lastMouseDown != null) {
            int diff = Math.abs(this.lastMouseDown.x - event.x);
            if (diff > 3) {
                return;
            }
            diff = Math.abs(this.lastMouseDown.y - event.y);
            if (diff > 3) {
                return;
            }
            if (this.lastMouseDown.time - event.time < 1000) {
                super.handleMouseDown(event);
            }
        }
        this.lastMouseDown = null;
    }

    private void handleDrag(MouseEvent event) {
        if (this.fTextViewer != null) {
            int[] lines = this.toLineNumbers(event.y);
            int selectedLine = lines[0];
            Position p = null;
            try {
                IDocument document = this.fTextViewer.getDocument();
                IRegion lineInformation = document.getLineInformation(selectedLine);
                p = new Position(lineInformation.getOffset(), 0);
                if (p != null) {
                    StyledText styledText = this.fTextViewer.getTextWidget();
                    Rectangle clientArea = styledText.getClientArea();
                    int top = styledText.getLineIndex(0);
                    int bottom = styledText.getLineIndex(clientArea.height) + 1;
                    int middle = (int)((double)(bottom - top) / 2.0);
                    if (selectedLine < middle) {
                        this.fTextViewer.setTopIndex(0);
                    } else {
                        this.fTextViewer.setTopIndex(selectedLine - middle);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            this.fTextViewer.getTextWidget().setFocus();
        }
    }

    private static final class Parameters {
        public final GC gc;
        public final Color styledTextForeground;
        public final Point size;
        public final int lineCount;
        public final int marginCols;
        public final Color marginColor;
        public final int spacing;
        public final int imageHeight;
        public final Transform transform;
        public final Image tmpImage;

        public Parameters(GC gc, Color styledTextForeground, Point size, int lineCount, int marginCols, Color marginColor, int spacing, int imageHeight, Transform transform, Image tmpImage) {
            this.gc = gc;
            this.styledTextForeground = styledTextForeground;
            this.size = size;
            this.lineCount = lineCount;
            this.marginCols = marginCols;
            this.marginColor = marginColor;
            this.spacing = spacing;
            this.imageHeight = imageHeight;
            this.transform = transform;
            this.tmpImage = tmpImage;
        }

        public void dispose() {
            this.gc.dispose();
            this.marginColor.dispose();
            this.transform.dispose();
        }

        public boolean isDisposed() {
            if (this.gc.isDisposed()) {
                return true;
            }
            if (this.marginColor.isDisposed()) {
                return true;
            }
            return this.tmpImage.isDisposed();
        }
    }

    private final class RedrawJob
    extends Job {
        private FastStack<Parameters> stackedParameters;

        private RedrawJob(String name) {
            super(name);
            this.stackedParameters = new FastStack(20);
            this.setPriority(20);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setParameters(Parameters parameters) {
            Object object = lockStackedParameters;
            synchronized (object) {
                this.stackedParameters.push((Object)parameters);
            }
        }

        private void redrawBaseImage(Parameters parameters, IProgressMonitor monitor) {
            if (MinimapOverviewRulerPreferencesPage.getShowMinimapContents() && parameters.lineCount > 0 && parameters.size.x > 0) {
                GC gc = parameters.gc;
                gc.setForeground(parameters.styledTextForeground);
                gc.setAlpha(200);
                gc.setTransform(parameters.transform);
                IOutlineModel outlineModel = MinimapOverviewRuler.this.fOutlineModel;
                if (outlineModel != null) {
                    IParsedItem[] children;
                    IParsedItem root = outlineModel.getRoot();
                    if (root == null) {
                        Log.log((String)"Minimap overview ruler is trying to use outlineModel which was already disposed.");
                        return;
                    }
                    IParsedItem[] iParsedItemArray = children = root.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IParsedItem[] children2;
                        IParsedItem iParsedItem = iParsedItemArray[n2];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        int beginLine = iParsedItem.getBeginLine() - 1;
                        int y = (int)((float)beginLine * (float)parameters.imageHeight / (float)parameters.lineCount);
                        int x1 = iParsedItem.getBeginCol();
                        int x2 = x1 + iParsedItem.toString().length() * 5;
                        gc.drawLine(x1, y, x2 - x1, y);
                        IParsedItem[] iParsedItemArray2 = children2 = iParsedItem.getChildren();
                        int n3 = children2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IParsedItem iParsedItem2 = iParsedItemArray2[n4];
                            if (monitor.isCanceled()) {
                                return;
                            }
                            beginLine = iParsedItem2.getBeginLine() - 1;
                            y = (int)((float)beginLine * (float)parameters.imageHeight / (float)parameters.lineCount);
                            x1 = iParsedItem2.getBeginCol();
                            x2 = x1 + iParsedItem2.toString().length() * 5;
                            gc.drawLine(x1, y, x2 - x1, y);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Parameters parameters;
            block14: {
                List<Parameters> stackedParametersClone;
                Object object = lockStackedParameters;
                synchronized (object) {
                    parameters = (Parameters)this.stackedParameters.pop();
                    stackedParametersClone = this.fetchStackedParameters();
                }
                this.disposeStackedParameters(stackedParametersClone);
                if (parameters.isDisposed()) {
                    return Status.OK_STATUS;
                }
                try {
                    try {
                        this.redrawBaseImage(parameters, monitor);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                        parameters.gc.dispose();
                        parameters.marginColor.dispose();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    parameters.gc.dispose();
                    parameters.marginColor.dispose();
                    throw throwable;
                }
                parameters.gc.dispose();
                parameters.marginColor.dispose();
            }
            boolean disposeOfImage = true;
            try {
                Canvas c;
                if (!monitor.isCanceled() && (c = MinimapOverviewRuler.this.fCanvas) != null && !c.isDisposed()) {
                    disposeOfImage = false;
                    RunInUiThread.async(new Runnable(){

                        @Override
                        public void run() {
                            if (MinimapOverviewRuler.this.baseImage != null && !MinimapOverviewRuler.this.baseImage.isDisposed()) {
                                MinimapOverviewRuler.this.baseImage.dispose();
                            }
                            if (c != null && !c.isDisposed()) {
                                MinimapOverviewRuler.this.baseImage = parameters.tmpImage;
                                MinimapOverviewRuler.this.redraw();
                            } else {
                                parameters.tmpImage.dispose();
                            }
                        }
                    });
                }
            }
            finally {
                if (disposeOfImage) {
                    parameters.tmpImage.dispose();
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Parameters> fetchStackedParameters() {
            ArrayList<Parameters> stackedParametersClone = new ArrayList<Parameters>();
            Object object = lockStackedParameters;
            synchronized (object) {
                while (this.stackedParameters.size() > 0) {
                    Parameters disposeOfParameters = (Parameters)this.stackedParameters.pop();
                    stackedParametersClone.add(disposeOfParameters);
                }
            }
            return stackedParametersClone;
        }

        public void disposeStackedParameters() {
            this.disposeStackedParameters(this.fetchStackedParameters());
        }

        private void disposeStackedParameters(List<Parameters> stackedParametersClone) {
            for (Parameters disposeOfParameters : stackedParametersClone) {
                disposeOfParameters.dispose();
            }
        }
    }
}

