/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_core.utils.Reflection;

public class EditorUtils {
    public static File getFileFromEditorInput(IEditorInput editorInput) {
        File f = null;
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file != null) {
            IPath location = file.getLocation();
            if (location != null) {
                IPath path = location.makeAbsolute();
                f = path.toFile();
            }
        } else {
            try {
                if (editorInput instanceof IURIEditorInput) {
                    IURIEditorInput iuriEditorInput = (IURIEditorInput)editorInput;
                    return new File(iuriEditorInput.getURI());
                }
            }
            catch (Throwable throwable) {}
            try {
                IPath path = (IPath)Reflection.invoke((Object)editorInput, (String)"getPath", (Object[])new Object[0]);
                f = path.toFile();
            }
            catch (Throwable throwable) {}
        }
        return f;
    }

    public static Shell getShell() {
        IWorkbenchWindow activeWorkbenchWindow = EditorUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            Log.log((String)"Error. Not currently with thread access (so, there is no activeWorkbenchWindow available)");
            return null;
        }
        return activeWorkbenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        return activeWorkbenchWindow;
    }

    public static ITextEditor getActiveEditor() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof ITextEditor) {
            return (ITextEditor)activeEditor;
        }
        return null;
    }

    public static IStatusLineManager getStatusLineManager(ITextEditor editor) {
        IEditorActionBarContributor contributor = editor.getEditorSite().getActionBarContributor();
        if (!(contributor instanceof EditorActionBarContributor)) {
            return null;
        }
        IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    public static ITextSelection getTextSelection(ITextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    public static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getDocument((Object)editor.getEditorInput());
        }
        return null;
    }

    public static TextSelectionUtils createTextSelectionUtils(ITextEditor editor) {
        return new TextSelectionUtils(EditorUtils.getDocument(editor), EditorUtils.getTextSelection(editor));
    }

    public static void showInEditor(ITextEditor textEdit, Location start, Location end) {
        try {
            IDocument doc = textEdit.getDocumentProvider().getDocument((Object)textEdit.getEditorInput());
            int s = start.toOffset(doc);
            int e = end == null ? s : end.toOffset(doc);
            TextSelection sel = new TextSelection(s, e - s);
            textEdit.getSelectionProvider().setSelection((ISelection)sel);
        }
        catch (BadLocationException e1) {
            Log.log((int)4, (String)("Error setting selection:" + start + " - " + end + " - " + textEdit), (Throwable)e1);
        }
    }

    public static void showInEditor(ITextEditor textEdit, IRegion region) {
        TextSelection sel = new TextSelection(region.getOffset(), region.getLength());
        textEdit.getSelectionProvider().setSelection((ISelection)sel);
    }

    public static void showInEditor(ITextEditor textEdit, int lineNumber) {
        IDocument document;
        if (lineNumber > 0 && (document = textEdit.getDocumentProvider().getDocument((Object)textEdit.getEditorInput())) != null) {
            IRegion lineInfo = null;
            try {
                lineInfo = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {}
            if (lineInfo != null) {
                textEdit.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
            }
        }
    }

    public static IEditorPart openFile(File fileToOpen) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new RuntimeException("workbench cannot be null");
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            throw new RuntimeException("activeWorkbenchWindow cannot be null (we have to be in a ui thread for this to work)");
        }
        IWorkbenchPage wp = activeWorkbenchWindow.getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
        try {
            return IDE.openEditorOnFileStore((IWorkbenchPage)wp, (IFileStore)fileStore);
        }
        catch (Exception e) {
            Log.log((String)"Editor failed to open", (Throwable)e);
            return null;
        }
    }

    public static IWorkbenchPartSite getSite() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        return activeEditor.getSite();
    }

    public static String getEditorId(IEditorInput input, Object element) {
        IEditorDescriptor defaultEditor;
        String name = input.getName();
        if (name == null) {
            return null;
        }
        try {
            IFile iFile = (IFile)input.getAdapter(IFile.class);
            if (iFile != null && (defaultEditor = IDE.getDefaultEditor((IFile)iFile)) != null) {
                return defaultEditor.getId();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        defaultEditor = editorReg.getDefaultEditor(name);
        if (defaultEditor == null) {
            return null;
        }
        return defaultEditor.getId();
    }
}

